/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.concurrency;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.encog.EncogError;

public class TaskGroup {
    private final int id;
    private int totalTasks;
    private int completedTasks;
    private final Lock accessLock = new ReentrantLock();
    private final Condition mightBeDone = this.accessLock.newCondition();

    public TaskGroup(int id) {
        this.id = id;
        this.totalTasks = 0;
    }

    public int getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNoTasks() {
        this.accessLock.lock();
        try {
            boolean bl = this.totalTasks == this.completedTasks;
            return bl;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStarting() {
        this.accessLock.lock();
        try {
            ++this.totalTasks;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStopping() {
        this.accessLock.lock();
        try {
            ++this.completedTasks;
            if (this.completedTasks >= this.totalTasks) {
                this.mightBeDone.signal();
            }
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForComplete() {
        while (!this.getNoTasks()) {
            this.accessLock.lock();
            try {
                try {
                    if (this.getNoTasks()) continue;
                    this.mightBeDone.await();
                }
                catch (InterruptedException e) {
                    throw new EncogError(e);
                }
            }
            finally {
                this.accessLock.unlock();
            }
        }
    }
}

