/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.domainsandconstants.basetypes.Text;
import ch.ehi.umleditor.application.LauncherView;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.view.BasePanel;
import ch.softenvironment.view.DataPanel;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class IliBaseTypeTextPanel
extends BasePanel
implements DataPanel {
    private static ResourceBundle resIliBaseTypeTextPanel = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/IliBaseTypeTextPanel");
    private JRadioButton ivjRbtMultiLine = null;
    private JRadioButton ivjRbtName = null;
    private JRadioButton ivjRbtSingleLine = null;
    private JRadioButton ivjRbtURI = null;
    private JTextField ivjTxtLength = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JLabel ivjLblKind = null;
    private JLabel ivjLblMax = null;

    public IliBaseTypeTextPanel() {
        this.initialize();
    }

    private void connEtoC1(ItemEvent arg1) {
        try {
            this.length_StateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.length_StateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(FocusEvent arg1) {
        try {
            this.getTxtLength().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private int getkind() {
        if (this.getRbtSingleLine().isSelected() || this.getRbtMultiLine().isSelected()) {
            String txt = this.getTxtLength().getText();
            if (txt != null) {
                txt = txt.trim();
            }
            if (txt == null || txt.length() == 0) {
                return 1;
            }
            return 2;
        }
        if (this.getRbtName().isSelected()) {
            return 3;
        }
        if (this.getRbtURI().isSelected()) {
            return 4;
        }
        throw new DeveloperException("nothing choosed");
    }

    private JLabel getLblKind() {
        if (this.ivjLblKind == null) {
            try {
                this.ivjLblKind = new JLabel();
                this.ivjLblKind.setName("LblKind");
                this.ivjLblKind.setText(resIliBaseTypeTextPanel.getString("LblKind_text"));
                this.ivjLblKind.setBounds(10, 20, 140, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblKind;
    }

    private JLabel getLblMax() {
        if (this.ivjLblMax == null) {
            try {
                this.ivjLblMax = new JLabel();
                this.ivjLblMax.setName("LblMax");
                this.ivjLblMax.setToolTipText("Max. L\u00e4nge");
                this.ivjLblMax.setText("Max. length:");
                this.ivjLblMax.setBounds(308, 43, 140, 14);
                this.ivjLblMax.setToolTipText(this.getResourceString("LblMax_toolTipText"));
                this.ivjLblMax.setText(this.getResourceString("LblMax_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblMax;
    }

    @Override
    public Object getObject() {
        Text type = new Text();
        int kind = this.getkind();
        type.setKind(kind);
        if (kind == 2 || kind == 1) {
            type.setMultiline(this.getRbtMultiLine().isSelected());
        }
        if (kind == 2) {
            type.setMaxLength(Long.parseLong(this.getTxtLength().getText()));
        } else {
            type.setMaxLength(0L);
        }
        return type;
    }

    private JRadioButton getRbtMultiLine() {
        if (this.ivjRbtMultiLine == null) {
            try {
                this.ivjRbtMultiLine = new JRadioButton();
                this.ivjRbtMultiLine.setName("RbtMultiLine");
                this.ivjRbtMultiLine.setText("Multiline");
                this.ivjRbtMultiLine.setBounds(160, 40, 140, 22);
                this.ivjRbtMultiLine.setText(this.getResourceString("RbtMultiLine_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbtMultiLine;
    }

    private JRadioButton getRbtName() {
        if (this.ivjRbtName == null) {
            try {
                this.ivjRbtName = new JRadioButton();
                this.ivjRbtName.setName("RbtName");
                this.ivjRbtName.setText("NAME");
                this.ivjRbtName.setBounds(160, 65, 140, 22);
                this.ivjRbtName.setText(this.getResourceString("RbtName_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbtName;
    }

    private JRadioButton getRbtSingleLine() {
        if (this.ivjRbtSingleLine == null) {
            try {
                this.ivjRbtSingleLine = new JRadioButton();
                this.ivjRbtSingleLine.setName("RbtSingleLine");
                this.ivjRbtSingleLine.setText("Single line");
                this.ivjRbtSingleLine.setBounds(160, 15, 140, 22);
                this.ivjRbtSingleLine.setText(this.getResourceString("RbtSingleLine_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbtSingleLine;
    }

    private JRadioButton getRbtURI() {
        if (this.ivjRbtURI == null) {
            try {
                this.ivjRbtURI = new JRadioButton();
                this.ivjRbtURI.setName("RbtURI");
                this.ivjRbtURI.setText("URI");
                this.ivjRbtURI.setBounds(160, 90, 266, 22);
                this.ivjRbtURI.setText(this.getResourceString("RbtURI_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbtURI;
    }

    private JTextField getTxtLength() {
        if (this.ivjTxtLength == null) {
            try {
                this.ivjTxtLength = new JTextField();
                this.ivjTxtLength.setName("TxtLength");
                this.ivjTxtLength.setBounds(455, 39, 107, 20);
                this.ivjTxtLength.setEditable(false);
                this.ivjTxtLength.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtLength;
    }

    @Override
    protected void handleException(Throwable exception) {
        LauncherView.getInstance().handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getRbtMultiLine().addItemListener(this.ivjEventHandler);
        this.getRbtSingleLine().addItemListener(this.ivjEventHandler);
        this.getTxtLength().addFocusListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("IliBaseTypeTextPanel");
            this.setToolTipText("INTERLIS Basistyp <TEXT>");
            this.setLayout(null);
            this.setSize(572, 126);
            this.add((Component)this.getRbtSingleLine(), this.getRbtSingleLine().getName());
            this.add((Component)this.getRbtMultiLine(), this.getRbtMultiLine().getName());
            this.add((Component)this.getRbtName(), this.getRbtName().getName());
            this.add((Component)this.getRbtURI(), this.getRbtURI().getName());
            this.add((Component)this.getTxtLength(), this.getTxtLength().getName());
            this.add((Component)this.getLblKind(), this.getLblKind().getName());
            this.add((Component)this.getLblMax(), this.getLblMax().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setToolTipText(this.getResourceString("IliBaseTypeTextPanel_toolTipText"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRbtSingleLine());
        group.add(this.getRbtName());
        group.add(this.getRbtMultiLine());
        group.add(this.getRbtURI());
        this.getRbtSingleLine().setSelected(true);
        this.getTxtLength().setText("");
    }

    private void length_StateChanged(ItemEvent itemEvent) {
        boolean isSelected = this.getRbtMultiLine().isSelected() || this.getRbtSingleLine().isSelected();
        this.getTxtLength().setEditable(isSelected);
        this.getTxtLength().setEnabled(isSelected);
    }

    @Override
    public void setObject(Object object) {
        Text type = (Text)object;
        switch (type.getKind()) {
            case 1: {
                if (type.isMultiline()) {
                    this.getRbtMultiLine().setSelected(true);
                } else {
                    this.getRbtSingleLine().setSelected(true);
                }
                this.getTxtLength().setText("");
                break;
            }
            case 2: {
                if (type.isMultiline()) {
                    this.getRbtMultiLine().setSelected(true);
                } else {
                    this.getRbtSingleLine().setSelected(true);
                }
                this.getTxtLength().setText(Long.toString(type.getMaxLength()));
                break;
            }
            case 3: {
                this.getRbtName().setSelected(true);
                break;
            }
            case 4: {
                this.getRbtURI().setSelected(true);
                break;
            }
            default: {
                throw new DeveloperException("Unknown Kind <" + type.getKind() + ">");
            }
        }
    }

    class IvjEventHandler
    implements FocusListener,
    ItemListener {
        IvjEventHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == IliBaseTypeTextPanel.this.getTxtLength()) {
                IliBaseTypeTextPanel.this.connEtoM1(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == IliBaseTypeTextPanel.this.getRbtMultiLine()) {
                IliBaseTypeTextPanel.this.connEtoC1(e);
            }
            if (e.getSource() == IliBaseTypeTextPanel.this.getRbtSingleLine()) {
                IliBaseTypeTextPanel.this.connEtoC2(e);
            }
        }
    }
}

