/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.ZAP;

public class CommandLine {
    private static final Logger logger = Logger.getLogger(CommandLine.class);
    public static final String SESSION = "-session";
    public static final String NEW_SESSION = "-newsession";
    public static final String DAEMON = "-daemon";
    public static final String HELP = "-help";
    public static final String HELP2 = "-h";
    public static final String DIR = "-dir";
    public static final String VERSION = "-version";
    public static final String PORT = "-port";
    public static final String HOST = "-host";
    public static final String CMD = "-cmd";
    public static final String INSTALL_DIR = "-installdir";
    public static final String CONFIG = "-config";
    public static final String LOWMEM = "-lowmem";
    public static final String EXPERIMENTALDB = "-experimentaldb";
    static final String NO_USER_AGENT = "-nouseragent";
    static final String SP = "-sp";
    private boolean GUI = true;
    private boolean daemon = false;
    private boolean reportVersion = false;
    private boolean lowMem = false;
    private boolean experimentalDb = false;
    private int port = -1;
    private String host = null;
    private String[] args = null;
    private final Hashtable<String, String> configs = new Hashtable();
    private final Hashtable<String, String> keywords = new Hashtable();
    private List<CommandLineArgument[]> commandList = null;

    public CommandLine(String[] stringArray) throws Exception {
        this.args = stringArray;
        this.parseFirst(this.args);
    }

    private boolean checkPair(String[] stringArray, String string, int n) throws Exception {
        String string2 = stringArray[n];
        String string3 = null;
        if (string2 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase(string)) {
            string3 = stringArray[n + 1];
            if (string3 == null) {
                throw new Exception();
            }
            this.keywords.put(string, string3);
            stringArray[n] = null;
            stringArray[n + 1] = null;
            return true;
        }
        return false;
    }

    private boolean checkSwitch(String[] stringArray, String string, int n) throws Exception {
        String string2 = stringArray[n];
        if (string2 == null) {
            return false;
        }
        if (string2.equalsIgnoreCase(string)) {
            this.keywords.put(string, "");
            stringArray[n] = null;
            return true;
        }
        return false;
    }

    private void parseFirst(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.parseSwitchs(stringArray, i) && !this.parseKeywords(stringArray, i)) continue;
        }
    }

    public void parse(List<CommandLineArgument[]> list, Map<String, CommandLineListener> map) throws Exception {
        Object object;
        Object object2;
        int n;
        int n2;
        this.commandList = list;
        Object object3 = null;
        boolean bl = false;
        int n3 = 0;
        for (n2 = 0; n2 < this.args.length; ++n2) {
            if (this.args[n2] == null) continue;
            bl = false;
            for (n = 0; n < list.size() && !bl; ++n) {
                object2 = list.get(n);
                for (int i = 0; i < ((CommandLineArgument[])object2).length && !bl; ++i) {
                    if (this.args[n2].compareToIgnoreCase(((CommandLineArgument)object2[i]).getName()) != 0) continue;
                    if (n3 > 0) {
                        throw new Exception("Missing parameters for keyword '" + ((CommandLineArgument)object3).getName() + "'.");
                    }
                    object3 = object2[i];
                    ((CommandLineArgument)object3).setEnabled(true);
                    bl = true;
                    this.args[n2] = null;
                    n3 = ((CommandLineArgument)object3).getNumOfArguments();
                }
            }
            if (this.args[n2] != null && this.args[n2].startsWith("-") || object3 != null && n3 == 0 || bl || object3 == null) continue;
            if (((CommandLineArgument)object3).getPattern() == null || ((CommandLineArgument)object3).getPattern().matcher(this.args[n2]).find()) {
                ((CommandLineArgument)object3).getArguments().add(this.args[n2]);
                if (n3 > 0) {
                    --n3;
                }
                this.args[n2] = null;
                continue;
            }
            throw new Exception(((CommandLineArgument)object3).getErrorMessage());
        }
        if (object3 != null && n3 > 0) {
            throw new Exception("Missing parameters for keyword '" + ((CommandLineArgument)object3).getName() + "'.");
        }
        for (n2 = 0; n2 < this.args.length; ++n2) {
            String string;
            if (this.args[n2] == null || (n = this.args[n2].lastIndexOf(".")) < 0 || !((File)(object2 = new File(this.args[n2]))).exists() || !((File)object2).canRead() || (object = map.get(string = this.args[n2].substring(n + 1))) == null || !object.handleFile((File)object2)) continue;
            bl = true;
            this.args[n2] = null;
        }
        for (String string : this.args) {
            if (string == null) continue;
            if (string.startsWith("-")) {
                throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.badparam"), string));
            }
            object = new File(string);
            if (!((File)object).exists()) {
                throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.nofile"), string));
            }
            if (!((File)object).canRead()) {
                throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.noread"), string));
            }
            throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.badfile"), string));
        }
    }

    private boolean parseSwitchs(String[] stringArray, int n) throws Exception {
        boolean bl = false;
        if (this.checkSwitch(stringArray, NO_USER_AGENT, n)) {
            HttpSender.setUserAgent("");
            Constant.setEyeCatcher("");
            bl = true;
        } else if (this.checkSwitch(stringArray, SP, n)) {
            Constant.setSP(true);
            bl = true;
        } else if (this.checkSwitch(stringArray, CMD, n)) {
            this.setDaemon(false);
            this.setGUI(false);
        } else if (this.checkSwitch(stringArray, DAEMON, n)) {
            this.setDaemon(true);
            this.setGUI(false);
        } else if (this.checkSwitch(stringArray, LOWMEM, n)) {
            this.setLowMem(true);
        } else if (this.checkSwitch(stringArray, EXPERIMENTALDB, n)) {
            this.setExperimentalDb(true);
        } else if (this.checkSwitch(stringArray, HELP, n)) {
            bl = true;
            this.setGUI(false);
        } else if (this.checkSwitch(stringArray, HELP2, n)) {
            bl = true;
            this.setGUI(false);
        } else if (this.checkSwitch(stringArray, VERSION, n)) {
            this.reportVersion = true;
            this.setDaemon(false);
            this.setGUI(false);
        }
        return bl;
    }

    private boolean parseKeywords(String[] stringArray, int n) throws Exception {
        String string;
        boolean bl = false;
        if (this.checkPair(stringArray, NEW_SESSION, n)) {
            bl = true;
        } else if (this.checkPair(stringArray, SESSION, n)) {
            bl = true;
        } else if (this.checkPair(stringArray, DIR, n)) {
            Constant.setZapHome(this.keywords.get(DIR));
            bl = true;
        } else if (this.checkPair(stringArray, INSTALL_DIR, n)) {
            Constant.setZapInstall(this.keywords.get(INSTALL_DIR));
            bl = true;
        } else if (this.checkPair(stringArray, HOST, n)) {
            this.host = this.keywords.get(HOST);
            bl = true;
        } else if (this.checkPair(stringArray, PORT, n)) {
            this.port = Integer.parseInt(this.keywords.get(PORT));
            bl = true;
        } else if (this.checkPair(stringArray, CONFIG, n) && (string = this.keywords.get(CONFIG)) != null && string.indexOf("=") > 0) {
            int n2 = string.indexOf("=");
            this.configs.put(string.substring(0, n2), string.substring(n2 + 1));
            bl = true;
        }
        return bl;
    }

    public boolean isGUI() {
        return this.GUI;
    }

    public void setGUI(boolean bl) {
        this.GUI = bl;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public boolean isLowMem() {
        return this.lowMem;
    }

    public void setLowMem(boolean bl) {
        this.lowMem = bl;
    }

    public boolean isExperimentalDb() {
        return this.experimentalDb;
    }

    public void setExperimentalDb(boolean bl) {
        this.experimentalDb = bl;
    }

    public boolean isReportVersion() {
        return this.reportVersion;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public Hashtable<String, String> getConfigs() {
        return this.configs;
    }

    public String getArgument(String string) {
        return this.keywords.get(string);
    }

    public String getHelp() {
        return CommandLine.getHelp(this.commandList);
    }

    public static String getHelp(List<CommandLineArgument[]> list) {
        String string = Constant.isWindows() ? "zap.bat" : "zap.sh";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MessageFormat.format(Constant.messages.getString("cmdline.help"), string));
        if (list != null) {
            for (CommandLineArgument[] commandLineArgumentArray : list) {
                for (CommandLineArgument commandLineArgument : commandLineArgumentArray) {
                    stringBuilder.append("\t");
                    stringBuilder.append(commandLineArgument.getHelpMessage()).append("\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    public boolean isEnabled(String string) {
        String string2 = this.keywords.get(string);
        return string2 != null && string2 instanceof String;
    }

    public static void info(String string) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.out.println(string);
                break;
            }
        }
        logger.info((Object)string);
    }

    public static void error(String string) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.err.println(string);
                break;
            }
        }
        logger.error((Object)string);
    }

    public static void error(String string, Throwable throwable) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.err.println(string);
                break;
            }
        }
        logger.error((Object)string, throwable);
    }
}

