/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.apt.util.ArchiveFileObject;

public class Archive {
    public static final Archive UNKNOWN_ARCHIVE = new Archive();
    ZipFile zipFile;
    File file;
    protected Hashtable<String, ArrayList<String>> packagesCache;

    private Archive() {
    }

    public Archive(File file) throws ZipException, IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.initialize();
    }

    private void initialize() {
        this.packagesCache = new Hashtable();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().getName();
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            ArrayList<String> arrayList = this.packagesCache.get(string2);
            if (arrayList == null) {
                if (string3.length() == 0) continue;
                arrayList = new ArrayList();
                arrayList.add(string3);
                this.packagesCache.put(string2, arrayList);
                continue;
            }
            arrayList.add(string3);
        }
    }

    public ArchiveFileObject getArchiveFileObject(String string, Charset charset) {
        return new ArchiveFileObject(this.file, this.zipFile, string, charset);
    }

    public boolean contains(String string) {
        return this.zipFile.getEntry(string) != null;
    }

    public Set<String> allPackages() {
        if (this.packagesCache == null) {
            this.initialize();
        }
        return this.packagesCache.keySet();
    }

    public ArrayList<String> getTypes(String string) {
        return this.packagesCache.get(string);
    }

    public void flush() {
        this.packagesCache = null;
    }

    public void close() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
            this.packagesCache = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

