/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ValueConverter;

public class ArrayValueConverter
implements ValueConverter {
    private ValueConverter elementConverter;
    private Class elementType;

    public ArrayValueConverter(Class clazz, ValueConverter valueConverter) {
        if (valueConverter == null) {
            throw new NullPointerException("elementConverter must not be null");
        }
        if (clazz == null) {
            throw new NullPointerException("arrayClass must not be null");
        }
        this.elementType = clazz;
        this.elementConverter = valueConverter;
    }

    public String toAttributeValue(Object object) throws BeanException {
        int n = Array.getLength(object);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.elementConverter.toAttributeValue(Array.get(object, i)));
        }
        return stringBuffer.toString();
    }

    public Object toPropertyValue(String string) throws BeanException {
        Object object;
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (cSVTokenizer.hasMoreTokens()) {
            object = cSVTokenizer.nextToken();
            arrayList.add(this.elementConverter.toPropertyValue((String)object));
        }
        object = Array.newInstance(this.elementType, arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            Array.set(object, i, e);
        }
        return object;
    }
}

