/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.line;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.line.AlignmentBaseline;
import org.jfree.layouting.input.style.keys.line.BaselineShift;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class VerticalAlignReadHandler
extends OneOfConstantsReadHandler
implements CSSCompoundValueReadHandler {
    public VerticalAlignReadHandler() {
        super(true);
        this.addValue(VerticalAlign.BASELINE);
        this.addValue(VerticalAlign.BOTTOM);
        this.addValue(VerticalAlign.CENTRAL);
        this.addValue(VerticalAlign.MIDDLE);
        this.addValue(VerticalAlign.SUB);
        this.addValue(VerticalAlign.SUPER);
        this.addValue(VerticalAlign.TEXT_BOTTOM);
        this.addValue(VerticalAlign.TEXT_TOP);
        this.addValue(VerticalAlign.USE_SCRIPT);
        this.addValue(VerticalAlign.TOP);
    }

    protected CSSValue lookupValue(LexicalUnit lexicalUnit) {
        CSSValue cSSValue = super.lookupValue(lexicalUnit);
        if (cSSValue != null) {
            return cSSValue;
        }
        if (lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        return CSSValueFactory.createLengthValue(lexicalUnit);
    }

    public Map createValues(LexicalUnit lexicalUnit) {
        CSSValue cSSValue = this.lookupValue(lexicalUnit);
        HashMap<StyleKey, CSSValue> hashMap = new HashMap<StyleKey, CSSValue>();
        hashMap.put(LineStyleKeys.VERTICAL_ALIGN, cSSValue);
        hashMap.put(LineStyleKeys.ALIGNMENT_ADJUST, CSSAutoValue.getInstance());
        hashMap.put(LineStyleKeys.DOMINANT_BASELINE, CSSAutoValue.getInstance());
        if (CSSAutoValue.getInstance().equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BASELINE);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.BASELINE.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.BOTTOM.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.AFTER_EDGE);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.CENTRAL.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.CENTRAL);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.MIDDLE.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.MIDDLE);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.SUB.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.SUB);
        } else if (VerticalAlign.SUPER.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.SUPER);
        } else if (VerticalAlign.TEXT_BOTTOM.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.TEXT_AFTER_EDGE);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.TEXT_TOP.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.TEXT_BEFORE_EDGE);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.TOP.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BEFORE_EDGE);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
        } else if (VerticalAlign.USE_SCRIPT.equals(cSSValue)) {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.USE_SCRIPT);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, CSSAutoValue.getInstance());
        } else {
            hashMap.put(LineStyleKeys.ALIGNMENT_BASELINE, AlignmentBaseline.BASELINE);
            hashMap.put(LineStyleKeys.BASELINE_SHIFT, BaselineShift.BASELINE);
            hashMap.put(LineStyleKeys.ALIGNMENT_ADJUST, cSSValue);
        }
        return hashMap;
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{LineStyleKeys.VERTICAL_ALIGN, LineStyleKeys.ALIGNMENT_BASELINE, LineStyleKeys.DOMINANT_BASELINE, LineStyleKeys.ALIGNMENT_ADJUST, LineStyleKeys.BASELINE_SHIFT};
    }
}

