/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.apache.coyote.ActionCode;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Processor
extends AbstractHttp11Processor<Socket> {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    protected SSLSupport sslSupport;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11Processor(int headerBufferSize, JIoEndpoint endpoint, int maxTrailerSize, Set<String> allowedTrailerHeaders, int maxExtensionSize, int maxSwallowSize) {
        super(endpoint);
        this.inputBuffer = new InternalInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize, allowedTrailerHeaders, maxExtensionSize, maxSwallowSize);
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int disableKeepAlivePercentage) {
        this.disableKeepAlivePercentage = disableKeepAlivePercentage;
    }

    @Override
    protected boolean disableKeepAlive() {
        int threadsBusy;
        int threadRatio = -1;
        int maxThreads = this.endpoint.getMaxThreads();
        if (maxThreads > 0 && (threadsBusy = this.endpoint.getCurrentThreadsBusy()) > 0) {
            threadRatio = threadsBusy * 100 / maxThreads;
        }
        return threadRatio > this.getDisableKeepAlivePercentage();
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
        if (this.inputBuffer.lastValid == 0 && this.socketWrapper.getLastAccess() > -1L) {
            long queueTime;
            int firstReadTimeout = this.keepAliveTimeout == -1 ? 0 : ((queueTime = System.currentTimeMillis() - this.socketWrapper.getLastAccess()) >= (long)this.keepAliveTimeout ? 1 : this.keepAliveTimeout - (int)queueTime);
            ((Socket)this.socketWrapper.getSocket()).setSoTimeout(firstReadTimeout);
            if (!this.inputBuffer.fill(true)) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.endpoint.getSoTimeout() > 0) {
                this.setSocketTimeout(this.endpoint.getSoTimeout());
            } else {
                this.setSocketTimeout(0);
            }
        }
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        return false;
    }

    @Override
    protected void setSocketTimeout(int timeout) throws IOException {
        ((Socket)this.socketWrapper.getSocket()).setSoTimeout(timeout);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Socket> socketWrapper) {
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Socket> socketWrapper) {
        this.openSocket = this.keepAlive;
        return this.inputBuffer.lastValid == 0;
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void recycleInternal() {
        this.socketWrapper = null;
        this.sslSupport = null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("http11processor.comet.notsupported"));
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case REQ_SSL_ATTRIBUTE: {
                try {
                    if (this.sslSupport == null) break;
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    if ((sslO = this.sslSupport.getProtocol()) != null) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
                break;
            }
            case REQ_HOST_ADDR_ATTRIBUTE: {
                InetAddress inetAddr;
                if (this.socketWrapper == null) {
                    this.request.remoteAddr().recycle();
                    break;
                }
                if (this.socketWrapper.getRemoteAddr() == null && (inetAddr = ((Socket)this.socketWrapper.getSocket()).getInetAddress()) != null) {
                    this.socketWrapper.setRemoteAddr(inetAddr.getHostAddress());
                }
                this.request.remoteAddr().setString(this.socketWrapper.getRemoteAddr());
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                InetAddress inetAddr;
                if (this.socketWrapper == null) {
                    this.request.localName().recycle();
                    break;
                }
                if (this.socketWrapper.getLocalName() == null && (inetAddr = ((Socket)this.socketWrapper.getSocket()).getLocalAddress()) != null) {
                    this.socketWrapper.setLocalName(inetAddr.getHostName());
                }
                this.request.localName().setString(this.socketWrapper.getLocalName());
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.remoteHost().recycle();
                    break;
                }
                if (this.socketWrapper.getRemoteHost() == null) {
                    InetAddress inetAddr = ((Socket)this.socketWrapper.getSocket()).getInetAddress();
                    if (inetAddr != null) {
                        this.socketWrapper.setRemoteHost(inetAddr.getHostName());
                    }
                    if (this.socketWrapper.getRemoteHost() == null) {
                        if (this.socketWrapper.getRemoteAddr() == null && inetAddr != null) {
                            this.socketWrapper.setRemoteAddr(inetAddr.getHostAddress());
                        }
                        if (this.socketWrapper.getRemoteAddr() != null) {
                            this.socketWrapper.setRemoteHost(this.socketWrapper.getRemoteAddr());
                        }
                    }
                }
                this.request.remoteHost().setString(this.socketWrapper.getRemoteHost());
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.localAddr().recycle();
                    break;
                }
                if (this.socketWrapper.getLocalAddr() == null) {
                    this.socketWrapper.setLocalAddr(((Socket)this.socketWrapper.getSocket()).getLocalAddress().getHostAddress());
                }
                this.request.localAddr().setString(this.socketWrapper.getLocalAddr());
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.setRemotePort(0);
                    break;
                }
                if (this.socketWrapper.getRemotePort() == -1) {
                    this.socketWrapper.setRemotePort(((Socket)this.socketWrapper.getSocket()).getPort());
                }
                this.request.setRemotePort(this.socketWrapper.getRemotePort());
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.setLocalPort(0);
                    break;
                }
                if (this.socketWrapper.getLocalPort() == -1) {
                    this.socketWrapper.setLocalPort(((Socket)this.socketWrapper.getSocket()).getLocalPort());
                }
                this.request.setLocalPort(this.socketWrapper.getLocalPort());
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                if (this.sslSupport == null) break;
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                try {
                    X509Certificate[] sslO = this.sslSupport.getPeerCertificateChain(true);
                    if (sslO == null) break;
                    this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    break;
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        Exception e = new Exception();
        log.error((Object)sm.getString("http11processor.neverused"), (Throwable)e);
        return false;
    }

    @Override
    protected AbstractInputBuffer<Socket> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Socket> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSocketBuffer(int socketBuffer) {
        super.setSocketBuffer(socketBuffer);
        this.outputBuffer.setSocketBuffer(socketBuffer);
    }
}

