/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.converters.marshaller.json;

import grails.converters.JSON;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.grails.web.converters.exceptions.ConverterException;
import org.grails.web.converters.marshaller.ObjectMarshaller;
import org.grails.web.json.JSONWriter;
import org.springframework.beans.BeanUtils;

public class GenericJavaBeanMarshaller
implements ObjectMarshaller<JSON> {
    @Override
    public boolean supports(Object object) {
        return true;
    }

    @Override
    public void marshalObject(Object o, JSON json) throws ConverterException {
        JSONWriter writer = json.getWriter();
        try {
            writer.object();
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors(o.getClass())) {
                String name = property.getName();
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Object value = readMethod.invoke(o, (Object[])null);
                writer.key(name);
                json.convertAnother(value);
            }
            for (Field field : o.getClass().getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!field.isAccessible() || !Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                writer.key(field.getName());
                json.convertAnother(field.get(o));
            }
            writer.endObject();
        }
        catch (ConverterException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConverterException("Error converting Bean with class " + o.getClass().getName(), e);
        }
    }
}

