/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.xml.sax.Attributes;

class SpringPropertyAction
extends Action {
    private static final String SOURCE_ATTRIBUTE = "source";
    private final Environment environment;

    SpringPropertyAction(Environment environment) {
        this.environment = environment;
    }

    public void begin(InterpretationContext ic, String elementName, Attributes attributes) throws ActionException {
        String name = attributes.getValue("name");
        String source = attributes.getValue(SOURCE_ATTRIBUTE);
        ActionUtil.Scope scope = ActionUtil.stringToScope((String)attributes.getValue("scope"));
        if (OptionHelper.isEmpty((String)name) || OptionHelper.isEmpty((String)source)) {
            this.addError("The \"name\" and \"source\" attributes of <springProperty> must be set");
        }
        ActionUtil.setProperty((InterpretationContext)ic, (String)name, (String)this.getValue(source), (ActionUtil.Scope)scope);
    }

    private String getValue(String source) {
        if (this.environment == null) {
            this.addWarn("No Spring Environment available to resolve " + source);
            return null;
        }
        String value = this.environment.getProperty(source);
        if (value != null) {
            return value;
        }
        int lastDot = source.lastIndexOf(".");
        if (lastDot > 0) {
            String prefix = source.substring(0, lastDot + 1);
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)this.environment, prefix);
            return resolver.getProperty(source.substring(lastDot + 1));
        }
        return null;
    }

    public void end(InterpretationContext ic, String name) throws ActionException {
    }
}

