/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class BufferAutosaveRequest
extends BufferIORequest {
    public BufferAutosaveRequest(View view, Buffer buffer, Object object, VFS vFS, String string) {
        super(view, buffer, object, vFS, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void _run() {
        block14: {
            OutputStream outputStream = null;
            try {
                Object[] objectArray = new String[]{this.vfs.getFileName(this.path)};
                this.setStatus(jEdit.getProperty("vfs.status.autosave", objectArray));
                this.setCancellable(true);
                try {
                    this.buffer.readLock();
                    if (this.buffer.isDirty()) {
                        outputStream = this.vfs._createOutputStream(this.session, this.path, this.view);
                    }
                    if (outputStream != null) {
                        this.write(this.buffer, outputStream);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.log(7, this, "Unable to save " + fileNotFoundException.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    this.cleanUpIncomplete(outputStream);
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    Log.log(9, this, exception);
                    Object[] objectArray2 = new String[]{exception.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.write-error", objectArray2);
                    this.cleanUpIncomplete(outputStream);
                    break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.buffer.readUnlock();
                }
            }
            finally {
                IOUtilities.closeQuietly(outputStream);
            }
        }
    }

    private void cleanUpIncomplete(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
                outputStream = null;
                this.vfs._delete(this.session, this.path, this.view);
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
        }
    }
}

