/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.actions.SystemAction;

public class MultiFileSystem
extends FileSystem {
    static final long serialVersionUID = -767493828111559560L;
    static final String MASK = "_hidden";
    private static final int WRITE_SYSTEM_INDEX = 0;
    private FileSystem[] systems;
    private boolean propagateMasks = false;
    private transient MultiFileObject root;
    private transient Set<String> rootAttributes;
    private final ThreadLocal<Boolean> insideWritableLayer = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    protected MultiFileSystem() {
        this(new FileSystem[0]);
    }

    public MultiFileSystem(FileSystem ... fileSystemArray) {
        this.systems = (FileSystem[])fileSystemArray.clone();
    }

    @Override
    public void refresh(boolean bl) {
        Enumeration<AbstractFolder> enumeration = this.getMultiRoot().existingSubFiles(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = enumeration.nextElement();
            fileObject.refresh(bl);
        }
    }

    protected final void setDelegates(FileSystem ... fileSystemArray) {
        if (Arrays.equals(fileSystemArray, this.systems)) {
            return;
        }
        MultiFileObject.freeAllAttribCaches();
        FileSystem[] fileSystemArray2 = this.systems;
        this.systems = fileSystemArray;
        this.rootAttributes = null;
        this.getMultiRoot().updateAllAfterSetDelegates(fileSystemArray2);
        List<FileSystem> list = Arrays.asList(fileSystemArray2);
        List<FileSystem> list2 = Arrays.asList(this.systems);
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>(list);
        hashSet.removeAll(list2);
        for (FileSystem object2 : hashSet) {
            if (object2 == null) continue;
            object2.removeNotify();
        }
        HashSet<FileSystem> hashSet2 = new HashSet<FileSystem>(list2);
        hashSet2.removeAll(list);
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (fileSystem == null) continue;
            fileSystem.addNotify();
        }
    }

    protected final FileSystem[] getDelegates() {
        return this.systems;
    }

    public final boolean getPropagateMasks() {
        return this.propagateMasks;
    }

    protected final void setPropagateMasks(boolean bl) {
        this.propagateMasks = bl;
    }

    @Override
    public boolean isReadOnly() {
        return 0 >= this.systems.length || this.systems[0] == null || this.systems[0].isReadOnly();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MultiFileSystem.class, (String)"CTL_MultiFileSystem");
    }

    @Override
    public FileObject getRoot() {
        return this.getMultiRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiFileObject getMultiRoot() {
        MultiFileObject multiFileObject = null;
        Class<MultiFileSystem> clazz = MultiFileSystem.class;
        synchronized (MultiFileSystem.class) {
            if (this.root != null) {
                multiFileObject = this.root;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (multiFileObject == null) {
                multiFileObject = new MultiFileObject(this);
            }
            clazz = MultiFileSystem.class;
            synchronized (MultiFileSystem.class) {
                if (this.root == null) {
                    this.root = multiFileObject;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.root;
            }
        }
    }

    @Override
    public SystemAction[] getActions() {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> hashSet = new HashSet<SystemAction>(101);
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null) continue;
            SystemAction[] systemActionArray = fileSystemArray[i].getActions();
            for (int j = 0; j < systemActionArray.length; ++j) {
                if (!hashSet.add(systemActionArray[j])) continue;
                arrayList.add(systemActionArray[j]);
            }
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    @Override
    public SystemAction[] getActions(Set<FileObject> set) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> hashSet = new HashSet<SystemAction>(101);
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null) continue;
            SystemAction[] systemActionArray = fileSystemArray[i].getActions(set);
            for (int j = 0; j < systemActionArray.length; ++j) {
                if (!hashSet.add(systemActionArray[j])) continue;
                arrayList.add(systemActionArray[j]);
            }
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    @Override
    @Deprecated
    public FileObject find(String string, String string2, String string3) {
        Enumeration enumeration = NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(string, "."), String.class, (boolean)true);
        Enumeration enumeration2 = string2 == null || string3 == null ? enumeration : Enumerations.concat((Enumeration)enumeration, (Enumeration)Enumerations.singleton((Object)(string2 + '.' + string3)));
        return this.getMultiRoot().find(enumeration2);
    }

    @Override
    public FileObject findResource(String string) {
        if (string.length() == 0) {
            return this.getMultiRoot();
        }
        Enumeration enumeration = NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(string, "/"), String.class, (boolean)true);
        return this.getMultiRoot().find(enumeration);
    }

    protected final FileSystem findSystem(FileObject fileObject) throws IllegalArgumentException {
        try {
            if (fileObject instanceof MultiFileObject) {
                MultiFileObject multiFileObject = (MultiFileObject)fileObject;
                return multiFileObject.getLeaderFileSystem();
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return this;
        }
        throw new IllegalArgumentException(fileObject.getPath());
    }

    protected final void hideResource(String string, boolean bl) throws IOException {
        if (bl) {
            this.maskFile(this.createWritableOn(string), string);
        } else {
            this.unmaskFile(this.createWritableOn(string), string);
        }
    }

    protected static Enumeration<String> hiddenFiles(FileObject fileObject, boolean bl) {
        Enumeration<? extends FileObject> enumeration = fileObject.getChildren(bl);
        class OnlyHidden
        implements Enumerations.Processor<FileObject, String> {
            OnlyHidden() {
            }

            public String process(FileObject fileObject, Collection<FileObject> collection) {
                String string = fileObject.getPath();
                if (string.endsWith(MultiFileSystem.MASK)) {
                    return string.substring(0, string.length() - MultiFileSystem.MASK.length());
                }
                return null;
            }
        }
        return Enumerations.filter(enumeration, (Enumerations.Processor)new OnlyHidden());
    }

    protected FileObject findResourceOn(FileSystem fileSystem, String string) {
        return fileSystem.findResource(string);
    }

    protected FileSystem createWritableOn(String string) throws IOException {
        if (this.isReadOnly()) {
            throw new FSException(NbBundle.getMessage(MultiFileSystem.class, (String)"EXC_FSisRO", (Object)this.getDisplayName()));
        }
        return this.systems[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileSystem writableLayer(String string) {
        if (!this.insideWritableLayer.get().booleanValue() && !this.isReadOnly()) {
            this.insideWritableLayer.set(true);
            try {
                FileSystem fileSystem = this.createWritableOn(string);
                return fileSystem;
            }
            catch (IOException iOException) {
            }
            finally {
                this.insideWritableLayer.set(false);
            }
        }
        return this.systems.length > 0 ? this.systems[0] : null;
    }

    protected FileSystem createWritableOnForRename(String string, String string2) throws IOException {
        return this.createWritableOn(string2);
    }

    protected Set<? extends FileSystem> createLocksOn(String string) throws IOException {
        FileSystem fileSystem = this.createWritableOn(string);
        return Collections.singleton(fileSystem);
    }

    protected void notifyMigration(FileObject fileObject) {
    }

    protected void markUnimportant(FileObject fileObject) {
    }

    @Override
    @Deprecated
    public void prepareEnvironment(FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null) continue;
            try {
                fileSystemArray[i].prepareEnvironment(environment);
                continue;
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        for (int i = 0; i < this.systems.length; ++i) {
            if (this.systems[i] == null) continue;
            this.systems[i].addNotify();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        for (int i = 0; i < this.systems.length; ++i) {
            if (this.systems[i] == null) continue;
            this.systems[i].removeNotify();
        }
    }

    Enumeration<FileObject> delegates(final String string) {
        Enumeration enumeration = Enumerations.array((Object[])this.systems);
        class Resources
        implements Enumerations.Processor<FileSystem, FileObject> {
            Resources() {
            }

            public FileObject process(FileSystem fileSystem, Collection<FileSystem> collection) {
                if (fileSystem == null) {
                    return null;
                }
                return MultiFileSystem.this.findResourceOn(fileSystem, string);
            }
        }
        return Enumerations.filter((Enumeration)enumeration, (Enumerations.Processor)new Resources());
    }

    void maskFile(FileSystem fileSystem, String string) throws IOException {
        FileObject fileObject = this.findResourceOn(fileSystem, fileSystem.getRoot().getPath());
        FileUtil.createData(fileObject, string + MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmaskFile(FileSystem fileSystem, String string) throws IOException {
        FileObject fileObject = this.findResourceOn(fileSystem, string + MASK);
        if (fileObject != null) {
            FileLock fileLock = fileObject.lock();
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    void unmaskFileOnAll(FileSystem fileSystem, String string) throws IOException {
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null || fileSystemArray[i].isReadOnly()) continue;
            this.unmaskFile(fileSystemArray[i], string);
            if (fileSystemArray[i] != fileSystem) continue;
            return;
        }
    }

    static boolean isMaskFile(FileObject fileObject) {
        return fileObject.getExt().endsWith(MASK);
    }

    boolean canHaveRootAttributeOnReadOnlyFS(String string) {
        Set<String> set = this.rootAttributes;
        if (set == null) {
            set = new HashSet<String>();
            for (FileSystem fileSystem : this.getDelegates()) {
                if (fileSystem == null || !fileSystem.isReadOnly()) continue;
                Enumeration<String> enumeration = fileSystem.getRoot().getAttributes();
                while (enumeration.hasMoreElements()) {
                    set.add(enumeration.nextElement());
                }
                this.rootAttributes = set;
            }
        }
        if (set == Collections.emptySet()) {
            return true;
        }
        return set.contains(string);
    }
}

