/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class AffineRed
extends AbstractRed {
    RenderingHints hints;
    AffineTransform src2me;
    AffineTransform me2src;

    public AffineTransform getTransform() {
        return (AffineTransform)this.src2me.clone();
    }

    public CachableRed getSource() {
        return (CachableRed)this.getSources().get(0);
    }

    public AffineRed(CachableRed cachableRed, AffineTransform affineTransform, RenderingHints renderingHints) {
        this.src2me = affineTransform;
        this.hints = renderingHints;
        try {
            this.me2src = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.me2src = null;
        }
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = affineTransform.createTransformedShape(rectangle).getBounds();
        ColorModel colorModel = AffineRed.fixColorModel(cachableRed);
        SampleModel sampleModel = this.fixSampleModel(cachableRed, colorModel, rectangle2);
        Point2D point2D = new Point2D.Float(cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset());
        point2D = affineTransform.transform(point2D, null);
        this.init(cachableRed, rectangle2, colorModel, sampleModel, (int)point2D.getX(), (int)point2D.getY(), null);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        PadRed.ZeroRecter zeroRecter = PadRed.ZeroRecter.getZeroRecter(writableRaster);
        zeroRecter.zeroRect(new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()));
        this.genRect(writableRaster);
        return writableRaster;
    }

    @Override
    public Raster getTile(int n, int n2) {
        if (this.me2src == null) {
            return null;
        }
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        Point point = new Point(n3, n4);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public void genRect(WritableRaster writableRaster) {
        if (this.me2src == null) {
            return;
        }
        Rectangle rectangle = this.me2src.createTransformedShape(writableRaster.getBounds()).getBounds();
        rectangle.setBounds(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        if (!rectangle.intersects(cachableRed.getBounds())) {
            return;
        }
        Raster raster = cachableRed.getData(rectangle.intersection(cachableRed.getBounds()));
        if (raster == null) {
            return;
        }
        AffineTransform affineTransform = (AffineTransform)this.src2me.clone();
        affineTransform.concatenate(AffineTransform.getTranslateInstance(raster.getMinX(), raster.getMinY()));
        Point2D point2D = new Point2D.Float(writableRaster.getMinX(), writableRaster.getMinY());
        point2D = this.me2src.transform(point2D, null);
        Point2D point2D2 = new Point2D.Double(point2D.getX() - (double)raster.getMinX(), point2D.getY() - (double)raster.getMinY());
        point2D2 = affineTransform.transform(point2D2, null);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-point2D2.getX(), -point2D2.getY()));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.hints);
        ColorModel colorModel = cachableRed.getColorModel();
        ColorModel colorModel2 = this.getColorModel();
        WritableRaster writableRaster2 = (WritableRaster)raster;
        colorModel = GraphicsUtil.coerceData(writableRaster2, colorModel, true);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster2.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel2, writableRaster.createWritableTranslatedChild(0, 0), colorModel2.isAlphaPremultiplied(), null);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            if (!colorModel.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceColorModel(colorModel, true);
            }
            return colorModel;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n = cachableRed.getSampleModel().getNumBands() + 1;
        if (n == 4) {
            int[] nArray = new int[4];
            for (int i = 0; i < n - 1; ++i) {
                nArray[i] = 0xFF0000 >> 8 * i;
            }
            nArray[3] = 255 << 8 * (n - 1);
            return new DirectColorModel(colorSpace, 8 * n, nArray[0], nArray[1], nArray[2], nArray[3], true, 3);
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 8;
        }
        return new ComponentColorModel(colorSpace, nArray, true, true, 3, 3);
    }

    protected SampleModel fixSampleModel(CachableRed cachableRed, ColorModel colorModel, Rectangle rectangle) {
        int n;
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n2 = AbstractTiledRed.getDefaultTileSize();
        int n3 = sampleModel.getWidth();
        if (n3 < n2) {
            n3 = n2;
        }
        if (n3 > rectangle.width) {
            n3 = rectangle.width;
        }
        if ((n = sampleModel.getHeight()) < n2) {
            n = n2;
        }
        if (n > rectangle.height) {
            n = rectangle.height;
        }
        if (n3 <= 0 || n <= 0) {
            n3 = 1;
            n = 1;
        }
        return colorModel.createCompatibleSampleModel(n3, n);
    }
}

