/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is BlueGriffon.
 *
 * The Initial Developer of the Original Code is
 * Disruptive Innovations SARL.
 * Portions created by the Initial Developer are Copyright (C) 2016
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Daniel Glazman <daniel.glazman@disruptive-innovations.com>, Original author
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = ["kCSS_PROPERTIES"];

var kCSS_PROPERTIES = {
  "lastUpdate": "20160501",
  "source": "http://disruptive-innovations.com/zoo/cssproperties",
  "engines": ["blink", "gecko", "servo", "vivliostyle", "weasyprint", "webkit"],
  "properties": {
    "color": {
      "blink": "color",
      "gecko": "color",
      "servo": "color",
      "vivliostyle": "color",
      "weasyprint": "color",
      "webkit": "color"
    },
    "direction": {
      "blink": "direction",
      "gecko": "direction",
      "servo": "direction",
      "vivliostyle": "direction",
      "weasyprint": "direction",
      "webkit": "direction"
    },
    "font-family": {
      "blink": "font-family",
      "gecko": "font-family",
      "servo": "font-family",
      "vivliostyle": "font-family",
      "weasyprint": "font-family",
      "webkit": "font-family"
    },
    "font-kerning": {
      "blink": "font-kerning",
      "gecko": "font-kerning",
      "vivliostyle": "font-kerning",
      "webkit": "font-kerning"
    },
    "font-size": {
      "blink": "font-size",
      "gecko": "font-size",
      "servo": "font-size",
      "vivliostyle": "font-size",
      "weasyprint": "font-size",
      "webkit": "font-size"
    },
    "font-size-adjust": {
      "blink": "font-size-adjust",
      "gecko": "font-size-adjust"
    },
    "font-stretch": {
      "blink": "font-stretch",
      "gecko": "font-stretch",
      "servo": "font-stretch",
      "weasyprint": "font-stretch",
      "webkit": "font-stretch"
    },
    "font-style": {
      "blink": "font-style",
      "gecko": "font-style",
      "servo": "font-style",
      "vivliostyle": "font-style",
      "weasyprint": "font-style",
      "webkit": "font-style"
    },
    "font-variant": {
      "blink": "font-variant",
      "gecko": "font-variant",
      "servo": "font-variant",
      "vivliostyle": "font-variant",
      "weasyprint": "font-variant",
      "webkit": "font-variant"
    },
    "font-variant-ligatures": {
      "blink": "font-variant-ligatures",
      "gecko": "font-variant-ligatures",
      "webkit": "font-variant-ligatures"
    },
    "font-weight": {
      "blink": "font-weight",
      "gecko": "font-weight",
      "servo": "font-weight",
      "vivliostyle": "font-weight",
      "weasyprint": "font-weight",
      "webkit": "font-weight"
    },
    "font-feature-settings": {
      "blink": "-webkit-font-feature-settings",
      "gecko": "font-feature-settings",
      "vivliostyle": "font-feature-settings",
      "webkit": "font-feature-settings"
    },
    "font-smoothing": {
      "blink": "-webkit-font-smoothing",
      "webkit": "-webkit-font-smoothing"
    },
    "locale": {
      "blink": "-webkit-locale",
      "webkit": "-webkit-locale"
    },
    "text-orientation": {
      "blink": "-epub-text-orientation",
      "gecko": "text-orientation",
      "servo": "text-orientation",
      "vivliostyle": "text-orientation",
      "webkit": "-epub-text-orientation"
    },
    "writing-mode": {
      "blink": "writing-mode",
      "gecko": "writing-mode",
      "servo": "writing-mode",
      "vivliostyle": "writing-mode",
      "webkit": "writing-mode"
    },
    "text-rendering": {
      "blink": "text-rendering",
      "gecko": "text-rendering",
      "servo": "text-rendering",
      "webkit": "text-rendering"
    },
    "zoom": {
      "blink": "zoom",
      "webkit": "zoom"
    },
    "align-content": {
      "blink": "align-content",
      "gecko": "align-content",
      "vivliostyle": "align-content",
      "webkit": "align-content"
    },
    "align-items": {
      "blink": "align-items",
      "gecko": "align-items",
      "vivliostyle": "align-items",
      "webkit": "align-items"
    },
    "alignment-baseline": {
      "blink": "alignment-baseline",
      "webkit": "alignment-baseline"
    },
    "align-self": {
      "blink": "align-self",
      "gecko": "align-self",
      "vivliostyle": "align-self",
      "webkit": "align-self"
    },
    "animation-delay": {
      "blink": "animation-delay",
      "gecko": "animation-delay",
      "webkit": "animation-delay"
    },
    "animation-direction": {
      "blink": "animation-direction",
      "gecko": "animation-direction",
      "webkit": "animation-direction"
    },
    "animation-duration": {
      "blink": "animation-duration",
      "gecko": "animation-duration",
      "webkit": "animation-duration"
    },
    "animation-fill-mode": {
      "blink": "animation-fill-mode",
      "gecko": "animation-fill-mode",
      "webkit": "animation-fill-mode"
    },
    "animation-iteration-count": {
      "blink": "animation-iteration-count",
      "gecko": "animation-iteration-count",
      "webkit": "animation-iteration-count"
    },
    "animation-name": {
      "blink": "animation-name",
      "gecko": "animation-name",
      "webkit": "animation-name"
    },
    "animation-play-state": {
      "blink": "animation-play-state",
      "gecko": "animation-play-state",
      "webkit": "animation-play-state"
    },
    "animation-timing-function": {
      "blink": "animation-timing-function",
      "gecko": "animation-timing-function",
      "webkit": "animation-timing-function"
    },
    "backdrop-filter": {
      "blink": "backdrop-filter",
      "webkit": "-webkit-backdrop-filter"
    },
    "backface-visibility": {
      "blink": "backface-visibility",
      "gecko": "backface-visibility",
      "servo": "backface-visibility",
      "vivliostyle": "backface-visibility",
      "webkit": "-webkit-backface-visibility"
    },
    "background-attachment": {
      "blink": "background-attachment",
      "gecko": "background-attachment",
      "servo": "background-attachment",
      "vivliostyle": "background-attachment",
      "weasyprint": "background-attachment",
      "webkit": "background-attachment"
    },
    "background-blend-mode": {
      "blink": "background-blend-mode",
      "gecko": "background-blend-mode",
      "webkit": "background-blend-mode"
    },
    "background-clip": {
      "blink": "background-clip",
      "gecko": "background-clip",
      "servo": "background-clip",
      "vivliostyle": "background-clip",
      "weasyprint": "background-clip",
      "webkit": "background-clip"
    },
    "background-color": {
      "blink": "background-color",
      "gecko": "background-color",
      "servo": "background-color",
      "vivliostyle": "background-color",
      "weasyprint": "background-color",
      "webkit": "background-color"
    },
    "background-image": {
      "blink": "background-image",
      "gecko": "background-image",
      "servo": "background-image",
      "vivliostyle": "background-image",
      "weasyprint": "background-image",
      "webkit": "background-image"
    },
    "background-origin": {
      "blink": "background-origin",
      "gecko": "background-origin",
      "servo": "background-origin",
      "vivliostyle": "background-origin",
      "weasyprint": "background-origin",
      "webkit": "background-origin"
    },
    "background-position-x": {
      "blink": "background-position-x",
      "webkit": "background-position-x"
    },
    "background-position-y": {
      "blink": "background-position-y",
      "webkit": "background-position-y"
    },
    "background-repeat-x": {
      "blink": "background-repeat-x",
      "webkit": "background-repeat-x"
    },
    "background-repeat-y": {
      "blink": "background-repeat-y",
      "webkit": "background-repeat-y"
    },
    "background-size": {
      "blink": "background-size",
      "gecko": "background-size",
      "servo": "background-size",
      "vivliostyle": "background-size",
      "weasyprint": "background-size",
      "webkit": "background-size"
    },
    "baseline-shift": {
      "blink": "baseline-shift",
      "webkit": "baseline-shift"
    },
    "border-bottom-color": {
      "blink": "border-bottom-color",
      "gecko": "border-bottom-color",
      "servo": "border-bottom-color",
      "vivliostyle": "border-bottom-color",
      "weasyprint": "border-bottom-color",
      "webkit": "border-bottom-color"
    },
    "border-bottom-left-radius": {
      "blink": "border-bottom-left-radius",
      "gecko": "border-bottom-left-radius",
      "servo": "border-bottom-left-radius",
      "vivliostyle": "border-bottom-left-radius",
      "weasyprint": "border-bottom-left-radius",
      "webkit": "border-bottom-left-radius"
    },
    "border-bottom-right-radius": {
      "blink": "border-bottom-right-radius",
      "gecko": "border-bottom-right-radius",
      "servo": "border-bottom-right-radius",
      "vivliostyle": "border-bottom-right-radius",
      "weasyprint": "border-bottom-right-radius",
      "webkit": "border-bottom-right-radius"
    },
    "border-bottom-style": {
      "blink": "border-bottom-style",
      "gecko": "border-bottom-style",
      "servo": "border-bottom-style",
      "vivliostyle": "border-bottom-style",
      "weasyprint": "border-bottom-style",
      "webkit": "border-bottom-style"
    },
    "border-bottom-width": {
      "blink": "border-bottom-width",
      "gecko": "border-bottom-width",
      "servo": "border-bottom-width",
      "vivliostyle": "border-bottom-width",
      "weasyprint": "border-bottom-width",
      "webkit": "border-bottom-width"
    },
    "border-collapse": {
      "blink": "border-collapse",
      "gecko": "border-collapse",
      "servo": "border-collapse",
      "vivliostyle": "border-collapse",
      "weasyprint": "border-collapse",
      "webkit": "border-collapse"
    },
    "border-image-outset": {
      "blink": "border-image-outset",
      "gecko": "border-image-outset",
      "vivliostyle": "border-image-outset",
      "webkit": "border-image-outset"
    },
    "border-image-repeat": {
      "blink": "border-image-repeat",
      "gecko": "border-image-repeat",
      "vivliostyle": "border-image-repeat",
      "webkit": "border-image-repeat"
    },
    "border-image-slice": {
      "blink": "border-image-slice",
      "gecko": "border-image-slice",
      "vivliostyle": "border-image-slice",
      "webkit": "border-image-slice"
    },
    "border-image-source": {
      "blink": "border-image-source",
      "gecko": "border-image-source",
      "vivliostyle": "border-image-source",
      "webkit": "border-image-source"
    },
    "border-image-width": {
      "blink": "border-image-width",
      "gecko": "border-image-width",
      "vivliostyle": "border-image-width",
      "webkit": "border-image-width"
    },
    "border-left-color": {
      "blink": "border-left-color",
      "gecko": "border-left-color",
      "servo": "border-left-color",
      "vivliostyle": "border-left-color",
      "weasyprint": "border-left-color",
      "webkit": "border-left-color"
    },
    "border-left-style": {
      "blink": "border-left-style",
      "gecko": "border-left-style",
      "servo": "border-left-style",
      "vivliostyle": "border-left-style",
      "weasyprint": "border-left-style",
      "webkit": "border-left-style"
    },
    "border-left-width": {
      "blink": "border-left-width",
      "gecko": "border-left-width",
      "servo": "border-left-width",
      "vivliostyle": "border-left-width",
      "weasyprint": "border-left-width",
      "webkit": "border-left-width"
    },
    "border-right-color": {
      "blink": "border-right-color",
      "gecko": "border-right-color",
      "servo": "border-right-color",
      "vivliostyle": "border-right-color",
      "weasyprint": "border-right-color",
      "webkit": "border-right-color"
    },
    "border-right-style": {
      "blink": "border-right-style",
      "gecko": "border-right-style",
      "servo": "border-right-style",
      "vivliostyle": "border-right-style",
      "weasyprint": "border-right-style",
      "webkit": "border-right-style"
    },
    "border-right-width": {
      "blink": "border-right-width",
      "gecko": "border-right-width",
      "servo": "border-right-width",
      "vivliostyle": "border-right-width",
      "weasyprint": "border-right-width",
      "webkit": "border-right-width"
    },
    "border-top-color": {
      "blink": "border-top-color",
      "gecko": "border-top-color",
      "servo": "border-top-color",
      "vivliostyle": "border-top-color",
      "weasyprint": "border-top-color",
      "webkit": "border-top-color"
    },
    "border-top-left-radius": {
      "blink": "border-top-left-radius",
      "gecko": "border-top-left-radius",
      "servo": "border-top-left-radius",
      "vivliostyle": "border-top-left-radius",
      "weasyprint": "border-top-left-radius",
      "webkit": "border-top-left-radius"
    },
    "border-top-right-radius": {
      "blink": "border-top-right-radius",
      "gecko": "border-top-right-radius",
      "servo": "border-top-right-radius",
      "vivliostyle": "border-top-right-radius",
      "weasyprint": "border-top-right-radius",
      "webkit": "border-top-right-radius"
    },
    "border-top-style": {
      "blink": "border-top-style",
      "gecko": "border-top-style",
      "servo": "border-top-style",
      "vivliostyle": "border-top-style",
      "weasyprint": "border-top-style",
      "webkit": "border-top-style"
    },
    "border-top-width": {
      "blink": "border-top-width",
      "gecko": "border-top-width",
      "servo": "border-top-width",
      "vivliostyle": "border-top-width",
      "weasyprint": "border-top-width",
      "webkit": "border-top-width"
    },
    "bottom": {
      "blink": "bottom",
      "gecko": "bottom",
      "servo": "bottom",
      "vivliostyle": "bottom",
      "weasyprint": "bottom",
      "webkit": "bottom"
    },
    "box-shadow": {
      "blink": "box-shadow",
      "gecko": "box-shadow",
      "servo": "box-shadow",
      "vivliostyle": "box-shadow",
      "webkit": "box-shadow"
    },
    "box-sizing": {
      "blink": "box-sizing",
      "gecko": "box-sizing",
      "servo": "box-sizing",
      "vivliostyle": "box-sizing",
      "weasyprint": "box-sizing",
      "webkit": "box-sizing"
    },
    "buffered-rendering": {
      "blink": "buffered-rendering",
      "webkit": "buffered-rendering"
    },
    "caption-side": {
      "blink": "caption-side",
      "gecko": "caption-side",
      "servo": "caption-side",
      "vivliostyle": "caption-side",
      "weasyprint": "caption-side",
      "webkit": "caption-side"
    },
    "clear": {
      "blink": "clear",
      "gecko": "clear",
      "servo": "clear",
      "vivliostyle": "clear",
      "weasyprint": "clear",
      "webkit": "clear"
    },
    "clip": {
      "blink": "clip",
      "gecko": "clip",
      "servo": "clip",
      "vivliostyle": "clip",
      "weasyprint": "clip",
      "webkit": "clip"
    },
    "clip-path": {
      "blink": "clip-path",
      "gecko": "clip-path",
      "webkit": "clip-path"
    },
    "clip-rule": {
      "blink": "clip-rule",
      "gecko": "clip-rule",
      "webkit": "clip-rule"
    },
    "color-interpolation": {
      "blink": "color-interpolation",
      "gecko": "color-interpolation",
      "webkit": "color-interpolation"
    },
    "color-interpolation-filters": {
      "blink": "color-interpolation-filters",
      "gecko": "color-interpolation-filters",
      "webkit": "color-interpolation-filters"
    },
    "color-rendering": {
      "blink": "color-rendering",
      "webkit": "color-rendering"
    },
    "column-fill": {
      "blink": "column-fill",
      "gecko": "-moz-column-fill",
      "vivliostyle": "column-fill",
      "webkit": "column-fill"
    },
    "content": {
      "blink": "content",
      "gecko": "content",
      "servo": "content",
      "vivliostyle": "content",
      "weasyprint": "content",
      "webkit": "content"
    },
    "counter-increment": {
      "blink": "counter-increment",
      "gecko": "counter-increment",
      "servo": "counter-increment",
      "vivliostyle": "counter-increment",
      "weasyprint": "counter-increment",
      "webkit": "counter-increment"
    },
    "counter-reset": {
      "blink": "counter-reset",
      "gecko": "counter-reset",
      "servo": "counter-reset",
      "vivliostyle": "counter-reset",
      "weasyprint": "counter-reset",
      "webkit": "counter-reset"
    },
    "cursor": {
      "blink": "cursor",
      "gecko": "cursor",
      "servo": "cursor",
      "vivliostyle": "cursor",
      "webkit": "cursor"
    },
    "cx": {
      "blink": "cx",
      "webkit": "cx"
    },
    "cy": {
      "blink": "cy",
      "webkit": "cy"
    },
    "display": {
      "blink": "display",
      "gecko": "display",
      "servo": "display",
      "vivliostyle": "display",
      "weasyprint": "display",
      "webkit": "display"
    },
    "dominant-baseline": {
      "blink": "dominant-baseline",
      "gecko": "dominant-baseline",
      "webkit": "dominant-baseline"
    },
    "empty-cells": {
      "blink": "empty-cells",
      "gecko": "empty-cells",
      "servo": "empty-cells",
      "vivliostyle": "empty-cells",
      "weasyprint": "empty-cells",
      "webkit": "empty-cells"
    },
    "fill": {
      "blink": "fill",
      "gecko": "fill",
      "webkit": "fill"
    },
    "fill-opacity": {
      "blink": "fill-opacity",
      "gecko": "fill-opacity",
      "webkit": "fill-opacity"
    },
    "fill-rule": {
      "blink": "fill-rule",
      "gecko": "fill-rule",
      "webkit": "fill-rule"
    },
    "filter": {
      "blink": "filter",
      "gecko": "filter",
      "servo": "filter",
      "vivliostyle": "filter",
      "webkit": "filter"
    },
    "flex-basis": {
      "blink": "flex-basis",
      "gecko": "flex-basis",
      "vivliostyle": "flex-basis",
      "webkit": "flex-basis"
    },
    "flex-direction": {
      "blink": "flex-direction",
      "gecko": "flex-direction",
      "servo": "flex-direction",
      "vivliostyle": "flex-direction",
      "webkit": "flex-direction"
    },
    "flex-grow": {
      "blink": "flex-grow",
      "gecko": "flex-grow",
      "vivliostyle": "flex-grow",
      "webkit": "flex-grow"
    },
    "flex-shrink": {
      "blink": "flex-shrink",
      "gecko": "flex-shrink",
      "vivliostyle": "flex-shrink",
      "webkit": "flex-shrink"
    },
    "flex-wrap": {
      "blink": "flex-wrap",
      "gecko": "flex-wrap",
      "vivliostyle": "flex-wrap",
      "webkit": "flex-wrap"
    },
    "float": {
      "blink": "float",
      "gecko": "float",
      "servo": "float",
      "vivliostyle": "float",
      "weasyprint": "float",
      "webkit": "float"
    },
    "flood-color": {
      "blink": "flood-color",
      "gecko": "flood-color",
      "webkit": "flood-color"
    },
    "flood-opacity": {
      "blink": "flood-opacity",
      "gecko": "flood-opacity",
      "webkit": "flood-opacity"
    },
    "glyph-orientation-horizontal": {
      "blink": "glyph-orientation-horizontal",
      "webkit": "glyph-orientation-horizontal"
    },
    "glyph-orientation-vertical": {
      "blink": "glyph-orientation-vertical",
      "webkit": "glyph-orientation-vertical"
    },
    "grid-auto-columns": {
      "blink": "grid-auto-columns",
      "gecko": "grid-auto-columns",
      "webkit": "-webkit-grid-auto-columns"
    },
    "grid-auto-flow": {
      "blink": "grid-auto-flow",
      "gecko": "grid-auto-flow",
      "webkit": "-webkit-grid-auto-flow"
    },
    "grid-auto-rows": {
      "blink": "grid-auto-rows",
      "gecko": "grid-auto-rows",
      "webkit": "-webkit-grid-auto-rows"
    },
    "grid-column-end": {
      "blink": "grid-column-end",
      "gecko": "grid-column-end",
      "webkit": "-webkit-grid-column-end"
    },
    "grid-column-start": {
      "blink": "grid-column-start",
      "gecko": "grid-column-start",
      "webkit": "-webkit-grid-column-start"
    },
    "grid-row-end": {
      "blink": "grid-row-end",
      "gecko": "grid-row-end",
      "webkit": "-webkit-grid-row-end"
    },
    "grid-row-start": {
      "blink": "grid-row-start",
      "gecko": "grid-row-start",
      "webkit": "-webkit-grid-row-start"
    },
    "grid-template-areas": {
      "blink": "grid-template-areas",
      "gecko": "grid-template-areas",
      "webkit": "-webkit-grid-template-areas"
    },
    "grid-template-columns": {
      "blink": "grid-template-columns",
      "gecko": "grid-template-columns",
      "webkit": "-webkit-grid-template-columns"
    },
    "grid-template-rows": {
      "blink": "grid-template-rows",
      "gecko": "grid-template-rows",
      "webkit": "-webkit-grid-template-rows"
    },
    "height": {
      "blink": "height",
      "gecko": "height",
      "servo": "height",
      "vivliostyle": "height",
      "weasyprint": "height",
      "webkit": "height"
    },
    "image-rendering": {
      "blink": "image-rendering",
      "gecko": "image-rendering",
      "servo": "image-rendering",
      "weasyprint": "image-rendering",
      "webkit": "image-rendering"
    },
    "image-orientation": {
      "blink": "image-orientation",
      "gecko": "image-orientation",
      "webkit": "image-orientation"
    },
    "isolation": {
      "blink": "isolation",
      "gecko": "isolation",
      "webkit": "isolation"
    },
    "justify-content": {
      "blink": "justify-content",
      "gecko": "justify-content",
      "vivliostyle": "justify-content",
      "webkit": "justify-content"
    },
    "justify-items": {
      "blink": "justify-items",
      "gecko": "justify-items",
      "webkit": "justify-items"
    },
    "justify-self": {
      "blink": "justify-self",
      "gecko": "justify-self",
      "webkit": "justify-self"
    },
    "left": {
      "blink": "left",
      "gecko": "left",
      "servo": "left",
      "vivliostyle": "left",
      "weasyprint": "left",
      "webkit": "left"
    },
    "letter-spacing": {
      "blink": "letter-spacing",
      "gecko": "letter-spacing",
      "servo": "letter-spacing",
      "vivliostyle": "letter-spacing",
      "weasyprint": "letter-spacing",
      "webkit": "letter-spacing"
    },
    "lighting-color": {
      "blink": "lighting-color",
      "gecko": "lighting-color",
      "webkit": "lighting-color"
    },
    "line-height": {
      "blink": "line-height",
      "gecko": "line-height",
      "servo": "line-height",
      "vivliostyle": "line-height",
      "weasyprint": "line-height",
      "webkit": "line-height"
    },
    "list-style-image": {
      "blink": "list-style-image",
      "gecko": "list-style-image",
      "servo": "list-style-image",
      "vivliostyle": "list-style-image",
      "weasyprint": "list-style-image",
      "webkit": "list-style-image"
    },
    "list-style-position": {
      "blink": "list-style-position",
      "gecko": "list-style-position",
      "servo": "list-style-position",
      "vivliostyle": "list-style-position",
      "weasyprint": "list-style-position",
      "webkit": "list-style-position"
    },
    "list-style-type": {
      "blink": "list-style-type",
      "gecko": "list-style-type",
      "servo": "list-style-type",
      "vivliostyle": "list-style-type",
      "weasyprint": "list-style-type",
      "webkit": "list-style-type"
    },
    "margin-bottom": {
      "blink": "margin-bottom",
      "gecko": "margin-bottom",
      "servo": "margin-bottom",
      "vivliostyle": "margin-bottom",
      "weasyprint": "margin-bottom",
      "webkit": "margin-bottom"
    },
    "margin-left": {
      "blink": "margin-left",
      "gecko": "margin-left",
      "servo": "margin-left",
      "vivliostyle": "margin-left",
      "weasyprint": "margin-left",
      "webkit": "margin-left"
    },
    "margin-right": {
      "blink": "margin-right",
      "gecko": "margin-right",
      "servo": "margin-right",
      "vivliostyle": "margin-right",
      "weasyprint": "margin-right",
      "webkit": "margin-right"
    },
    "margin-top": {
      "blink": "margin-top",
      "gecko": "margin-top",
      "servo": "margin-top",
      "vivliostyle": "margin-top",
      "weasyprint": "margin-top",
      "webkit": "margin-top"
    },
    "marker-end": {
      "blink": "marker-end",
      "gecko": "marker-end",
      "webkit": "marker-end"
    },
    "marker-mid": {
      "blink": "marker-mid",
      "gecko": "marker-mid",
      "webkit": "marker-mid"
    },
    "marker-start": {
      "blink": "marker-start",
      "gecko": "marker-start",
      "webkit": "marker-start"
    },
    "mask": {
      "blink": "mask",
      "gecko": "mask",
      "webkit": "mask"
    },
    "mask-source-type": {
      "blink": "mask-source-type",
      "webkit": "-webkit-mask-source-type"
    },
    "mask-type": {
      "blink": "mask-type",
      "gecko": "mask-type",
      "webkit": "mask-type"
    },
    "max-height": {
      "blink": "max-height",
      "gecko": "max-height",
      "servo": "max-height",
      "vivliostyle": "max-height",
      "weasyprint": "max-height",
      "webkit": "max-height"
    },
    "max-width": {
      "blink": "max-width",
      "gecko": "max-width",
      "servo": "max-width",
      "vivliostyle": "max-width",
      "weasyprint": "max-width",
      "webkit": "max-width"
    },
    "min-height": {
      "blink": "min-height",
      "gecko": "min-height",
      "servo": "min-height",
      "vivliostyle": "min-height",
      "weasyprint": "min-height",
      "webkit": "min-height"
    },
    "min-width": {
      "blink": "min-width",
      "gecko": "min-width",
      "servo": "min-width",
      "vivliostyle": "min-width",
      "weasyprint": "min-width",
      "webkit": "min-width"
    },
    "mix-blend-mode": {
      "blink": "mix-blend-mode",
      "gecko": "mix-blend-mode",
      "servo": "mix-blend-mode",
      "webkit": "mix-blend-mode"
    },
    "motion-offset": {
      "blink": "motion-offset"
    },
    "motion-path": {
      "blink": "motion-path"
    },
    "motion-rotation": {
      "blink": "motion-rotation"
    },
    "object-fit": {
      "blink": "object-fit",
      "gecko": "object-fit",
      "vivliostyle": "object-fit",
      "webkit": "object-fit"
    },
    "object-position": {
      "blink": "object-position",
      "gecko": "object-position",
      "vivliostyle": "object-position",
      "webkit": "object-position"
    },
    "opacity": {
      "blink": "opacity",
      "gecko": "opacity",
      "servo": "opacity",
      "vivliostyle": "opacity",
      "weasyprint": "opacity",
      "webkit": "opacity"
    },
    "order": {
      "blink": "order",
      "gecko": "order",
      "vivliostyle": "order",
      "webkit": "order"
    },
    "orphans": {
      "blink": "orphans",
      "vivliostyle": "orphans",
      "weasyprint": "orphans",
      "webkit": "orphans"
    },
    "outline-color": {
      "blink": "outline-color",
      "gecko": "outline-color",
      "servo": "outline-color",
      "vivliostyle": "outline-color",
      "weasyprint": "outline-color",
      "webkit": "outline-color"
    },
    "outline-offset": {
      "blink": "outline-offset",
      "gecko": "outline-offset",
      "servo": "outline-offset",
      "vivliostyle": "outline-offset",
      "webkit": "outline-offset"
    },
    "outline-style": {
      "blink": "outline-style",
      "gecko": "outline-style",
      "servo": "outline-style",
      "vivliostyle": "outline-style",
      "weasyprint": "outline-style",
      "webkit": "outline-style"
    },
    "outline-width": {
      "blink": "outline-width",
      "gecko": "outline-width",
      "servo": "outline-width",
      "vivliostyle": "outline-width",
      "weasyprint": "outline-width",
      "webkit": "outline-width"
    },
    "overflow-wrap": {
      "blink": "overflow-wrap",
      "servo": "overflow-wrap",
      "vivliostyle": "overflow-wrap",
      "weasyprint": "overflow-wrap",
      "webkit": "overflow-wrap"
    },
    "overflow-x": {
      "blink": "overflow-x",
      "gecko": "overflow-x",
      "servo": "overflow-x",
      "webkit": "overflow-x"
    },
    "overflow-y": {
      "blink": "overflow-y",
      "gecko": "overflow-y",
      "servo": "overflow-y",
      "webkit": "overflow-y"
    },
    "padding-bottom": {
      "blink": "padding-bottom",
      "gecko": "padding-bottom",
      "servo": "padding-bottom",
      "vivliostyle": "padding-bottom",
      "weasyprint": "padding-bottom",
      "webkit": "padding-bottom"
    },
    "padding-left": {
      "blink": "padding-left",
      "gecko": "padding-left",
      "servo": "padding-left",
      "vivliostyle": "padding-left",
      "weasyprint": "padding-left",
      "webkit": "padding-left"
    },
    "padding-right": {
      "blink": "padding-right",
      "gecko": "padding-right",
      "servo": "padding-right",
      "vivliostyle": "padding-right",
      "weasyprint": "padding-right",
      "webkit": "padding-right"
    },
    "padding-top": {
      "blink": "padding-top",
      "gecko": "padding-top",
      "servo": "padding-top",
      "vivliostyle": "padding-top",
      "weasyprint": "padding-top",
      "webkit": "padding-top"
    },
    "page-break-after": {
      "blink": "page-break-after",
      "gecko": "page-break-after",
      "vivliostyle": "page-break-after",
      "weasyprint": "page-break-after",
      "webkit": "page-break-after"
    },
    "page-break-before": {
      "blink": "page-break-before",
      "gecko": "page-break-before",
      "vivliostyle": "page-break-before",
      "weasyprint": "page-break-before",
      "webkit": "page-break-before"
    },
    "page-break-inside": {
      "blink": "page-break-inside",
      "gecko": "page-break-inside",
      "vivliostyle": "page-break-inside",
      "weasyprint": "page-break-inside",
      "webkit": "page-break-inside"
    },
    "paint-order": {
      "blink": "paint-order",
      "gecko": "paint-order",
      "webkit": "paint-order"
    },
    "perspective": {
      "blink": "perspective",
      "gecko": "perspective",
      "servo": "perspective",
      "webkit": "perspective"
    },
    "perspective-origin": {
      "blink": "perspective-origin",
      "gecko": "perspective-origin",
      "servo": "perspective-origin",
      "webkit": "perspective-origin"
    },
    "pointer-events": {
      "blink": "pointer-events",
      "gecko": "pointer-events",
      "servo": "pointer-events",
      "webkit": "pointer-events"
    },
    "position": {
      "blink": "position",
      "gecko": "position",
      "servo": "position",
      "vivliostyle": "position",
      "weasyprint": "position",
      "webkit": "position"
    },
    "quotes": {
      "blink": "quotes",
      "gecko": "quotes",
      "servo": "quotes",
      "vivliostyle": "quotes",
      "weasyprint": "quotes",
      "webkit": "quotes"
    },
    "resize": {
      "blink": "resize",
      "gecko": "resize",
      "webkit": "resize"
    },
    "right": {
      "blink": "right",
      "gecko": "right",
      "servo": "right",
      "vivliostyle": "right",
      "weasyprint": "right",
      "webkit": "right"
    },
    "r": {
      "blink": "r",
      "webkit": "r"
    },
    "rx": {
      "blink": "rx",
      "webkit": "rx"
    },
    "ry": {
      "blink": "ry",
      "webkit": "ry"
    },
    "scroll-behavior": {
      "blink": "scroll-behavior",
      "gecko": "scroll-behavior"
    },
    "scroll-snap-type": {
      "blink": "scroll-snap-type",
      "gecko": "scroll-snap-type",
      "webkit": "-webkit-scroll-snap-type"
    },
    "scroll-snap-points-x": {
      "blink": "scroll-snap-points-x",
      "gecko": "scroll-snap-points-x",
      "webkit": "-webkit-scroll-snap-points-x"
    },
    "scroll-snap-points-y": {
      "blink": "scroll-snap-points-y",
      "gecko": "scroll-snap-points-y",
      "webkit": "-webkit-scroll-snap-points-y"
    },
    "scroll-snap-destination": {
      "blink": "scroll-snap-destination",
      "gecko": "scroll-snap-destination",
      "webkit": "-webkit-scroll-snap-destination"
    },
    "scroll-snap-coordinate": {
      "blink": "scroll-snap-coordinate",
      "gecko": "scroll-snap-coordinate",
      "webkit": "-webkit-scroll-snap-coordinate"
    },
    "shape-image-threshold": {
      "blink": "shape-image-threshold",
      "webkit": "-webkit-shape-image-threshold"
    },
    "shape-margin": {
      "blink": "shape-margin",
      "webkit": "-webkit-shape-margin"
    },
    "shape-outside": {
      "blink": "shape-outside",
      "vivliostyle": "shape-outside",
      "webkit": "-webkit-shape-outside"
    },
    "shape-rendering": {
      "blink": "shape-rendering",
      "gecko": "shape-rendering",
      "webkit": "shape-rendering"
    },
    "size": {
      "blink": "size",
      "vivliostyle": "size",
      "weasyprint": "size",
      "webkit": "size"
    },
    "speak": {
      "blink": "speak",
      "webkit": "speak"
    },
    "stop-color": {
      "blink": "stop-color",
      "gecko": "stop-color",
      "webkit": "stop-color"
    },
    "stop-opacity": {
      "blink": "stop-opacity",
      "gecko": "stop-opacity",
      "webkit": "stop-opacity"
    },
    "stroke": {
      "blink": "stroke",
      "gecko": "stroke",
      "webkit": "stroke"
    },
    "stroke-dasharray": {
      "blink": "stroke-dasharray",
      "gecko": "stroke-dasharray",
      "webkit": "stroke-dasharray"
    },
    "stroke-dashoffset": {
      "blink": "stroke-dashoffset",
      "gecko": "stroke-dashoffset",
      "webkit": "stroke-dashoffset"
    },
    "stroke-linecap": {
      "blink": "stroke-linecap",
      "gecko": "stroke-linecap",
      "webkit": "stroke-linecap"
    },
    "stroke-linejoin": {
      "blink": "stroke-linejoin",
      "gecko": "stroke-linejoin",
      "webkit": "stroke-linejoin"
    },
    "stroke-miterlimit": {
      "blink": "stroke-miterlimit",
      "gecko": "stroke-miterlimit",
      "webkit": "stroke-miterlimit"
    },
    "stroke-opacity": {
      "blink": "stroke-opacity",
      "gecko": "stroke-opacity",
      "webkit": "stroke-opacity"
    },
    "stroke-width": {
      "blink": "stroke-width",
      "gecko": "stroke-width",
      "webkit": "stroke-width"
    },
    "table-layout": {
      "blink": "table-layout",
      "gecko": "table-layout",
      "servo": "table-layout",
      "vivliostyle": "table-layout",
      "weasyprint": "table-layout",
      "webkit": "table-layout"
    },
    "tab-size": {
      "blink": "tab-size",
      "gecko": "-moz-tab-size",
      "vivliostyle": "tab-size",
      "webkit": "tab-size"
    },
    "text-align": {
      "blink": "text-align",
      "gecko": "text-align",
      "servo": "text-align",
      "vivliostyle": "text-align",
      "weasyprint": "text-align",
      "webkit": "text-align"
    },
    "text-align-last": {
      "blink": "text-align-last",
      "gecko": "-moz-text-align-last",
      "vivliostyle": "text-align-last",
      "webkit": "-webkit-text-align-last"
    },
    "text-anchor": {
      "blink": "text-anchor",
      "gecko": "text-anchor",
      "webkit": "text-anchor"
    },
    "text-decoration": {
      "blink": "text-decoration",
      "gecko": "text-decoration",
      "servo": "text-decoration",
      "vivliostyle": "text-decoration",
      "weasyprint": "text-decoration",
      "webkit": "text-decoration"
    },
    "text-decoration-color": {
      "blink": "text-decoration-color",
      "gecko": "text-decoration-color",
      "vivliostyle": "text-decoration-color",
      "webkit": "-webkit-text-decoration-color"
    },
    "text-decoration-line": {
      "blink": "text-decoration-line",
      "gecko": "text-decoration-line",
      "vivliostyle": "text-decoration-line",
      "webkit": "-webkit-text-decoration-line"
    },
    "text-decoration-style": {
      "blink": "text-decoration-style",
      "gecko": "text-decoration-style",
      "vivliostyle": "text-decoration-style",
      "webkit": "-webkit-text-decoration-style"
    },
    "text-indent": {
      "blink": "text-indent",
      "gecko": "text-indent",
      "servo": "text-indent",
      "vivliostyle": "text-indent",
      "weasyprint": "text-indent",
      "webkit": "text-indent"
    },
    "text-justify": {
      "blink": "text-justify",
      "servo": "text-justify",
      "vivliostyle": "text-justify",
      "webkit": "-webkit-text-justify"
    },
    "text-overflow": {
      "blink": "text-overflow",
      "gecko": "text-overflow",
      "servo": "text-overflow",
      "vivliostyle": "text-overflow",
      "webkit": "text-overflow"
    },
    "text-shadow": {
      "blink": "text-shadow",
      "gecko": "text-shadow",
      "servo": "text-shadow",
      "vivliostyle": "text-shadow",
      "webkit": "text-shadow"
    },
    "text-transform": {
      "blink": "text-transform",
      "gecko": "text-transform",
      "servo": "text-transform",
      "vivliostyle": "text-transform",
      "weasyprint": "text-transform",
      "webkit": "text-transform"
    },
    "text-underline-position": {
      "blink": "text-underline-position",
      "vivliostyle": "text-underline-position",
      "webkit": "-webkit-text-underline-position"
    },
    "top": {
      "blink": "top",
      "gecko": "top",
      "servo": "top",
      "vivliostyle": "top",
      "weasyprint": "top",
      "webkit": "top"
    },
    "touch-action": {
      "blink": "touch-action",
      "gecko": "touch-action",
      "vivliostyle": "touch-action",
      "webkit": "touch-action"
    },
    "transform": {
      "blink": "transform",
      "gecko": "transform",
      "servo": "transform",
      "vivliostyle": "transform",
      "weasyprint": "transform",
      "webkit": "transform"
    },
    "transform-origin": {
      "blink": "transform-origin",
      "gecko": "transform-origin",
      "servo": "transform-origin",
      "vivliostyle": "transform-origin",
      "weasyprint": "transform-origin",
      "webkit": "transform-origin"
    },
    "transform-style": {
      "blink": "transform-style",
      "gecko": "transform-style",
      "servo": "transform-style",
      "webkit": "transform-style"
    },
    "translate": {
      "blink": "translate"
    },
    "rotate": {
      "blink": "rotate"
    },
    "scale": {
      "blink": "scale"
    },
    "transition-delay": {
      "blink": "transition-delay",
      "gecko": "transition-delay",
      "servo": "transition-delay",
      "webkit": "transition-delay"
    },
    "transition-duration": {
      "blink": "transition-duration",
      "gecko": "transition-duration",
      "servo": "transition-duration",
      "webkit": "transition-duration"
    },
    "transition-property": {
      "blink": "transition-property",
      "gecko": "transition-property",
      "servo": "transition-property",
      "webkit": "transition-property"
    },
    "transition-timing-function": {
      "blink": "transition-timing-function",
      "gecko": "transition-timing-function",
      "servo": "transition-timing-function",
      "webkit": "transition-timing-function"
    },
    "unicode-bidi": {
      "blink": "unicode-bidi",
      "gecko": "unicode-bidi",
      "servo": "unicode-bidi",
      "vivliostyle": "unicode-bidi",
      "weasyprint": "unicode-bidi",
      "webkit": "unicode-bidi"
    },
    "vector-effect": {
      "blink": "vector-effect",
      "gecko": "vector-effect",
      "webkit": "vector-effect"
    },
    "vertical-align": {
      "blink": "vertical-align",
      "gecko": "vertical-align",
      "servo": "vertical-align",
      "vivliostyle": "vertical-align",
      "weasyprint": "vertical-align",
      "webkit": "vertical-align"
    },
    "visibility": {
      "blink": "visibility",
      "gecko": "visibility",
      "servo": "visibility",
      "vivliostyle": "visibility",
      "weasyprint": "visibility",
      "webkit": "visibility"
    },
    "x": {
      "blink": "x",
      "webkit": "x"
    },
    "y": {
      "blink": "y",
      "webkit": "y"
    },
    "appearance": {
      "blink": "-webkit-appearance",
      "gecko": "-moz-appearance",
      "webkit": "-webkit-appearance"
    },
    "app-region": {
      "blink": "-webkit-app-region"
    },
    "background-composite": {
      "blink": "-webkit-background-composite",
      "webkit": "-webkit-background-composite"
    },
    "border-horizontal-spacing": {
      "blink": "-webkit-border-horizontal-spacing",
      "webkit": "-webkit-border-horizontal-spacing"
    },
    "border-image": {
      "blink": "border-image",
      "gecko": "border-image",
      "vivliostyle": "border-image",
      "webkit": "border-image"
    },
    "border-vertical-spacing": {
      "blink": "-webkit-border-vertical-spacing",
      "webkit": "-webkit-border-vertical-spacing"
    },
    "box-align": {
      "blink": "-webkit-box-align",
      "gecko": "-moz-box-align",
      "webkit": "-webkit-box-align"
    },
    "box-decoration-break": {
      "blink": "-webkit-box-decoration-break",
      "gecko": "box-decoration-break",
      "vivliostyle": "box-decoration-break",
      "webkit": "-webkit-box-decoration-break"
    },
    "box-direction": {
      "blink": "-webkit-box-direction",
      "gecko": "-moz-box-direction",
      "webkit": "-webkit-box-direction"
    },
    "box-flex": {
      "blink": "-webkit-box-flex",
      "gecko": "-moz-box-flex",
      "webkit": "-webkit-box-flex"
    },
    "box-flex-group": {
      "blink": "-webkit-box-flex-group",
      "webkit": "-webkit-box-flex-group"
    },
    "box-lines": {
      "blink": "-webkit-box-lines",
      "webkit": "-webkit-box-lines"
    },
    "box-ordinal-group": {
      "blink": "-webkit-box-ordinal-group",
      "gecko": "-moz-box-ordinal-group",
      "webkit": "-webkit-box-ordinal-group"
    },
    "box-orient": {
      "blink": "-webkit-box-orient",
      "gecko": "-moz-box-orient",
      "webkit": "-webkit-box-orient"
    },
    "box-pack": {
      "blink": "-webkit-box-pack",
      "gecko": "-moz-box-pack",
      "webkit": "-webkit-box-pack"
    },
    "box-reflect": {
      "blink": "-webkit-box-reflect",
      "webkit": "-webkit-box-reflect"
    },
    "column-break-after": {
      "blink": "-webkit-column-break-after",
      "webkit": "-webkit-column-break-after"
    },
    "column-break-before": {
      "blink": "-webkit-column-break-before",
      "webkit": "-webkit-column-break-before"
    },
    "column-break-inside": {
      "blink": "-webkit-column-break-inside",
      "webkit": "-webkit-column-break-inside"
    },
    "column-count": {
      "blink": "-webkit-column-count",
      "gecko": "-moz-column-count",
      "servo": "column-count",
      "vivliostyle": "column-count",
      "webkit": "column-count"
    },
    "column-gap": {
      "blink": "-webkit-column-gap",
      "gecko": "-moz-column-gap",
      "servo": "column-gap",
      "vivliostyle": "column-gap",
      "webkit": "column-gap"
    },
    "column-rule-color": {
      "blink": "-webkit-column-rule-color",
      "gecko": "-moz-column-rule-color",
      "vivliostyle": "column-rule-color",
      "webkit": "column-rule-color"
    },
    "column-rule-style": {
      "blink": "-webkit-column-rule-style",
      "gecko": "-moz-column-rule-style",
      "vivliostyle": "column-rule-style",
      "webkit": "column-rule-style"
    },
    "column-rule-width": {
      "blink": "-webkit-column-rule-width",
      "gecko": "-moz-column-rule-width",
      "vivliostyle": "column-rule-width",
      "webkit": "column-rule-width"
    },
    "column-span": {
      "blink": "-webkit-column-span",
      "vivliostyle": "column-span",
      "webkit": "column-span"
    },
    "column-width": {
      "blink": "-webkit-column-width",
      "gecko": "-moz-column-width",
      "servo": "column-width",
      "vivliostyle": "column-width",
      "webkit": "column-width"
    },
    "highlight": {
      "blink": "-webkit-highlight"
    },
    "hyphenate-character": {
      "blink": "-webkit-hyphenate-character",
      "weasyprint": "hyphenate-character",
      "webkit": "-webkit-hyphenate-character"
    },
    "line-break": {
      "blink": "-webkit-line-break",
      "vivliostyle": "line-break",
      "webkit": "-webkit-line-break"
    },
    "line-clamp": {
      "blink": "-webkit-line-clamp",
      "webkit": "-webkit-line-clamp"
    },
    "margin-after-collapse": {
      "blink": "-webkit-margin-after-collapse",
      "webkit": "-webkit-margin-after-collapse"
    },
    "margin-before-collapse": {
      "blink": "-webkit-margin-before-collapse",
      "webkit": "-webkit-margin-before-collapse"
    },
    "margin-bottom-collapse": {
      "blink": "-webkit-margin-bottom-collapse",
      "webkit": "-webkit-margin-bottom-collapse"
    },
    "margin-top-collapse": {
      "blink": "-webkit-margin-top-collapse",
      "webkit": "-webkit-margin-top-collapse"
    },
    "mask-box-image-outset": {
      "blink": "-webkit-mask-box-image-outset",
      "webkit": "-webkit-mask-box-image-outset"
    },
    "mask-box-image-repeat": {
      "blink": "-webkit-mask-box-image-repeat",
      "webkit": "-webkit-mask-box-image-repeat"
    },
    "mask-box-image-slice": {
      "blink": "-webkit-mask-box-image-slice",
      "webkit": "-webkit-mask-box-image-slice"
    },
    "mask-box-image-source": {
      "blink": "-webkit-mask-box-image-source",
      "webkit": "-webkit-mask-box-image-source"
    },
    "mask-box-image-width": {
      "blink": "-webkit-mask-box-image-width",
      "webkit": "-webkit-mask-box-image-width"
    },
    "mask-clip": {
      "blink": "-webkit-mask-clip",
      "gecko": "mask-clip",
      "webkit": "-webkit-mask-clip"
    },
    "mask-composite": {
      "blink": "-webkit-mask-composite",
      "gecko": "mask-composite",
      "webkit": "-webkit-mask-composite"
    },
    "mask-image": {
      "blink": "-webkit-mask-image",
      "gecko": "mask-image",
      "webkit": "-webkit-mask-image"
    },
    "mask-origin": {
      "blink": "-webkit-mask-origin",
      "gecko": "mask-origin",
      "webkit": "-webkit-mask-origin"
    },
    "mask-position-x": {
      "blink": "-webkit-mask-position-x",
      "webkit": "-webkit-mask-position-x"
    },
    "mask-position-y": {
      "blink": "-webkit-mask-position-y",
      "webkit": "-webkit-mask-position-y"
    },
    "mask-repeat-x": {
      "blink": "-webkit-mask-repeat-x",
      "webkit": "-webkit-mask-repeat-x"
    },
    "mask-repeat-y": {
      "blink": "-webkit-mask-repeat-y",
      "webkit": "-webkit-mask-repeat-y"
    },
    "mask-size": {
      "blink": "-webkit-mask-size",
      "gecko": "mask-size",
      "webkit": "-webkit-mask-size"
    },
    "perspective-origin-x": {
      "blink": "-webkit-perspective-origin-x",
      "webkit": "perspective-origin-x"
    },
    "perspective-origin-y": {
      "blink": "-webkit-perspective-origin-y",
      "webkit": "perspective-origin-y"
    },
    "print-color-adjust": {
      "blink": "-webkit-print-color-adjust",
      "webkit": "-webkit-print-color-adjust"
    },
    "rtl-ordering": {
      "blink": "-webkit-rtl-ordering",
      "webkit": "-webkit-rtl-ordering"
    },
    "ruby-position": {
      "blink": "-webkit-ruby-position",
      "gecko": "ruby-position",
      "vivliostyle": "ruby-position",
      "webkit": "-webkit-ruby-position"
    },
    "tap-highlight-color": {
      "blink": "-webkit-tap-highlight-color",
      "webkit": "-webkit-tap-highlight-color"
    },
    "text-combine": {
      "blink": "-epub-text-combine",
      "vivliostyle": "text-combine",
      "webkit": "-epub-text-combine"
    },
    "text-emphasis-color": {
      "blink": "-epub-text-emphasis-color",
      "gecko": "text-emphasis-color",
      "vivliostyle": "text-emphasis-color",
      "webkit": "text-emphasis-color"
    },
    "text-emphasis-position": {
      "blink": "-webkit-text-emphasis-position",
      "gecko": "text-emphasis-position",
      "vivliostyle": "text-emphasis-position",
      "webkit": "text-emphasis-position"
    },
    "text-emphasis-style": {
      "blink": "-epub-text-emphasis-style",
      "gecko": "text-emphasis-style",
      "vivliostyle": "text-emphasis-style",
      "webkit": "text-emphasis-style"
    },
    "text-fill-color": {
      "blink": "-webkit-text-fill-color",
      "gecko": "-webkit-text-fill-color",
      "webkit": "-webkit-text-fill-color"
    },
    "text-security": {
      "blink": "-webkit-text-security",
      "webkit": "-webkit-text-security"
    },
    "text-stroke-color": {
      "blink": "-webkit-text-stroke-color",
      "gecko": "-webkit-text-stroke-color",
      "webkit": "-webkit-text-stroke-color"
    },
    "text-stroke-width": {
      "blink": "-webkit-text-stroke-width",
      "gecko": "-webkit-text-stroke-width",
      "webkit": "-webkit-text-stroke-width"
    },
    "transform-origin-x": {
      "blink": "-webkit-transform-origin-x",
      "webkit": "transform-origin-x"
    },
    "transform-origin-y": {
      "blink": "-webkit-transform-origin-y",
      "webkit": "transform-origin-y"
    },
    "transform-origin-z": {
      "blink": "-webkit-transform-origin-z",
      "webkit": "transform-origin-z"
    },
    "user-drag": {
      "blink": "-webkit-user-drag",
      "webkit": "-webkit-user-drag"
    },
    "user-modify": {
      "blink": "-webkit-user-modify",
      "gecko": "-moz-user-modify",
      "webkit": "-webkit-user-modify"
    },
    "user-select": {
      "blink": "-webkit-user-select",
      "gecko": "-moz-user-select",
      "webkit": "-webkit-user-select"
    },
    "white-space": {
      "blink": "white-space",
      "gecko": "white-space",
      "servo": "white-space",
      "vivliostyle": "white-space",
      "weasyprint": "white-space",
      "webkit": "white-space"
    },
    "widows": {
      "blink": "widows",
      "vivliostyle": "widows",
      "weasyprint": "widows",
      "webkit": "widows"
    },
    "width": {
      "blink": "width",
      "gecko": "width",
      "servo": "width",
      "vivliostyle": "width",
      "weasyprint": "width",
      "webkit": "width"
    },
    "will-change": {
      "blink": "will-change",
      "gecko": "will-change",
      "webkit": "will-change"
    },
    "word-break": {
      "blink": "word-break",
      "gecko": "word-break",
      "servo": "word-break",
      "vivliostyle": "word-break",
      "webkit": "word-break"
    },
    "word-spacing": {
      "blink": "word-spacing",
      "gecko": "word-spacing",
      "servo": "word-spacing",
      "vivliostyle": "word-spacing",
      "weasyprint": "word-spacing",
      "webkit": "word-spacing"
    },
    "word-wrap": {
      "blink": "word-wrap",
      "gecko": "word-wrap",
      "servo": "word-wrap",
      "vivliostyle": "word-wrap",
      "webkit": "word-wrap"
    },
    "z-index": {
      "blink": "z-index",
      "gecko": "z-index",
      "servo": "z-index",
      "vivliostyle": "z-index",
      "weasyprint": "z-index",
      "webkit": "z-index"
    },
    "border-end-color": {
      "blink": "-webkit-border-end-color",
      "gecko": "-moz-border-end-color",
      "vivliostyle": "border-end-color",
      "webkit": "-webkit-border-end-color"
    },
    "border-end-style": {
      "blink": "-webkit-border-end-style",
      "gecko": "-moz-border-end-style",
      "vivliostyle": "border-end-style",
      "webkit": "-webkit-border-end-style"
    },
    "border-end-width": {
      "blink": "-webkit-border-end-width",
      "gecko": "-moz-border-end-width",
      "vivliostyle": "border-end-width",
      "webkit": "-webkit-border-end-width"
    },
    "border-start-color": {
      "blink": "-webkit-border-start-color",
      "gecko": "-moz-border-start-color",
      "vivliostyle": "border-start-color",
      "webkit": "-webkit-border-start-color"
    },
    "border-start-style": {
      "blink": "-webkit-border-start-style",
      "gecko": "-moz-border-start-style",
      "vivliostyle": "border-start-style",
      "webkit": "-webkit-border-start-style"
    },
    "border-start-width": {
      "blink": "-webkit-border-start-width",
      "gecko": "-moz-border-start-width",
      "vivliostyle": "border-start-width",
      "webkit": "-webkit-border-start-width"
    },
    "border-before-color": {
      "blink": "-webkit-border-before-color",
      "vivliostyle": "border-before-color",
      "webkit": "-webkit-border-before-color"
    },
    "border-before-style": {
      "blink": "-webkit-border-before-style",
      "vivliostyle": "border-before-style",
      "webkit": "-webkit-border-before-style"
    },
    "border-before-width": {
      "blink": "-webkit-border-before-width",
      "vivliostyle": "border-before-width",
      "webkit": "-webkit-border-before-width"
    },
    "border-after-color": {
      "blink": "-webkit-border-after-color",
      "vivliostyle": "border-after-color",
      "webkit": "-webkit-border-after-color"
    },
    "border-after-style": {
      "blink": "-webkit-border-after-style",
      "vivliostyle": "border-after-style",
      "webkit": "-webkit-border-after-style"
    },
    "border-after-width": {
      "blink": "-webkit-border-after-width",
      "vivliostyle": "border-after-width",
      "webkit": "-webkit-border-after-width"
    },
    "margin-end": {
      "blink": "-webkit-margin-end",
      "gecko": "-moz-margin-end",
      "vivliostyle": "margin-end",
      "webkit": "-webkit-margin-end"
    },
    "margin-start": {
      "blink": "-webkit-margin-start",
      "gecko": "-moz-margin-start",
      "vivliostyle": "margin-start",
      "webkit": "-webkit-margin-start"
    },
    "margin-before": {
      "blink": "-webkit-margin-before",
      "vivliostyle": "margin-before",
      "webkit": "-webkit-margin-before"
    },
    "margin-after": {
      "blink": "-webkit-margin-after",
      "vivliostyle": "margin-after",
      "webkit": "-webkit-margin-after"
    },
    "padding-end": {
      "blink": "-webkit-padding-end",
      "gecko": "-moz-padding-end",
      "webkit": "-webkit-padding-end"
    },
    "padding-start": {
      "blink": "-webkit-padding-start",
      "gecko": "-moz-padding-start",
      "webkit": "-webkit-padding-start"
    },
    "padding-before": {
      "blink": "-webkit-padding-before",
      "webkit": "-webkit-padding-before"
    },
    "padding-after": {
      "blink": "-webkit-padding-after",
      "webkit": "-webkit-padding-after"
    },
    "logical-width": {
      "blink": "-webkit-logical-width",
      "webkit": "-webkit-logical-width"
    },
    "logical-height": {
      "blink": "-webkit-logical-height",
      "webkit": "-webkit-logical-height"
    },
    "min-logical-width": {
      "blink": "-webkit-min-logical-width",
      "webkit": "-webkit-min-logical-width"
    },
    "min-logical-height": {
      "blink": "-webkit-min-logical-height",
      "webkit": "-webkit-min-logical-height"
    },
    "max-logical-width": {
      "blink": "-webkit-max-logical-width",
      "webkit": "-webkit-max-logical-width"
    },
    "max-logical-height": {
      "blink": "-webkit-max-logical-height",
      "webkit": "-webkit-max-logical-height"
    },
    "all": {
      "blink": "all",
      "gecko": "all",
      "webkit": "all"
    },
    "max-zoom": {
      "blink": "max-zoom",
      "webkit": "max-zoom"
    },
    "min-zoom": {
      "blink": "min-zoom",
      "webkit": "min-zoom"
    },
    "orientation": {
      "blink": "orientation",
      "webkit": "orientation"
    },
    "page": {
      "blink": "page",
      "vivliostyle": "page",
      "webkit": "page"
    },
    "src": {
      "blink": "src",
      "gecko": "src",
      "vivliostyle": "src",
      "webkit": "src"
    },
    "unicode-range": {
      "blink": "unicode-range",
      "gecko": "unicode-range",
      "webkit": "unicode-range"
    },
    "user-zoom": {
      "blink": "user-zoom",
      "webkit": "user-zoom"
    },
    "font-size-delta": {
      "blink": "-webkit-font-size-delta",
      "webkit": "-webkit-font-size-delta"
    },
    "text-decorations-in-effect": {
      "blink": "-webkit-text-decorations-in-effect",
      "servo": "-servo-text-decorations-in-effect",
      "webkit": "-webkit-text-decorations-in-effect"
    },
    "animation": {
      "blink": "animation",
      "gecko": "animation",
      "webkit": "animation"
    },
    "background": {
      "blink": "background",
      "gecko": "background",
      "servo": "background",
      "vivliostyle": "background",
      "webkit": "background"
    },
    "background-position": {
      "blink": "background-position",
      "gecko": "background-position",
      "servo": "background-position",
      "vivliostyle": "background-position",
      "weasyprint": "background-position",
      "webkit": "background-position"
    },
    "background-repeat": {
      "blink": "background-repeat",
      "gecko": "background-repeat",
      "servo": "background-repeat",
      "vivliostyle": "background-repeat",
      "weasyprint": "background-repeat",
      "webkit": "background-repeat"
    },
    "border": {
      "blink": "border",
      "gecko": "border",
      "servo": "border",
      "vivliostyle": "border",
      "webkit": "border"
    },
    "border-bottom": {
      "blink": "border-bottom",
      "gecko": "border-bottom",
      "servo": "border-bottom",
      "vivliostyle": "border-bottom",
      "webkit": "border-bottom"
    },
    "border-color": {
      "blink": "border-color",
      "gecko": "border-color",
      "servo": "border-color",
      "vivliostyle": "border-color",
      "webkit": "border-color"
    },
    "border-left": {
      "blink": "border-left",
      "gecko": "border-left",
      "servo": "border-left",
      "vivliostyle": "border-left",
      "webkit": "border-left"
    },
    "border-radius": {
      "blink": "border-radius",
      "gecko": "border-radius",
      "servo": "border-radius",
      "vivliostyle": "border-radius",
      "webkit": "border-radius"
    },
    "border-right": {
      "blink": "border-right",
      "gecko": "border-right",
      "servo": "border-right",
      "vivliostyle": "border-right",
      "webkit": "border-right"
    },
    "border-spacing": {
      "blink": "border-spacing",
      "gecko": "border-spacing",
      "servo": "border-spacing",
      "vivliostyle": "border-spacing",
      "weasyprint": "border-spacing",
      "webkit": "border-spacing"
    },
    "border-style": {
      "blink": "border-style",
      "gecko": "border-style",
      "servo": "border-style",
      "vivliostyle": "border-style",
      "webkit": "border-style"
    },
    "border-top": {
      "blink": "border-top",
      "gecko": "border-top",
      "servo": "border-top",
      "vivliostyle": "border-top",
      "webkit": "border-top"
    },
    "border-width": {
      "blink": "border-width",
      "gecko": "border-width",
      "servo": "border-width",
      "vivliostyle": "border-width",
      "webkit": "border-width"
    },
    "flex": {
      "blink": "flex",
      "gecko": "flex",
      "vivliostyle": "flex",
      "webkit": "flex"
    },
    "flex-flow": {
      "blink": "flex-flow",
      "gecko": "flex-flow",
      "vivliostyle": "flex-flow",
      "webkit": "flex-flow"
    },
    "font": {
      "blink": "font",
      "gecko": "font",
      "servo": "font",
      "vivliostyle": "font",
      "webkit": "font"
    },
    "grid": {
      "blink": "grid",
      "gecko": "grid",
      "webkit": "-webkit-grid"
    },
    "grid-area": {
      "blink": "grid-area",
      "gecko": "grid-area",
      "webkit": "-webkit-grid-area"
    },
    "grid-column": {
      "blink": "grid-column",
      "gecko": "grid-column",
      "webkit": "-webkit-grid-column"
    },
    "grid-row": {
      "blink": "grid-row",
      "gecko": "grid-row",
      "webkit": "-webkit-grid-row"
    },
    "grid-template": {
      "blink": "grid-template",
      "gecko": "grid-template",
      "webkit": "-webkit-grid-template"
    },
    "list-style": {
      "blink": "list-style",
      "gecko": "list-style",
      "servo": "list-style",
      "vivliostyle": "list-style",
      "webkit": "list-style"
    },
    "margin": {
      "blink": "margin",
      "gecko": "margin",
      "servo": "margin",
      "vivliostyle": "margin",
      "webkit": "margin"
    },
    "marker": {
      "blink": "marker",
      "gecko": "marker",
      "webkit": "marker"
    },
    "motion": {
      "blink": "motion"
    },
    "outline": {
      "blink": "outline",
      "gecko": "outline",
      "servo": "outline",
      "vivliostyle": "outline",
      "webkit": "outline"
    },
    "overflow": {
      "blink": "overflow",
      "gecko": "overflow",
      "servo": "overflow",
      "vivliostyle": "overflow",
      "weasyprint": "overflow",
      "webkit": "overflow"
    },
    "padding": {
      "blink": "padding",
      "gecko": "padding",
      "servo": "padding",
      "vivliostyle": "padding",
      "webkit": "padding"
    },
    "transition": {
      "blink": "transition",
      "gecko": "transition",
      "servo": "transition",
      "webkit": "transition"
    },
    "border-after": {
      "blink": "-webkit-border-after",
      "webkit": "-webkit-border-after"
    },
    "border-before": {
      "blink": "-webkit-border-before",
      "webkit": "-webkit-border-before"
    },
    "border-end": {
      "blink": "-webkit-border-end",
      "gecko": "-moz-border-end",
      "webkit": "-webkit-border-end"
    },
    "border-start": {
      "blink": "-webkit-border-start",
      "gecko": "-moz-border-start",
      "webkit": "-webkit-border-start"
    },
    "column-rule": {
      "blink": "-webkit-column-rule",
      "gecko": "-moz-column-rule",
      "vivliostyle": "column-rule",
      "webkit": "column-rule"
    },
    "columns": {
      "blink": "-webkit-columns",
      "gecko": "-moz-columns",
      "servo": "columns",
      "vivliostyle": "columns",
      "webkit": "columns"
    },
    "margin-collapse": {
      "blink": "-webkit-margin-collapse",
      "webkit": "-webkit-margin-collapse"
    },
    "mask-box-image": {
      "blink": "-webkit-mask-box-image",
      "webkit": "-webkit-mask-box-image"
    },
    "mask-position": {
      "blink": "-webkit-mask-position",
      "gecko": "mask-position",
      "webkit": "-webkit-mask-position"
    },
    "mask-repeat": {
      "blink": "-webkit-mask-repeat",
      "gecko": "mask-repeat",
      "webkit": "-webkit-mask-repeat"
    },
    "text-emphasis": {
      "blink": "-epub-text-emphasis",
      "gecko": "text-emphasis",
      "vivliostyle": "text-emphasis",
      "webkit": "text-emphasis"
    },
    "text-stroke": {
      "blink": "-webkit-text-stroke",
      "gecko": "-webkit-text-stroke",
      "webkit": "-webkit-text-stroke"
    },
    "binding": {
      "gecko": "-moz-binding"
    },
    "block-size": {
      "gecko": "block-size"
    },
    "border-block-end": {
      "gecko": "border-block-end"
    },
    "border-block-end-color": {
      "gecko": "border-block-end-color"
    },
    "border-block-end-style": {
      "gecko": "border-block-end-style"
    },
    "border-block-end-width": {
      "gecko": "border-block-end-width"
    },
    "border-block-start": {
      "gecko": "border-block-start"
    },
    "border-block-start-color": {
      "gecko": "border-block-start-color"
    },
    "border-block-start-style": {
      "gecko": "border-block-start-style"
    },
    "border-block-start-width": {
      "gecko": "border-block-start-width"
    },
    "border-bottom-colors": {
      "gecko": "-moz-border-bottom-colors"
    },
    "border-inline-end": {
      "gecko": "border-inline-end"
    },
    "border-inline-end-color": {
      "gecko": "border-inline-end-color"
    },
    "border-inline-end-style": {
      "gecko": "border-inline-end-style"
    },
    "border-inline-end-width": {
      "gecko": "border-inline-end-width"
    },
    "border-inline-start": {
      "gecko": "border-inline-start"
    },
    "border-inline-start-color": {
      "gecko": "border-inline-start-color"
    },
    "border-inline-start-style": {
      "gecko": "border-inline-start-style"
    },
    "border-inline-start-width": {
      "gecko": "border-inline-start-width"
    },
    "border-left-colors": {
      "gecko": "-moz-border-left-colors"
    },
    "border-right-colors": {
      "gecko": "-moz-border-right-colors"
    },
    "border-top-colors": {
      "gecko": "-moz-border-top-colors"
    },
    "color-adjust": {
      "gecko": "color-adjust"
    },
    "contain": {
      "gecko": "contain"
    },
    "control-character-visibility": {
      "gecko": "-moz-control-character-visibility"
    },
    "float-edge": {
      "gecko": "-moz-float-edge"
    },
    "font-language-override": {
      "gecko": "font-language-override"
    },
    "font-synthesis": {
      "gecko": "font-synthesis",
      "webkit": "font-synthesis"
    },
    "font-variant-alternates": {
      "gecko": "font-variant-alternates",
      "webkit": "font-variant-alternates"
    },
    "font-variant-caps": {
      "gecko": "font-variant-caps",
      "webkit": "font-variant-caps"
    },
    "font-variant-east-asian": {
      "gecko": "font-variant-east-asian",
      "vivliostyle": "font-variant-east-asian",
      "webkit": "font-variant-east-asian"
    },
    "font-variant-numeric": {
      "gecko": "font-variant-numeric",
      "webkit": "font-variant-numeric"
    },
    "font-variant-position": {
      "gecko": "font-variant-position",
      "webkit": "font-variant-position"
    },
    "force-broken-image-icon": {
      "gecko": "-moz-force-broken-image-icon"
    },
    "grid-column-gap": {
      "gecko": "grid-column-gap",
      "webkit": "-webkit-grid-column-gap"
    },
    "grid-gap": {
      "gecko": "grid-gap",
      "webkit": "-webkit-grid-gap"
    },
    "grid-row-gap": {
      "gecko": "grid-row-gap",
      "webkit": "-webkit-grid-row-gap"
    },
    "hyphens": {
      "gecko": "hyphens",
      "vivliostyle": "hyphens",
      "weasyprint": "hyphens",
      "webkit": "-epub-hyphens"
    },
    "image-region": {
      "gecko": "-moz-image-region"
    },
    "ime-mode": {
      "gecko": "ime-mode"
    },
    "inline-size": {
      "gecko": "inline-size"
    },
    "lang": {
      "gecko": "-x-lang",
      "weasyprint": "lang"
    },
    "margin-block-end": {
      "gecko": "margin-block-end"
    },
    "margin-block-start": {
      "gecko": "margin-block-start"
    },
    "margin-inline-end": {
      "gecko": "margin-inline-end"
    },
    "margin-inline-start": {
      "gecko": "margin-inline-start"
    },
    "marker-offset": {
      "gecko": "marker-offset"
    },
    "mask-mode": {
      "gecko": "mask-mode"
    },
    "math-display": {
      "gecko": "-moz-math-display"
    },
    "math-variant": {
      "gecko": "-moz-math-variant"
    },
    "max-block-size": {
      "gecko": "max-block-size"
    },
    "max-inline-size": {
      "gecko": "max-inline-size"
    },
    "min-block-size": {
      "gecko": "min-block-size"
    },
    "min-font-size-ratio": {
      "gecko": "-moz-min-font-size-ratio"
    },
    "min-inline-size": {
      "gecko": "min-inline-size"
    },
    "offset-block-end": {
      "gecko": "offset-block-end"
    },
    "offset-block-start": {
      "gecko": "offset-block-start"
    },
    "offset-inline-end": {
      "gecko": "offset-inline-end"
    },
    "offset-inline-start": {
      "gecko": "offset-inline-start"
    },
    "orient": {
      "gecko": "-moz-orient"
    },
    "osx-font-smoothing": {
      "gecko": "-moz-osx-font-smoothing"
    },
    "outline-radius": {
      "gecko": "-moz-outline-radius"
    },
    "outline-radius-bottomleft": {
      "gecko": "-moz-outline-radius-bottomleft"
    },
    "outline-radius-bottomright": {
      "gecko": "-moz-outline-radius-bottomright"
    },
    "outline-radius-topleft": {
      "gecko": "-moz-outline-radius-topleft"
    },
    "outline-radius-topright": {
      "gecko": "-moz-outline-radius-topright"
    },
    "overflow-clip-box": {
      "gecko": "overflow-clip-box"
    },
    "padding-block-end": {
      "gecko": "padding-block-end"
    },
    "padding-block-start": {
      "gecko": "padding-block-start"
    },
    "padding-inline-end": {
      "gecko": "padding-inline-end"
    },
    "padding-inline-start": {
      "gecko": "padding-inline-start"
    },
    "ruby-align": {
      "gecko": "ruby-align",
      "vivliostyle": "ruby-align"
    },
    "script-level": {
      "gecko": "-moz-script-level"
    },
    "script-min-size": {
      "gecko": "-moz-script-min-size"
    },
    "script-size-multiplier": {
      "gecko": "-moz-script-size-multiplier"
    },
    "scroll-snap-type-x": {
      "gecko": "scroll-snap-type-x"
    },
    "scroll-snap-type-y": {
      "gecko": "scroll-snap-type-y"
    },
    "span": {
      "gecko": "-x-span"
    },
    "stack-sizing": {
      "gecko": "-moz-stack-sizing"
    },
    "system-font": {
      "gecko": "-x-system-font"
    },
    "text-combine-upright": {
      "gecko": "text-combine-upright",
      "vivliostyle": "text-combine-upright"
    },
    "text-size-adjust": {
      "gecko": "-moz-text-size-adjust",
      "vivliostyle": "text-size-adjust",
      "webkit": "-webkit-text-size-adjust"
    },
    "text-zoom": {
      "gecko": "-x-text-zoom",
      "vivliostyle": "text-zoom",
      "webkit": "-webkit-text-zoom"
    },
    "top-layer": {
      "gecko": "-moz-top-layer"
    },
    "transform-box": {
      "gecko": "transform-box"
    },
    "user-focus": {
      "gecko": "-moz-user-focus"
    },
    "user-input": {
      "gecko": "-moz-user-input"
    },
    "window-dragging": {
      "gecko": "-moz-window-dragging"
    },
    "window-shadow": {
      "gecko": "-moz-window-shadow"
    },
    "font-display": {
      "gecko": "font-display"
    },
    "display-for-hypothetical-box": {
      "servo": "-servo-display-for-hypothetical-box"
    },
    "azimuth": {
      "vivliostyle": "azimuth"
    },
    "cue-after": {
      "vivliostyle": "cue-after"
    },
    "cue-before": {
      "vivliostyle": "cue-before"
    },
    "elevation": {
      "vivliostyle": "elevation"
    },
    "pause-after": {
      "vivliostyle": "pause-after"
    },
    "pause-before": {
      "vivliostyle": "pause-before"
    },
    "pitch-range": {
      "vivliostyle": "pitch-range"
    },
    "pitch": {
      "vivliostyle": "pitch"
    },
    "play-during": {
      "vivliostyle": "play-during"
    },
    "richness": {
      "vivliostyle": "richness"
    },
    "speak-header": {
      "vivliostyle": "speak-header"
    },
    "speak-numeral": {
      "vivliostyle": "speak-numeral"
    },
    "speak-punctuation": {
      "vivliostyle": "speak-punctuation"
    },
    "speech-rate": {
      "vivliostyle": "speech-rate"
    },
    "stress": {
      "vivliostyle": "stress"
    },
    "voice-family": {
      "vivliostyle": "voice-family"
    },
    "volume": {
      "vivliostyle": "volume"
    },
    "before": {
      "vivliostyle": "before"
    },
    "after": {
      "vivliostyle": "after"
    },
    "start": {
      "vivliostyle": "start"
    },
    "end": {
      "vivliostyle": "end"
    },
    "shape-inside": {
      "vivliostyle": "shape-inside"
    },
    "wrap-flow": {
      "vivliostyle": "wrap-flow"
    },
    "break-before": {
      "vivliostyle": "break-before",
      "webkit": "break-before"
    },
    "break-after": {
      "vivliostyle": "break-after",
      "webkit": "break-after"
    },
    "break-inside": {
      "vivliostyle": "break-inside",
      "webkit": "break-inside"
    },
    "flow-from": {
      "vivliostyle": "flow-from",
      "webkit": "-webkit-flow-from"
    },
    "flow-into": {
      "vivliostyle": "flow-into",
      "webkit": "-webkit-flow-into"
    },
    "flow-linger": {
      "vivliostyle": "flow-linger"
    },
    "flow-priority": {
      "vivliostyle": "flow-priority"
    },
    "flow-options": {
      "vivliostyle": "flow-options"
    },
    "min-page-width": {
      "vivliostyle": "min-page-width"
    },
    "min-page-height": {
      "vivliostyle": "min-page-height"
    },
    "required": {
      "vivliostyle": "required"
    },
    "enabled": {
      "vivliostyle": "enabled"
    },
    "conflicting-partitions": {
      "vivliostyle": "conflicting-partitions"
    },
    "required-partitions": {
      "vivliostyle": "required-partitions"
    },
    "snap-height": {
      "vivliostyle": "snap-height"
    },
    "snap-width": {
      "vivliostyle": "snap-width"
    },
    "flow-consume": {
      "vivliostyle": "flow-consume"
    },
    "utilization": {
      "vivliostyle": "utilization"
    },
    "template": {
      "vivliostyle": "template"
    },
    "behavior": {
      "vivliostyle": "behavior"
    },
    "bleed": {
      "vivliostyle": "bleed"
    },
    "marks": {
      "vivliostyle": "marks"
    },
    "float-reference": {
      "vivliostyle": "float-reference"
    },
    "text-decoration-skip": {
      "vivliostyle": "text-decoration-skip",
      "webkit": "-webkit-text-decoration-skip"
    },
    "text-combine-horizontal": {
      "vivliostyle": "text-combine-horizontal"
    },
    "oeb-column-number": {
      "vivliostyle": "oeb-column-number"
    },
    "pause": {
      "vivliostyle": "pause"
    },
    "string-set": {
      "weasyprint": "string-set"
    },
    "image-resolution": {
      "weasyprint": "image-resolution",
      "webkit": "image-resolution"
    },
    "anchor": {
      "weasyprint": "anchor"
    },
    "link": {
      "weasyprint": "link"
    },
    "bookmark-label": {
      "weasyprint": "bookmark-label"
    },
    "bookmark-level": {
      "weasyprint": "bookmark-level"
    },
    "hyphenate-limit-chars": {
      "weasyprint": "hyphenate-limit-chars"
    },
    "hyphenate-limit-zone": {
      "weasyprint": "hyphenate-limit-zone"
    },
    "specified-display": {
      "weasyprint": "-weasy-specified-display"
    },
    "color-profile": {
      "webkit": "color-profile"
    },
    "cursor-visibility": {
      "webkit": "-webkit-cursor-visibility"
    },
    "enable-background": {
      "webkit": "enable-background"
    },
    "hanging-punctuation": {
      "webkit": "hanging-punctuation"
    },
    "kerning": {
      "webkit": "kerning"
    },
    "text-line-through": {
      "webkit": "text-line-through"
    },
    "text-line-through-color": {
      "webkit": "text-line-through-color"
    },
    "text-line-through-mode": {
      "webkit": "text-line-through-mode"
    },
    "text-line-through-style": {
      "webkit": "text-line-through-style"
    },
    "text-line-through-width": {
      "webkit": "text-line-through-width"
    },
    "text-overline": {
      "webkit": "text-overline"
    },
    "text-overline-color": {
      "webkit": "text-overline-color"
    },
    "text-overline-mode": {
      "webkit": "text-overline-mode"
    },
    "text-overline-style": {
      "webkit": "text-overline-style"
    },
    "text-overline-width": {
      "webkit": "text-overline-width"
    },
    "text-underline": {
      "webkit": "text-underline"
    },
    "text-underline-color": {
      "webkit": "text-underline-color"
    },
    "text-underline-mode": {
      "webkit": "text-underline-mode"
    },
    "text-underline-style": {
      "webkit": "text-underline-style"
    },
    "text-underline-width": {
      "webkit": "text-underline-width"
    },
    "alt": {
      "webkit": "alt"
    },
    "animation-trigger": {
      "webkit": "-webkit-animation-trigger"
    },
    "aspect-ratio": {
      "webkit": "-webkit-aspect-ratio"
    },
    "border-fit": {
      "webkit": "-webkit-border-fit"
    },
    "column-axis": {
      "webkit": "-webkit-column-axis"
    },
    "column-progression": {
      "webkit": "column-progression"
    },
    "hyphenate-limit-after": {
      "webkit": "-webkit-hyphenate-limit-after"
    },
    "hyphenate-limit-before": {
      "webkit": "-webkit-hyphenate-limit-before"
    },
    "hyphenate-limit-lines": {
      "webkit": "-webkit-hyphenate-limit-lines"
    },
    "initial-letter": {
      "webkit": "-webkit-initial-letter"
    },
    "line-box-contain": {
      "webkit": "-webkit-line-box-contain"
    },
    "line-align": {
      "webkit": "-webkit-line-align"
    },
    "line-grid": {
      "webkit": "-webkit-line-grid"
    },
    "line-snap": {
      "webkit": "-webkit-line-snap"
    },
    "marquee": {
      "webkit": "-webkit-marquee"
    },
    "marquee-direction": {
      "webkit": "-webkit-marquee-direction"
    },
    "marquee-increment": {
      "webkit": "-webkit-marquee-increment"
    },
    "marquee-repetition": {
      "webkit": "-webkit-marquee-repetition"
    },
    "marquee-speed": {
      "webkit": "-webkit-marquee-speed"
    },
    "marquee-style": {
      "webkit": "-webkit-marquee-style"
    },
    "nbsp-mode": {
      "webkit": "-webkit-nbsp-mode"
    },
    "svg-shadow": {
      "webkit": "-webkit-svg-shadow"
    },
    "region-fragment": {
      "webkit": "-webkit-region-fragment"
    },
    "region-break-after": {
      "webkit": "-webkit-region-break-after"
    },
    "region-break-before": {
      "webkit": "-webkit-region-break-before"
    },
    "region-break-inside": {
      "webkit": "-webkit-region-break-inside"
    },
    "dashboard-region": {
      "webkit": "-webkit-dashboard-region"
    },
    "overflow-scrolling": {
      "webkit": "-webkit-overflow-scrolling"
    },
    "touch-callout": {
      "webkit": "-webkit-touch-callout"
    },
    "trailing-word": {
      "webkit": "-apple-trailing-word"
    }
  }
};