/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master.info;

import java.io.IOException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class ClusterInfoRequest<T extends ClusterInfoRequest<T>>
extends MasterNodeReadRequest<T>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public T indices(String ... indices) {
        this.indices = indices;
        return (T)this;
    }

    public T types(String ... types) {
        this.types = types;
        return (T)this;
    }

    public T indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (T)this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public String[] types() {
        return this.types;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
    }
}

