/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.fs.FsService;
import org.elasticsearch.monitor.jvm.JvmMonitorService;
import org.elasticsearch.monitor.jvm.JvmService;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsService;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessService;

public class MonitorModule
extends AbstractModule {
    private final Settings settings;

    public MonitorModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void configure() {
        this.bind(ProcessProbe.class).toInstance(ProcessProbe.getInstance());
        this.bind(OsProbe.class).toInstance(OsProbe.getInstance());
        this.bind(FsProbe.class).asEagerSingleton();
        this.bind(ProcessService.class).asEagerSingleton();
        this.bind(OsService.class).asEagerSingleton();
        this.bind(JvmService.class).asEagerSingleton();
        this.bind(FsService.class).asEagerSingleton();
        this.bind(JvmMonitorService.class).asEagerSingleton();
    }

    public static final class MonitorSettings {
        public static final String MEMORY_MANAGER_TYPE = "monitor.memory.type";
    }
}

