/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import org.gradle.internal.hash.HashValue;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashValueSerializer
implements Serializer<HashValue> {
    @Override
    public HashValue read(Decoder decoder) throws Exception {
        byte hashSize = decoder.readByte();
        byte[] hash = new byte[hashSize];
        decoder.readBytes(hash);
        return new HashValue(hash);
    }

    @Override
    public void write(Encoder encoder, HashValue value) throws Exception {
        byte[] hash = value.asByteArray();
        encoder.writeByte((byte)hash.length);
        encoder.writeBytes(hash);
    }
}

