/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript;

import groovy.lang.Closure;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompileOptions;
import org.gradle.plugins.javascript.coffeescript.compile.internal.DefaultCoffeeScriptCompileSpec;
import org.gradle.plugins.javascript.coffeescript.compile.internal.rhino.RhinoCoffeeScriptCompiler;
import org.gradle.plugins.javascript.rhino.worker.internal.DefaultRhinoWorkerHandleFactory;
import org.gradle.process.internal.worker.WorkerProcessFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoffeeScriptCompile
extends SourceTask {
    private Object coffeeScriptJs;
    private Object destinationDir;
    private Object rhinoClasspath;
    private CoffeeScriptCompileOptions options = new CoffeeScriptCompileOptions();

    @Inject
    protected WorkerProcessFactory getWorkerProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @InputFiles
    public FileCollection getCoffeeScriptJs() {
        return this.getProject().files(new Object[]{this.coffeeScriptJs});
    }

    public void setCoffeeScriptJs(Object coffeeScriptJs) {
        this.coffeeScriptJs = coffeeScriptJs;
    }

    @InputFiles
    public FileCollection getRhinoClasspath() {
        return this.getProject().files(new Object[]{this.rhinoClasspath});
    }

    public void setRhinoClasspath(Object rhinoClasspath) {
        this.rhinoClasspath = rhinoClasspath;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.getProject().file(this.destinationDir);
    }

    public void setDestinationDir(Object destinationDir) {
        this.destinationDir = destinationDir;
    }

    public CoffeeScriptCompileOptions getOptions() {
        return this.options;
    }

    public void options(Action<CoffeeScriptCompileOptions> action) {
        action.execute((Object)this.getOptions());
    }

    public void options(Closure<?> closure) {
        this.getProject().configure((Object)this.getOptions(), closure);
    }

    @TaskAction
    public void doCompile() {
        DefaultRhinoWorkerHandleFactory handleFactory = new DefaultRhinoWorkerHandleFactory(this.getWorkerProcessBuilderFactory());
        DefaultCoffeeScriptCompileSpec spec = new DefaultCoffeeScriptCompileSpec();
        spec.setCoffeeScriptJs(this.getCoffeeScriptJs().getSingleFile());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setSource((FileCollection)this.getSource());
        spec.setOptions(this.getOptions());
        LogLevel logLevel = this.getProject().getGradle().getStartParameter().getLogLevel();
        RhinoCoffeeScriptCompiler compiler = new RhinoCoffeeScriptCompiler(handleFactory, (Iterable<File>)this.getRhinoClasspath(), logLevel, this.getProject().getProjectDir());
        this.setDidWork(compiler.compile(spec).getDidWork());
    }
}

