/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gjt.sp.jedit.MiscUtilities;

class PropertyManager {
    private final Properties system = new Properties();
    private final List<Properties> plugins = new LinkedList<Properties>();
    private final Properties site = new Properties();
    private final Properties localization = new Properties();
    private final List<Properties> pluginLocalizations = new LinkedList<Properties>();
    private final Properties user = new Properties();

    PropertyManager() {
    }

    Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.system);
        for (Properties properties2 : this.plugins) {
            properties.putAll((Map<?, ?>)properties2);
        }
        properties.putAll((Map<?, ?>)this.site);
        properties.putAll((Map<?, ?>)this.localization);
        for (Properties properties2 : this.pluginLocalizations) {
            properties.putAll((Map<?, ?>)properties2);
        }
        properties.putAll((Map<?, ?>)this.user);
        return properties;
    }

    void loadSystemProps(Reader reader) throws IOException {
        PropertyManager.loadProps(this.system, reader);
    }

    void loadSiteProps(InputStream inputStream) throws IOException {
        PropertyManager.loadProps(this.site, inputStream);
    }

    void loadLocalizationProps(Reader reader) throws IOException {
        if (reader == null) {
            this.localization.clear();
        } else {
            PropertyManager.loadProps(this.localization, reader);
        }
    }

    void loadUserProps(InputStream inputStream) throws IOException {
        PropertyManager.loadProps(this.user, inputStream);
    }

    void saveUserProps(OutputStream outputStream) throws IOException {
        MiscUtilities.storeProperties(this.user, outputStream, "jEdit properties");
    }

    Properties loadPluginProps(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        PropertyManager.loadProps(properties, inputStream);
        this.plugins.add(properties);
        return properties;
    }

    void addPluginProps(Properties properties) {
        this.plugins.add(properties);
    }

    void removePluginProps(Properties properties) {
        this.plugins.remove(properties);
    }

    Properties loadPluginLocalizationProps(Reader reader) throws IOException {
        Properties properties = new Properties();
        PropertyManager.loadProps(properties, reader);
        this.pluginLocalizations.add(properties);
        return properties;
    }

    void addPluginLocalizationProps(Properties properties) {
        this.pluginLocalizations.add(properties);
    }

    void removePluginLocalizationProps(Properties properties) {
        this.pluginLocalizations.remove(properties);
    }

    String getProperty(String string) {
        String string2 = this.user.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        for (Properties properties : this.pluginLocalizations) {
            string2 = properties.getProperty(string);
            if (string2 == null) continue;
            return string2;
        }
        string2 = this.localization.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        return this.getDefaultProperty(string);
    }

    void setProperty(String string, String string2) {
        String string3 = this.getDefaultProperty(string);
        if (string2 == null) {
            if (string3 == null || string3.length() == 0) {
                this.user.remove(string);
            } else {
                this.user.setProperty(string, "");
            }
        } else if (string2.equals(string3)) {
            this.user.remove(string);
        } else {
            this.user.setProperty(string, string2);
        }
    }

    public void setTemporaryProperty(String string, String string2) {
        this.user.remove(string);
        this.system.setProperty(string, string2);
    }

    void unsetProperty(String string) {
        if (this.getDefaultProperty(string) != null) {
            this.user.setProperty(string, "");
        } else {
            this.user.remove(string);
        }
    }

    public void resetProperty(String string) {
        this.user.remove(string);
    }

    private String getDefaultProperty(String string) {
        String string2 = this.site.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        for (Properties properties : this.plugins) {
            string2 = properties.getProperty(string);
            if (string2 == null) continue;
            return string2;
        }
        return this.system.getProperty(string);
    }

    private static void loadProps(Properties properties, InputStream inputStream) throws IOException {
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    private static void loadProps(Properties properties, Reader reader) throws IOException {
        try {
            properties.load(reader);
        }
        finally {
            reader.close();
        }
    }
}

