/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class V3000Rdr {
    private MolReader mr;
    private String line;
    private Map<String, String[]> userData;

    V3000Rdr set(AtomSetCollectionReader mr) {
        this.mr = (MolReader)mr;
        return this;
    }

    void readAtomsAndBonds(String[] tokens) throws Exception {
        int ac = this.mr.parseIntStr(tokens[3]);
        this.readAtoms(ac);
        this.readBonds(this.mr.parseIntStr(tokens[4]));
        this.readUserData(ac);
    }

    private void readAtoms(int ac) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN ATOM");
        for (int i = 0; i < ac; ++i) {
            this.rd();
            this.checkLineContinuation();
            String[] tokens = this.mr.getTokens();
            int iAtom = this.mr.parseIntStr(tokens[2]);
            String elementSymbol = tokens[3];
            if (elementSymbol.equals("*")) continue;
            float x = this.mr.parseFloatStr(tokens[4]);
            float y = this.mr.parseFloatStr(tokens[5]);
            float z = this.mr.parseFloatStr(tokens[6]);
            int charge = 0;
            int isotope = 0;
            for (int j = 7; j < tokens.length; ++j) {
                String s = tokens[j].toUpperCase();
                if (s.startsWith("CHG=")) {
                    charge = this.mr.parseIntAt(tokens[j], 4);
                    continue;
                }
                if (!s.startsWith("MASS=")) continue;
                isotope = this.mr.parseIntAt(tokens[j], 5);
            }
            if (isotope > 1 && elementSymbol.equals("H")) {
                isotope = 1 - isotope;
            }
            this.mr.addMolAtom(iAtom, isotope, elementSymbol, charge, x, y, z);
        }
        this.mr.discardLinesUntilContains("END ATOM");
    }

    private void readBonds(int bondCount) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN BOND");
        for (int i = 0; i < bondCount; ++i) {
            this.rd();
            int stereo = 0;
            this.checkLineContinuation();
            String[] tokens = this.mr.getTokens();
            int order = this.mr.parseIntStr(tokens[3]);
            String iAtom1 = tokens[4];
            String iAtom2 = tokens[5];
            String cfg = this.getField("CFG");
            if (cfg == null) {
                String endpts = this.getField("ENDPTS");
                if (endpts != null && this.line.indexOf("ATTACH=ALL") >= 0) {
                    tokens = PT.getTokens((String)endpts);
                    int n = this.mr.parseIntStr(tokens[0]);
                    int o = this.mr.fixOrder(order, 0);
                    for (int k = 1; k <= n; ++k) {
                        this.mr.asc.addNewBondFromNames(iAtom1, tokens[k], o);
                    }
                }
            } else {
                stereo = this.mr.parseIntStr(cfg);
            }
            this.mr.addMolBond(iAtom1, iAtom2, order, stereo);
        }
        this.mr.discardLinesUntilContains("END BOND");
    }

    private void readUserData(int ac) throws Exception {
        this.userData = null;
        String pc = null;
        while (!this.rd().contains("END CTAB")) {
            if (!this.line.contains("BEGIN SGROUP")) continue;
            while (!this.rd().contains("END SGROUP")) {
                boolean isPartial;
                String data;
                String name;
                String atoms;
                if (this.userData == null) {
                    this.userData = new Hashtable<String, String[]>();
                }
                if ((atoms = this.getField("ATOMS")) == null || (name = this.getField("FIELDNAME")) == null || (data = this.getField("FIELDDATA")) == null) continue;
                boolean bl = isPartial = (name = name.toLowerCase()).indexOf("partial") >= 0;
                if (isPartial) {
                    if (pc == null) {
                        pc = name;
                    } else if (!pc.equals(name)) {
                        isPartial = false;
                    }
                }
                String[] a = null;
                float f = 0.0f;
                if (isPartial) {
                    f = this.mr.parseFloatStr(data);
                } else {
                    a = this.userData.get(name);
                    if (a == null) {
                        a = new String[ac];
                        this.userData.put(name, a);
                    }
                }
                try {
                    String[] tokens = PT.getTokens((String)atoms);
                    int i = tokens.length;
                    while (--i >= 1) {
                        String atom = tokens[i];
                        if (isPartial) {
                            this.mr.asc.getAtomFromName((String)atom).partialCharge = f;
                            continue;
                        }
                        a[this.mr.parseIntStr((String)atom) - 1] = data;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (this.userData == null) {
            return;
        }
        for (String key : this.userData.keySet()) {
            String[] a = this.userData.get(key);
            float[] f = new float[a.length];
            for (int i = 0; i < a.length; ++i) {
                f[i] = a[i] == null ? 0.0f : this.mr.parseFloatStr(a[i]);
            }
            this.mr.asc.setAtomProperties(key, (Object)f, -1, false);
        }
    }

    private String getField(String key) {
        int pt = this.line.indexOf(key + "=");
        if (pt < 0) {
            return null;
        }
        char term = ' ';
        switch (this.line.charAt(pt += key.length() + 1)) {
            case '\"': {
                term = '\"';
                break;
            }
            case '(': {
                term = ')';
                break;
            }
            case '+': {
                break;
            }
            default: {
                --pt;
            }
        }
        return this.line.substring(pt + 1, (this.line + term).indexOf(term, pt + 1));
    }

    private String rd() throws Exception {
        this.line = this.mr.rd();
        return this.line;
    }

    private void checkLineContinuation() throws Exception {
        while (this.line.endsWith("-")) {
            String s = this.line;
            this.rd();
            this.line = s + this.line;
        }
    }
}

