/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.paramtable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelEvent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelListener;
import org.zaproxy.zap.extension.httppanel.view.paramtable.HttpPanelParamTableModel;
import org.zaproxy.zap.extension.httppanel.view.paramtable.addins.ParamAddinInterface;
import org.zaproxy.zap.extension.httppanel.view.paramtable.addins.ParamAddinMagic;
import org.zaproxy.zap.extension.httppanel.view.paramtable.addins.ParamAddinUrlencode;
import org.zaproxy.zap.utils.DisplayUtils;

public abstract class HttpPanelParamTableView
implements HttpPanelView,
HttpPanelViewModelListener {
    public static final String NAME = "HttpPanelParamTableView";
    private static final String CAPTION_NAME = Constant.messages.getString("http.panel.view.tablev2.name");
    private static final String ADD_INS = Constant.messages.getString("http.panel.view.tableparam.addins");
    private JTable table;
    private JPanel mainPanel;
    private HttpPanelParamTableModel httpPanelTabularModel;
    private boolean isEditable = false;
    private List<ParamAddinInterface> addins;
    private JComboBox<Object> comboBoxAddIns;
    private HttpPanelViewModel model;

    public HttpPanelParamTableView(HttpPanelViewModel httpPanelViewModel, HttpPanelParamTableModel httpPanelParamTableModel) {
        this.httpPanelTabularModel = httpPanelParamTableModel;
        this.model = httpPanelViewModel;
        this.init();
        this.initAddins();
        this.model.addHttpPanelViewModelListener(this);
    }

    private void init() {
        this.table = new JTable();
        this.table.setName("");
        this.table.setModel(this.httpPanelTabularModel);
        this.table.setGridColor(Color.gray);
        this.table.setIntercellSpacing(new Dimension(1, 1));
        this.table.setRowHeight(DisplayUtils.getScaledSize(18));
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(70);
        tableColumn.setWidth(70);
        tableColumn.setMaxWidth(70);
        if (this.table.getColumnCount() == 4) {
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setPreferredWidth(150);
            tableColumn.setWidth(150);
            tableColumn.setMaxWidth(150);
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)new JScrollPane(this.table), "Center");
    }

    private void initAddins() {
        this.addins = new LinkedList<ParamAddinInterface>();
        this.addins.add(new ParamAddinMagic());
        this.addins.add(new ParamAddinUrlencode());
        this.comboBoxAddIns = new JComboBox();
        this.comboBoxAddIns.addItem(ADD_INS);
        for (ParamAddinInterface paramAddinInterface : this.addins) {
            this.comboBoxAddIns.addItem(paramAddinInterface);
        }
        this.comboBoxAddIns.addActionListener(new ComboBoxAddinsActionListener());
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.getComboBoxTypes()));
        this.table.setAutoResizeMode(1);
        if (this.table.getColumnCount() != 4) {
            return;
        }
        this.table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(this.comboBoxAddIns));
        this.table.getColumnModel().getColumn(3).setCellRenderer(new ComboBoxCellRenderer(this.comboBoxAddIns));
    }

    public abstract JComboBox<HtmlParameter.Type> getComboBoxTypes();

    @Override
    public void dataChanged(HttpPanelViewModelEvent httpPanelViewModelEvent) {
        this.httpPanelTabularModel.setHttpMessage((HttpMessage)this.model.getMessage());
    }

    @Override
    public void save() {
        this.httpPanelTabularModel.save();
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl) {
            this.table.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getCaptionName() {
        return CAPTION_NAME;
    }

    @Override
    public int getPosition() {
        return 10;
    }

    @Override
    public boolean isEnabled(Message message) {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return this.httpPanelTabularModel.hasChanged();
    }

    @Override
    public JComponent getPane() {
        return this.mainPanel;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public void setEditable(boolean bl) {
        if (this.isEditable != bl) {
            if (this.isEditable) {
                this.table.getColumnModel().removeColumn(this.table.getColumnModel().getColumn(3));
            } else {
                TableColumn tableColumn = new TableColumn(3, 150, new ComboBoxCellRenderer(this.comboBoxAddIns), new DefaultCellEditor(this.comboBoxAddIns));
                tableColumn.setPreferredWidth(150);
                tableColumn.setMaxWidth(150);
                this.table.addColumn(tableColumn);
            }
            this.isEditable = bl;
            this.httpPanelTabularModel.setEditable(bl);
        }
    }

    @Override
    public HttpPanelViewModel getModel() {
        return this.model;
    }

    @Override
    public void setParentConfigurationKey(String string) {
    }

    @Override
    public void loadConfiguration(FileConfiguration fileConfiguration) {
    }

    @Override
    public void saveConfiguration(FileConfiguration fileConfiguration) {
    }

    private static final class ComboBoxCellRenderer
    extends JComboBox<Object>
    implements TableCellRenderer {
        private static final long serialVersionUID = 7945388210094363435L;

        public ComboBoxCellRenderer(JComboBox<Object> jComboBox) {
            this.addItem(jComboBox.getModel().getElementAt(0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this;
        }
    }

    private static final class ComboBoxAddinsActionListener
    implements ActionListener {
        private ComboBoxAddinsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((JComboBox)actionEvent.getSource()).setSelectedIndex(0);
        }
    }
}

