/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.LinkedList;
import java.util.List;
import net.htmlparser.jericho.Source;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParserListener;

public abstract class SpiderParser {
    private List<SpiderParserListener> listeners = new LinkedList<SpiderParserListener>();
    protected static final Logger log = Logger.getLogger(SpiderParser.class);

    public void addSpiderParserListener(SpiderParserListener spiderParserListener) {
        this.listeners.add(spiderParserListener);
    }

    public void removeSpiderParserListener(SpiderParserListener spiderParserListener) {
        this.listeners.remove(spiderParserListener);
    }

    protected void notifyListenersResourceFound(HttpMessage httpMessage, int n, String string) {
        for (SpiderParserListener spiderParserListener : this.listeners) {
            spiderParserListener.resourceURIFound(httpMessage, n, string);
        }
    }

    protected void notifyListenersPostResourceFound(HttpMessage httpMessage, int n, String string, String string2) {
        for (SpiderParserListener spiderParserListener : this.listeners) {
            spiderParserListener.resourcePostURIFound(httpMessage, n, string, string2);
        }
    }

    protected void processURL(HttpMessage httpMessage, int n, String string, String string2) {
        String string3 = URLCanonicalizer.getCanonicalURL(string, string2);
        if (string3 == null) {
            return;
        }
        log.debug((Object)("Canonical URL constructed using '" + string + "': " + string3));
        this.notifyListenersResourceFound(httpMessage, n + 1, string3);
    }

    public abstract boolean parseResource(HttpMessage var1, Source var2, int var3);

    public abstract boolean canParseResource(HttpMessage var1, String var2, boolean var3);
}

