/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.security.AccessController;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.Constants;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.Processor;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;

public class AsyncStateMachine {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.coyote");
    private volatile AsyncState state = AsyncState.DISPATCHED;
    private AsyncContextCallback asyncCtxt = null;
    private final Processor<?> processor;

    public AsyncStateMachine(Processor<?> processor) {
        this.processor = processor;
    }

    public boolean isAsync() {
        return this.state.isAsync();
    }

    public boolean isAsyncDispatching() {
        return this.state.isDispatching();
    }

    public boolean isAsyncStarted() {
        return this.state.isStarted();
    }

    public boolean isAsyncTimingOut() {
        return this.state == AsyncState.TIMING_OUT;
    }

    public boolean isAsyncError() {
        return this.state == AsyncState.ERROR;
    }

    public boolean isCompleting() {
        return this.state.isCompleting();
    }

    public synchronized void asyncStart(AsyncContextCallback asyncCtxt) {
        if (this.state != AsyncState.DISPATCHED) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncStart()", this.state}));
        }
        this.state = AsyncState.STARTING;
        this.asyncCtxt = asyncCtxt;
    }

    public synchronized void asyncOperation() {
        if (this.state != AsyncState.STARTED) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncOperation()", this.state}));
        }
        this.state = AsyncState.READ_WRITE_OP;
    }

    public synchronized AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        this.notifyAll();
        if (this.state == AsyncState.STARTING || this.state == AsyncState.READ_WRITE_OP) {
            this.state = AsyncState.STARTED;
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (this.state == AsyncState.MUST_COMPLETE) {
            this.asyncCtxt.fireOnComplete();
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.COMPLETING) {
            this.asyncCtxt.fireOnComplete();
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.MUST_DISPATCH) {
            this.state = AsyncState.DISPATCHING;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.DISPATCHING) {
            this.state = AsyncState.DISPATCHED;
            return AbstractEndpoint.Handler.SocketState.ASYNC_END;
        }
        if (this.state == AsyncState.STARTED) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncPostProcess()", this.state}));
    }

    public synchronized boolean asyncComplete() {
        this.pauseNonContainerThread();
        boolean doComplete = false;
        if (this.state == AsyncState.STARTING) {
            this.state = AsyncState.MUST_COMPLETE;
        } else if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.COMPLETING;
            doComplete = true;
        } else if (this.state == AsyncState.TIMING_OUT || this.state == AsyncState.ERROR) {
            this.state = AsyncState.MUST_COMPLETE;
        } else if (this.state == AsyncState.READ_WRITE_OP) {
            this.clearNonBlockingListeners();
            this.state = AsyncState.MUST_COMPLETE;
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncComplete()", this.state}));
        }
        return doComplete;
    }

    public synchronized boolean asyncTimeout() {
        if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.TIMING_OUT;
            return true;
        }
        if (this.state == AsyncState.COMPLETING || this.state == AsyncState.DISPATCHING || this.state == AsyncState.DISPATCHED) {
            return false;
        }
        throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncTimeout()", this.state}));
    }

    public synchronized boolean asyncDispatch() {
        this.pauseNonContainerThread();
        boolean doDispatch = false;
        if (this.state == AsyncState.STARTING || this.state == AsyncState.TIMING_OUT || this.state == AsyncState.ERROR) {
            this.state = AsyncState.MUST_DISPATCH;
        } else if (this.state == AsyncState.STARTED) {
            this.state = AsyncState.DISPATCHING;
            doDispatch = true;
        } else if (this.state == AsyncState.READ_WRITE_OP) {
            this.state = AsyncState.DISPATCHING;
            if (!ContainerThreadMarker.isContainerThread()) {
                doDispatch = true;
            }
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncDispatch()", this.state}));
        }
        return doDispatch;
    }

    public synchronized void asyncDispatched() {
        if (this.state != AsyncState.DISPATCHING && this.state != AsyncState.MUST_DISPATCH) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncDispatched()", this.state}));
        }
        this.state = AsyncState.DISPATCHED;
    }

    public synchronized void asyncError() {
        if (this.state != AsyncState.STARTING && this.state != AsyncState.DISPATCHED && this.state != AsyncState.TIMING_OUT && this.state != AsyncState.MUST_COMPLETE && this.state != AsyncState.READ_WRITE_OP) {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncError()", this.state}));
        }
        this.clearNonBlockingListeners();
        this.state = AsyncState.ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void asyncRun(Runnable runnable) {
        if (this.state == AsyncState.STARTING || this.state == AsyncState.STARTED || this.state == AsyncState.READ_WRITE_OP) {
            ClassLoader oldCL;
            PrivilegedGetTccl pa;
            if (Constants.IS_SECURITY_ENABLED) {
                pa = new PrivilegedGetTccl();
                oldCL = (ClassLoader)AccessController.doPrivileged(pa);
            } else {
                oldCL = Thread.currentThread().getContextClassLoader();
            }
            try {
                if (Constants.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(this.getClass().getClassLoader());
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                }
                this.processor.getExecutor().execute(runnable);
            }
            finally {
                if (Constants.IS_SECURITY_ENABLED) {
                    pa = new PrivilegedSetTccl(oldCL);
                    AccessController.doPrivileged(pa);
                } else {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
            }
        } else {
            throw new IllegalStateException(sm.getString("asyncStateMachine.invalidAsyncState", new Object[]{"asyncRun()", this.state}));
        }
    }

    public synchronized void recycle() {
        this.notifyAll();
        this.asyncCtxt = null;
        this.state = AsyncState.DISPATCHED;
    }

    private void clearNonBlockingListeners() {
        this.processor.getRequest().listener = null;
        this.processor.getRequest().getResponse().listener = null;
    }

    private synchronized void pauseNonContainerThread() {
        while (!ContainerThreadMarker.isContainerThread() && this.state.getPauseNonContainerThread()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static enum AsyncState {
        DISPATCHED(false, false, false, false, false),
        STARTING(true, true, false, false, true),
        STARTED(true, true, false, false, false),
        MUST_COMPLETE(true, true, true, false, false),
        COMPLETING(true, false, true, false, false),
        TIMING_OUT(true, true, false, false, false),
        MUST_DISPATCH(true, true, false, true, true),
        DISPATCHING(true, false, false, true, false),
        READ_WRITE_OP(true, true, false, false, true),
        ERROR(true, true, false, false, false);

        private final boolean isAsync;
        private final boolean isStarted;
        private final boolean isCompleting;
        private final boolean isDispatching;
        private final boolean pauseNonContainerThread;

        private AsyncState(boolean isAsync, boolean isStarted, boolean isCompleting, boolean isDispatching, boolean pauseNonContainerThread) {
            this.isAsync = isAsync;
            this.isStarted = isStarted;
            this.isCompleting = isCompleting;
            this.isDispatching = isDispatching;
            this.pauseNonContainerThread = pauseNonContainerThread;
        }

        public boolean isAsync() {
            return this.isAsync;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public boolean isDispatching() {
            return this.isDispatching;
        }

        public boolean isCompleting() {
            return this.isCompleting;
        }

        public boolean getPauseNonContainerThread() {
            return this.pauseNonContainerThread;
        }
    }
}

