/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.cpu;

import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.cpu.CPUView;
import com.sun.tools.visualvm.sampler.cpu.ThreadsCPUInfo;
import com.sun.tools.visualvm.uisupport.HTMLTextArea;
import com.sun.tools.visualvm.uisupport.SeparatorLine;
import com.sun.tools.visualvm.uisupport.TransparentToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.management.ThreadInfo;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class ThreadsCPUView
extends JPanel {
    private static final double NANOS_MILIS = 1000000.0;
    private final AbstractSamplerSupport.Refresher refresher;
    private boolean forceRefresh = false;
    private HTMLTextArea area;
    private AbstractButton deltaButton;
    private AbstractButton pauseButton;
    private AbstractButton refreshButton;
    private JExtendedTable resTable;
    private ExtendedTableModel resTableModel;
    private JExtendedTablePanel resTablePanel;
    private FilterComponent filterComponent;
    private CustomBarCellRenderer customBarCellRenderer;
    private LabelTableCellRenderer labelTableCellRenderer;
    private LabelBracketTableCellRenderer labelBracketTableCellRenderer;
    private String filterString = "";
    private int filterType = 20;
    private List<ThreadInfo> threads;
    private List<Long> threadCPUInfo;
    private List<Long> threadCPUInfoPerSec;
    private ThreadsCPUInfo currentThreadsInfo;
    private ThreadsCPUInfo baseThreadsInfo;
    private List<Integer> filteredSortedIndexes = new ArrayList<Integer>();
    private int totalThreads = -1;
    private long totalCPUTime;
    private long baseTotalCPUTime = -1L;
    private int sortingColumn = 1;
    private boolean sortOrder = false;
    private String[] columnNames;
    private TableCellRenderer[] columnRenderers;
    private String[] columnToolTips;
    private Class[] columnTypes;
    private int[] columnWidths;
    private int minNamesColumnWidth;

    ThreadsCPUView(AbstractSamplerSupport.Refresher refresher) {
        this.refresher = refresher;
        this.initColumnsData();
        this.initComponents();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsCPUView.this.isShowing()) {
                    ThreadsCPUView.this.refresher.refresh();
                }
            }
        });
    }

    void initSession() {
    }

    boolean isPaused() {
        return this.pauseButton.isSelected() && !this.forceRefresh;
    }

    boolean isEmpty() {
        return this.resTableModel.getRowCount() == 0;
    }

    void refresh(ThreadsCPUInfo info) {
        if (!this.isShowing() || this.pauseButton.isSelected() && !this.forceRefresh) {
            return;
        }
        this.forceRefresh = false;
        this.threads = info.getThreads();
        this.threadCPUInfo = info.getThreadCPUTime();
        this.totalCPUTime = info.getTotalCPUTime();
        if (this.currentThreadsInfo != null) {
            this.threadCPUInfoPerSec = this.currentThreadsInfo.getCPUTimePerSecond(info);
        }
        this.currentThreadsInfo = info;
        if (this.deltaButton.isSelected()) {
            if (this.baseThreadsInfo == null) {
                this.baseThreadsInfo = info;
                this.baseTotalCPUTime = this.totalCPUTime;
                this.columnRenderers[2] = this.labelTableCellRenderer;
                this.updateColumnRenderers();
            }
            this.totalThreads = this.threads.size() - this.baseThreadsInfo.getThreads().size();
            this.threadCPUInfo = this.baseThreadsInfo.getThreadCPUTimeDiff(info);
            this.totalCPUTime = this.baseThreadsInfo.getTotalDiffCPUTime();
        } else {
            if (this.baseThreadsInfo != null) {
                this.baseThreadsInfo = null;
                this.baseTotalCPUTime = -1L;
                this.columnRenderers[2] = this.labelBracketTableCellRenderer;
                this.updateColumnRenderers();
            }
            this.threadCPUInfo = info.getThreadCPUTime();
            this.totalCPUTime = info.getTotalCPUTime();
            this.totalThreads = this.threads.size();
        }
        this.customBarCellRenderer.setMaximum(this.totalCPUTime);
        this.updateData(false);
        this.refreshUI();
    }

    void terminate() {
        this.pauseButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.deltaButton.setEnabled(false);
    }

    private void updateData(boolean sortOnly) {
        int selectedRow = this.resTable.getSelectedRow();
        String selectedRowContents = null;
        if (selectedRow != -1) {
            selectedRowContents = (String)this.resTable.getValueAt(selectedRow, 0);
        }
        if (!sortOnly) {
            this.filterData();
        }
        this.sortData();
        this.resTableModel.fireTableDataChanged();
        if (selectedRowContents != null) {
            this.resTable.selectRowByContents(selectedRowContents, 0, false);
        }
    }

    private void filterData() {
        this.filteredSortedIndexes.clear();
        String[] filterStrings = FilterComponent.getFilterValues((String)this.filterString);
        if (this.filterType == 0 || filterStrings == null || filterStrings[0].equals("")) {
            for (int i = 0; i < this.threads.size(); ++i) {
                this.filteredSortedIndexes.add(i);
            }
        } else {
            for (int i = 0; i < this.threads.size(); ++i) {
                if (!ThreadsCPUView.passedFilters(this.threads.get(i).getThreadName(), filterStrings, this.filterType)) continue;
                this.filteredSortedIndexes.add(i);
            }
        }
    }

    private static boolean passedFilters(String value, String[] filters, int type) {
        for (int i = 0; i < filters.length; ++i) {
            if (!ThreadsCPUView.passedFilter(value, filters[i], type)) continue;
            return true;
        }
        return false;
    }

    private static boolean passedFilter(String value, String filter, int type) {
        switch (type) {
            case 10: {
                return value.regionMatches(true, 0, filter, 0, filter.length());
            }
            case 20: {
                return value.toLowerCase().indexOf(filter.toLowerCase()) != -1;
            }
            case 30: {
                return value.regionMatches(true, value.length() - filter.length(), filter, 0, filter.length());
            }
            case 40: {
                return value.equalsIgnoreCase(filter);
            }
            case 50: {
                return value.matches(filter);
            }
        }
        return false;
    }

    private void sortData() {
        Collections.sort(this.filteredSortedIndexes, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer index1 = (Integer)o1;
                Integer index2 = (Integer)o2;
                switch (ThreadsCPUView.this.sortingColumn) {
                    case 0: {
                        ThreadInfo ti1 = (ThreadInfo)ThreadsCPUView.this.threads.get(index1);
                        ThreadInfo ti2 = (ThreadInfo)ThreadsCPUView.this.threads.get(index2);
                        return ThreadsCPUView.this.sortOrder ? Long.valueOf(ti1.getThreadId()).compareTo(ti2.getThreadId()) : Long.valueOf(ti2.getThreadId()).compareTo(ti1.getThreadId());
                    }
                    case 1: 
                    case 2: {
                        Long alloc1 = (Long)ThreadsCPUView.this.threadCPUInfo.get(index1);
                        Long alloc2 = (Long)ThreadsCPUView.this.threadCPUInfo.get(index2);
                        return ThreadsCPUView.this.sortOrder ? alloc1.compareTo(alloc2) : alloc2.compareTo(alloc1);
                    }
                    case 3: {
                        Long allocSec1 = (Long)ThreadsCPUView.this.threadCPUInfoPerSec.get(index1);
                        Long allocSec2 = (Long)ThreadsCPUView.this.threadCPUInfoPerSec.get(index2);
                        return ThreadsCPUView.this.sortOrder ? allocSec1.compareTo(allocSec2) : allocSec2.compareTo(allocSec1);
                    }
                }
                return 0;
            }
        });
    }

    private JExtendedTable initTable() {
        this.resTableModel = new ExtendedTableModel(new SortableTableModel(){

            public String getColumnName(int col) {
                return ThreadsCPUView.this.columnNames[col];
            }

            public int getRowCount() {
                return ThreadsCPUView.this.filteredSortedIndexes.size();
            }

            public int getColumnCount() {
                return ThreadsCPUView.this.columnNames.length;
            }

            public Class getColumnClass(int col) {
                return ThreadsCPUView.this.columnTypes[col];
            }

            public Object getValueAt(int row, int col) {
                int index = (Integer)ThreadsCPUView.this.filteredSortedIndexes.get(row);
                long threadCPUtime = (Long)ThreadsCPUView.this.threadCPUInfo.get(index);
                double threadCPUtimeInMs = (double)threadCPUtime / 1000000.0;
                boolean deltas = ThreadsCPUView.this.baseThreadsInfo != null;
                NumberFormat formatter = NumberFormat.getInstance();
                formatter.setMaximumFractionDigits(3);
                switch (col) {
                    case 0: {
                        ThreadInfo threadInfo = (ThreadInfo)ThreadsCPUView.this.threads.get(index);
                        return threadInfo.getThreadName();
                    }
                    case 1: {
                        return threadCPUtime;
                    }
                    case 2: {
                        if (deltas) {
                            return threadCPUtimeInMs > 0.0 ? "+" + formatter.format(threadCPUtimeInMs) : formatter.format(threadCPUtimeInMs);
                        }
                        return threadCPUtimeInMs == 0.0 ? "0 (0.0%)" : formatter.format(threadCPUtimeInMs) + " (" + this.getPercentValue(threadCPUtimeInMs, ThreadsCPUView.this.totalCPUTime) + "%)";
                    }
                    case 3: {
                        if (ThreadsCPUView.this.threadCPUInfoPerSec != null) {
                            return formatter.format((double)((Long)ThreadsCPUView.this.threadCPUInfoPerSec.get(index)).longValue() / 1000000.0);
                        }
                        return "0";
                    }
                }
                return null;
            }

            private String getPercentValue(double value, double basevalue) {
                int basis = (int)(value / basevalue * 1000.0);
                int percent = basis / 10;
                int permille = basis % 10;
                return "" + percent + "." + permille;
            }

            public String getColumnToolTipText(int col) {
                return ThreadsCPUView.this.columnToolTips[col];
            }

            public void sortByColumn(int column, boolean order) {
                ThreadsCPUView.this.sortingColumn = column;
                ThreadsCPUView.this.sortOrder = order;
                ThreadsCPUView.this.updateData(true);
            }

            public boolean getInitialSorting(int column) {
                switch (column) {
                    case 0: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.resTable = new JExtendedTable((TableModel)this.resTableModel){

            public void doLayout() {
                int columnsWidthsSum = 0;
                int realFirstColumn = -1;
                for (int i = 0; i < ThreadsCPUView.this.resTableModel.getColumnCount(); ++i) {
                    int index = ThreadsCPUView.this.resTableModel.getRealColumn(i);
                    if (index == 0) {
                        realFirstColumn = i;
                        continue;
                    }
                    columnsWidthsSum += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (realFirstColumn != -1) {
                    this.getColumnModel().getColumn(realFirstColumn).setPreferredWidth(Math.max(this.getWidth() - columnsWidthsSum, ThreadsCPUView.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.resTableModel.setTable((JTable)this.resTable);
        this.resTableModel.setInitialSorting(this.sortingColumn, this.sortOrder);
        this.resTable.setRowSelectionAllowed(true);
        this.resTable.setSelectionMode(0);
        this.resTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.resTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.resTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.resTable.setShowHorizontalLines(false);
        this.resTable.setShowVerticalLines(true);
        this.resTable.setRowMargin(0);
        this.resTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.resTable.getAccessibleContext().setAccessibleName("");
        this.resTable.getAccessibleContext().setAccessibleDescription("");
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>(this.resTable.getFocusTraversalKeys(0));
        keys.add(KeyStroke.getKeyStroke(9, 0));
        this.resTable.setFocusTraversalKeys(0, keys);
        keys = new HashSet(this.resTable.getFocusTraversalKeys(1));
        keys.add(KeyStroke.getKeyStroke(9, 1));
        this.resTable.setFocusTraversalKeys(1, keys);
        this.setColumnsData();
        return this.resTable;
    }

    protected void initColumnsData() {
        int maxWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 14;
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        this.customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        this.labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnNames = new String[]{NbBundle.getMessage(CPUView.class, (String)"COL_Thread_name"), NbBundle.getMessage(CPUView.class, (String)"COL_ABytes_rel"), NbBundle.getMessage(CPUView.class, (String)"COL_ABytes"), NbBundle.getMessage(CPUView.class, (String)"COL_ABytes_Sec")};
        this.columnToolTips = new String[]{NbBundle.getMessage(CPUView.class, (String)"COL_Thread_name"), NbBundle.getMessage(CPUView.class, (String)"COL_ABytes_rel"), NbBundle.getMessage(CPUView.class, (String)"COL_ABytes"), NbBundle.getMessage(CPUView.class, (String)"COL_ABytes_Sec")};
        this.columnTypes = new Class[]{String.class, Number.class, String.class, String.class};
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, this.customBarCellRenderer, this.labelBracketTableCellRenderer, this.labelTableCellRenderer};
        this.columnWidths = new int[]{maxWidth, maxWidth, maxWidth, maxWidth};
    }

    private void setColumnsData() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            int index = this.resTableModel.getRealColumn(i);
            if (index == 0) {
                colModel.getColumn(i).setPreferredWidth(this.minNamesColumnWidth);
            } else {
                colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            }
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    private void updateColumnRenderers() {
        TableColumnModel colModel = this.resTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[this.resTableModel.getRealColumn(i)]);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        TransparentToolBar toolBar = new TransparentToolBar();
        this.pauseButton = new JToggleButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                boolean selected = ThreadsCPUView.this.pauseButton.isSelected();
                ThreadsCPUView.this.refreshButton.setEnabled(selected);
                if (!selected) {
                    ThreadsCPUView.this.refresher.refresh();
                }
            }
        };
        this.pauseButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/pause.png", (boolean)true)));
        this.pauseButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Pause_results"));
        this.pauseButton.setOpaque(false);
        toolBar.addItem((Component)this.pauseButton);
        this.refreshButton = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                ThreadsCPUView.this.forceRefresh = true;
                ThreadsCPUView.this.refresher.refresh();
            }
        };
        this.refreshButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/sampler/resources/update.png", (boolean)true)));
        this.refreshButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Update_results"));
        this.refreshButton.setEnabled(this.pauseButton.isSelected());
        this.refreshButton.setOpaque(false);
        toolBar.addItem((Component)this.refreshButton);
        toolBar.addSeparator();
        this.deltaButton = new JToggleButton(NbBundle.getMessage(CPUView.class, (String)"LBL_Deltas")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                ThreadsCPUView.this.refresher.refresh();
            }
        };
        this.deltaButton.setToolTipText(NbBundle.getMessage(CPUView.class, (String)"TOOLTIP_Deltas"));
        this.deltaButton.setOpaque(false);
        toolBar.addItem((Component)this.deltaButton);
        toolBar.addFiller();
        int maxHeight = this.pauseButton.getPreferredSize().height;
        maxHeight = Math.max(maxHeight, this.refreshButton.getPreferredSize().height);
        maxHeight = Math.max(maxHeight, this.deltaButton.getPreferredSize().height);
        int width = this.pauseButton.getPreferredSize().width;
        Dimension size = new Dimension(maxHeight, maxHeight);
        this.pauseButton.setMinimumSize(size);
        this.pauseButton.setPreferredSize(size);
        this.pauseButton.setMaximumSize(size);
        width = this.refreshButton.getPreferredSize().width;
        size = new Dimension(maxHeight, maxHeight);
        this.refreshButton.setMinimumSize(size);
        this.refreshButton.setPreferredSize(size);
        this.refreshButton.setMaximumSize(size);
        width = this.deltaButton.getPreferredSize().width;
        size = new Dimension(width + 5, maxHeight);
        this.deltaButton.setMinimumSize(size);
        this.deltaButton.setPreferredSize(size);
        this.deltaButton.setMaximumSize(size);
        JPanel resultsPanel = new JPanel(new BorderLayout());
        resultsPanel.setOpaque(false);
        JPanel areaPanel = new JPanel(new BorderLayout());
        areaPanel.setOpaque(false);
        this.area = new HTMLTextArea();
        this.area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.refreshUI();
        areaPanel.add((Component)this.area, "North");
        areaPanel.add((Component)new SeparatorLine(true), "South");
        resultsPanel.add((Component)areaPanel, "North");
        this.add((Component)TransparentToolBar.withSeparator((TransparentToolBar)toolBar), "North");
        this.resTable = this.initTable();
        this.resTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThreadsCPUView.this.revalidate();
            }
        });
        this.resTablePanel = new JExtendedTablePanel(this.resTable);
        this.resTablePanel.clearBorders();
        resultsPanel.add((Component)this.resTablePanel, "Center");
        this.add((Component)resultsPanel, "Center");
        this.initFilterPanel();
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create((boolean)true, (boolean)true);
        this.filterComponent.setFilter(this.filterString, this.filterType);
        this.filterComponent.setHint(NbBundle.getMessage(CPUView.class, (String)"LBL_Thread_filter"));
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThreadsCPUView.this.filterString = ThreadsCPUView.this.filterComponent.getFilterValue();
                ThreadsCPUView.this.filterType = ThreadsCPUView.this.filterComponent.getFilterType();
                ThreadsCPUView.this.updateData(false);
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    private void refreshUI() {
        int selStart = this.area.getSelectionStart();
        int selEnd = this.area.getSelectionEnd();
        this.area.setText(this.getBasicTelemetry());
        this.area.select(selStart, selEnd);
    }

    private String getBasicTelemetry() {
        String sThreads;
        boolean deltas;
        boolean bl = deltas = this.baseThreadsInfo != null;
        String string = this.totalThreads == -1 ? "" : (sThreads = (deltas && this.totalThreads > 0 ? "+" : "") + NumberFormat.getInstance().format(this.totalThreads));
        String sCPUTime = this.totalCPUTime == -1L ? "" : (deltas && this.totalCPUTime > 0L ? "+" : "") + NumberFormat.getInstance().format(this.totalCPUTime / 1000000L);
        String ssThreads = NbBundle.getMessage(CPUView.class, (String)"LBL_Threads", (Object)sThreads);
        String ssCPUTime = NbBundle.getMessage(CPUView.class, (String)"LBL_CPUTime", (Object)sCPUTime);
        return "<nobr>" + ssThreads + "&nbsp;&nbsp;&nbsp;&nbsp;" + ssCPUTime + "</nobr>";
    }
}

