/*
 * Decompiled with CFR 0.152.
 */
package dguitar.adaptors.song.impl;

import dguitar.adaptors.song.RepeatedSongPhrase;
import dguitar.adaptors.song.SongMeasure;
import dguitar.adaptors.song.SongPhrase;

public class RepeatedSongPhraseImpl
implements RepeatedSongPhrase {
    SongPhrase phrase;
    int repeatCount;

    public RepeatedSongPhraseImpl(SongPhrase phrase, int repeatCount) {
        this.phrase = phrase;
        this.repeatCount = repeatCount;
    }

    public int getScoreMeasureCount() {
        return this.phrase.getScoreMeasureCount();
    }

    public SongMeasure getScoreMeasure(int measure) {
        int sc = this.phrase.getScoreMeasureCount();
        if (measure < 0 || measure >= sc) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.phrase.getScoreMeasure(measure);
    }

    public int getPerformanceMeasureCount() {
        return (this.repeatCount + 1) * this.phrase.getPerformanceMeasureCount();
    }

    public SongMeasure getPerformanceMeasure(int measure) {
        int pc = this.phrase.getPerformanceMeasureCount();
        if (measure < 0 || measure >= (this.repeatCount + 1) * pc) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.phrase.getPerformanceMeasure(measure % pc);
    }

    public SongPhrase getPhrase() {
        return this.phrase;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }
}

