/*
 * Decompiled with CFR 0.152.
 */
package dguitar.adaptors.song.impl;

import dguitar.adaptors.song.SongEvent;
import dguitar.adaptors.song.SongMeasureTrack;
import dguitar.adaptors.song.SongTrack;
import dguitar.adaptors.song.SongVirtualTrack;
import dguitar.adaptors.song.impl.SongVirtualTrackImpl;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class SongMeasureTrackImpl
implements SongMeasureTrack {
    SongTrack track;
    Vector virtualTracks;

    public SongMeasureTrackImpl(SongTrack track) {
        this.track = track;
        int virtualTrackCount = track.getVirtualTrackCount();
        this.virtualTracks = new Vector(virtualTrackCount);
        int i = 0;
        while (i < virtualTrackCount) {
            this.virtualTracks.add(new SongVirtualTrackImpl(this, i));
            ++i;
        }
    }

    public SongVirtualTrack getVirtualTrack(int virtualTrackID) {
        return (SongVirtualTrack)this.virtualTracks.get(virtualTrackID);
    }

    public List getEvents() {
        Vector x = new Vector();
        int i = 0;
        while (i < this.virtualTracks.size()) {
            SongVirtualTrack svt = (SongVirtualTrack)this.virtualTracks.get(i);
            x.addAll(svt.getEvents());
            ++i;
        }
        Collections.sort(x, new Comparator(){

            public int compare(Object o1, Object o2) {
                SongEvent s1 = (SongEvent)o1;
                SongEvent s2 = (SongEvent)o2;
                return s1.getTime() - s2.getTime();
            }
        });
        return x;
    }

    public SongTrack getTrack() {
        return this.track;
    }
}

