/*
 * Decompiled with CFR 0.152.
 */
package test.suite;

import dguitar.players.sound.midi.demo.LinePrinter;
import dguitar.players.sound.midi.demo.PlayerDemo;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import test.songs.MidiSongDefinition;
import test.songs.SongArchive;
import test.tools.MockMidiPlayer;

public class PlayerDemoTest
extends TestCase {
    public void testPlayerDemo() {
        String resultsFile = "src/test/output.txt";
        MidiSongDefinition sd = SongArchive.aguaSongDefinition();
        try {
            ComparisonLinePrinter lp = new ComparisonLinePrinter(resultsFile);
            PlayerDemo.playerDemo(sd.getGpFileName(), new MockMidiPlayer(), lp);
            PlayerDemoTest.assertEquals((String)lp.getLeftSide(), (String)lp.getRightSide());
        }
        catch (FileNotFoundException e) {
            PlayerDemoTest.fail((String)"file not found exception");
        }
    }

    class PrintStreamLinePrinter
    implements LinePrinter {
        FileOutputStream fos;
        PrintStream ps;

        PrintStreamLinePrinter(String resultsFile) throws FileNotFoundException {
            this.fos = new FileOutputStream(resultsFile);
            this.ps = new PrintStream(this.fos);
        }

        public void println(String s) {
            this.ps.println(s);
        }
    }

    class ComparisonLinePrinter
    implements LinePrinter {
        FileReader fr;
        BufferedReader br;
        String leftSide = "";
        String rightSide = "";

        public String getLeftSide() {
            return this.leftSide;
        }

        public String getRightSide() {
            return this.rightSide;
        }

        public void setSides(String l, String r) {
            if (this.leftSide.equals("")) {
                this.leftSide = l;
                this.rightSide = r;
            }
        }

        ComparisonLinePrinter(String resultsFile) throws FileNotFoundException {
            this.fr = new FileReader(resultsFile);
            this.br = new BufferedReader(this.fr);
        }

        public void println(String s) {
            try {
                String testAgainst = this.br.readLine();
                if (!testAgainst.equals(s)) {
                    this.setSides(testAgainst, s);
                }
            }
            catch (IOException e) {
                PlayerDemoTest.fail((String)"ioexception");
            }
        }
    }
}

