/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Bits;

public class TermVectorLeafReader
extends LeafReader {
    private final Fields fields;
    private final FieldInfos fieldInfos;

    public TermVectorLeafReader(final String field, final Terms terms) {
        this.fields = new Fields(){

            public Iterator<String> iterator() {
                return Collections.singletonList(field).iterator();
            }

            public Terms terms(String fld) throws IOException {
                if (!field.equals(fld)) {
                    return null;
                }
                return terms;
            }

            public int size() {
                return 1;
            }
        };
        IndexOptions indexOptions = !terms.hasFreqs() ? IndexOptions.DOCS : (!terms.hasPositions() ? IndexOptions.DOCS_AND_FREQS : (!terms.hasOffsets() ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS));
        FieldInfo fieldInfo = new FieldInfo(field, 0, true, true, terms.hasPayloads(), indexOptions, DocValuesType.NONE, -1L, Collections.emptyMap());
        this.fieldInfos = new FieldInfos(new FieldInfo[]{fieldInfo});
    }

    public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
        TermVectorLeafReader.addCoreClosedListenerAsReaderClosedListener((IndexReader)this, (LeafReader.CoreClosedListener)listener);
    }

    public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
        TermVectorLeafReader.removeCoreClosedListenerAsReaderClosedListener((IndexReader)this, (LeafReader.CoreClosedListener)listener);
    }

    protected void doClose() throws IOException {
    }

    public Fields fields() throws IOException {
        return this.fields;
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return null;
    }

    public Bits getDocsWithField(String field) throws IOException {
        return null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return null;
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public Bits getLiveDocs() {
        return null;
    }

    public void checkIntegrity() throws IOException {
    }

    public Fields getTermVectors(int docID) throws IOException {
        if (docID != 0) {
            return null;
        }
        return this.fields();
    }

    public int numDocs() {
        return 1;
    }

    public int maxDoc() {
        return 1;
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
    }
}

