/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.Retry;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncBulkByScrollAction<Request extends AbstractBulkByScrollRequest<Request>, Response> {
    protected final Request mainRequest;
    protected final BulkByScrollTask task;
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final AtomicReference<String> scroll = new AtomicReference();
    private final Set<String> destinationIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ESLogger logger;
    private final Client client;
    private final ThreadPool threadPool;
    private final SearchRequest firstSearchRequest;
    private final ActionListener<Response> listener;
    private final Retry retry;

    public AbstractAsyncBulkByScrollAction(BulkByScrollTask task, ESLogger logger, Client client, ThreadPool threadPool, Version smallestNonClientVersion, Request mainRequest, SearchRequest firstSearchRequest, ActionListener<Response> listener) {
        if (smallestNonClientVersion.before(Version.V_2_3_0)) {
            throw new IllegalStateException("Refusing to execute [" + mainRequest + "] because the entire cluster has not been upgraded to 2.3");
        }
        this.task = task;
        this.logger = logger;
        this.client = client;
        this.threadPool = threadPool;
        this.mainRequest = mainRequest;
        this.firstSearchRequest = firstSearchRequest;
        this.listener = listener;
        this.retry = Retry.on(EsRejectedExecutionException.class).policy(this.wrapBackoffPolicy(this.backoffPolicy()));
        ((AbstractBulkByScrollRequest)((Object)mainRequest)).applyDefaults();
    }

    protected abstract BulkRequest buildBulk(Iterable<SearchHit> var1);

    protected abstract Response buildResponse(TimeValue var1, List<BulkItemResponse.Failure> var2, List<ShardSearchFailure> var3, boolean var4);

    public void start() {
        this.initialSearch();
    }

    public BulkByScrollTask getTask() {
        return this.task;
    }

    void initialSearch() {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        try {
            this.startTime.set(System.nanoTime());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executing initial scroll against {}{}", new Object[]{this.firstSearchRequest.indices() == null || this.firstSearchRequest.indices().length == 0 ? "all indices" : this.firstSearchRequest.indices(), this.firstSearchRequest.types() == null || this.firstSearchRequest.types().length == 0 ? "" : this.firstSearchRequest.types()});
            }
            this.client.search(new SearchRequest(this.firstSearchRequest, this.mainRequest), (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    AbstractAsyncBulkByScrollAction.this.logger.debug("[{}] documents match query", new Object[]{response.getHits().getTotalHits()});
                    AbstractAsyncBulkByScrollAction.this.onScrollResponse(response);
                }

                public void onFailure(Throwable e) {
                    AbstractAsyncBulkByScrollAction.this.finishHim(e);
                }
            });
        }
        catch (Throwable t) {
            this.finishHim(t);
        }
    }

    void setScroll(String scroll) {
        this.scroll.set(scroll);
    }

    void onScrollResponse(final SearchResponse searchResponse) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        this.setScroll(searchResponse.getScrollId());
        if (searchResponse.getShardFailures() != null && searchResponse.getShardFailures().length > 0 || searchResponse.isTimedOut()) {
            this.startNormalTermination(Collections.emptyList(), Collections.unmodifiableList(Arrays.asList(searchResponse.getShardFailures())), searchResponse.isTimedOut());
            return;
        }
        long total = searchResponse.getHits().totalHits();
        if (((AbstractBulkByScrollRequest)((Object)this.mainRequest)).getSize() > 0) {
            total = Math.min(total, (long)((AbstractBulkByScrollRequest)((Object)this.mainRequest)).getSize());
        }
        this.task.setTotal(total);
        this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

            protected void doRun() throws Exception {
                BulkRequest request;
                long remaining;
                SearchHit[] docs = searchResponse.getHits().getHits();
                AbstractAsyncBulkByScrollAction.this.logger.debug("scroll returned [{}] documents with a scroll id of [{}]", new Object[]{docs.length, searchResponse.getScrollId()});
                if (docs.length == 0) {
                    AbstractAsyncBulkByScrollAction.this.startNormalTermination(Collections.emptyList(), Collections.emptyList(), false);
                    return;
                }
                AbstractAsyncBulkByScrollAction.this.task.countBatch();
                List<SearchHit> docsIterable = Arrays.asList(docs);
                if (((AbstractBulkByScrollRequest)((Object)AbstractAsyncBulkByScrollAction.this.mainRequest)).getSize() != -1 && (remaining = Math.max(0L, (long)((AbstractBulkByScrollRequest)((Object)AbstractAsyncBulkByScrollAction.this.mainRequest)).getSize() - AbstractAsyncBulkByScrollAction.this.task.getSuccessfullyProcessed())) < (long)docs.length) {
                    docsIterable = docsIterable.subList(0, (int)remaining);
                }
                if ((request = AbstractAsyncBulkByScrollAction.this.buildBulk(docsIterable)).requests().isEmpty()) {
                    AbstractAsyncBulkByScrollAction.this.startNextScroll();
                    return;
                }
                request.timeout(((AbstractBulkByScrollRequest)((Object)AbstractAsyncBulkByScrollAction.this.mainRequest)).getTimeout());
                request.consistencyLevel(((AbstractBulkByScrollRequest)((Object)AbstractAsyncBulkByScrollAction.this.mainRequest)).getConsistency());
                if (AbstractAsyncBulkByScrollAction.this.logger.isDebugEnabled()) {
                    AbstractAsyncBulkByScrollAction.this.logger.debug("sending [{}] entry, [{}] bulk request", new Object[]{request.requests().size(), new ByteSizeValue(request.estimatedSizeInBytes())});
                }
                AbstractAsyncBulkByScrollAction.this.sendBulkRequest(request);
            }

            public void onFailure(Throwable t) {
                AbstractAsyncBulkByScrollAction.this.finishHim(t);
            }
        });
    }

    void sendBulkRequest(BulkRequest request) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        this.retry.withAsyncBackoff(this.client, request, (ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse response) {
                AbstractAsyncBulkByScrollAction.this.onBulkResponse(response);
            }

            public void onFailure(Throwable e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    void onBulkResponse(BulkResponse response) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        try {
            ArrayList<BulkItemResponse.Failure> failures = new ArrayList<BulkItemResponse.Failure>();
            HashSet<String> destinationIndicesThisBatch = new HashSet<String>();
            for (BulkItemResponse item : response) {
                if (item.isFailed()) {
                    this.recordFailure(item.getFailure(), failures);
                    continue;
                }
                switch (item.getOpType()) {
                    case "index": 
                    case "create": {
                        IndexResponse ir = (IndexResponse)item.getResponse();
                        if (ir.isCreated()) {
                            this.task.countCreated();
                            break;
                        }
                        this.task.countUpdated();
                        break;
                    }
                    case "delete": {
                        this.task.countDeleted();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown op type:  " + item.getOpType());
                    }
                }
                destinationIndicesThisBatch.add(item.getIndex());
            }
            this.addDestinationIndices(destinationIndicesThisBatch);
            if (!failures.isEmpty()) {
                this.startNormalTermination(Collections.unmodifiableList(failures), Collections.emptyList(), false);
                return;
            }
            if (((AbstractBulkByScrollRequest)((Object)this.mainRequest)).getSize() != -1 && this.task.getSuccessfullyProcessed() >= (long)((AbstractBulkByScrollRequest)((Object)this.mainRequest)).getSize()) {
                this.startNormalTermination(Collections.emptyList(), Collections.emptyList(), false);
                return;
            }
            this.startNextScroll();
        }
        catch (Throwable t) {
            this.finishHim(t);
        }
    }

    void startNextScroll() {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        SearchScrollRequest request = new SearchScrollRequest(this.mainRequest);
        request.scrollId(this.scroll.get()).scroll(this.firstSearchRequest.scroll());
        this.client.searchScroll(request, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                AbstractAsyncBulkByScrollAction.this.onScrollResponse(response);
            }

            public void onFailure(Throwable e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    private void recordFailure(BulkItemResponse.Failure failure, List<BulkItemResponse.Failure> failures) {
        if (failure.getStatus() == RestStatus.CONFLICT) {
            this.task.countVersionConflict();
            if (!((AbstractBulkByScrollRequest)((Object)this.mainRequest)).isAbortOnVersionConflict()) {
                return;
            }
        }
        failures.add(failure);
    }

    void startNormalTermination(final List<BulkItemResponse.Failure> indexingFailures, final List<ShardSearchFailure> searchFailures, final boolean timedOut) {
        if (this.task.isCancelled() || !((AbstractBulkByScrollRequest)((Object)this.mainRequest)).isRefresh() || this.destinationIndices.isEmpty()) {
            this.finishHim(null, indexingFailures, searchFailures, timedOut);
            return;
        }
        RefreshRequest refresh = new RefreshRequest(this.mainRequest);
        refresh.indices(this.destinationIndices.toArray(new String[this.destinationIndices.size()]));
        this.client.admin().indices().refresh(refresh, (ActionListener)new ActionListener<RefreshResponse>(){

            public void onResponse(RefreshResponse response) {
                AbstractAsyncBulkByScrollAction.this.finishHim(null, indexingFailures, searchFailures, timedOut);
            }

            public void onFailure(Throwable e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    void finishHim(Throwable failure) {
        this.finishHim(failure, Collections.emptyList(), Collections.emptyList(), false);
    }

    void finishHim(Throwable failure, List<BulkItemResponse.Failure> indexingFailures, List<ShardSearchFailure> searchFailures, boolean timedOut) {
        final String scrollId = this.scroll.get();
        if (Strings.hasLength((String)scrollId)) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest(this.mainRequest);
            clearScrollRequest.addScrollId(scrollId);
            this.client.clearScroll(clearScrollRequest, (ActionListener)new ActionListener<ClearScrollResponse>(){

                public void onResponse(ClearScrollResponse response) {
                    AbstractAsyncBulkByScrollAction.this.logger.debug("Freed [{}] contexts", new Object[]{response.getNumFreed()});
                }

                public void onFailure(Throwable e) {
                    AbstractAsyncBulkByScrollAction.this.logger.warn("Failed to clear scroll [" + scrollId + ']', e, new Object[0]);
                }
            });
        }
        if (failure == null) {
            this.listener.onResponse(this.buildResponse(TimeValue.timeValueNanos((long)(System.nanoTime() - this.startTime.get())), indexingFailures, searchFailures, timedOut));
        } else {
            this.listener.onFailure(failure);
        }
    }

    BackoffPolicy backoffPolicy() {
        return BackoffPolicy.exponentialBackoff((TimeValue)((AbstractBulkByScrollRequest)((Object)this.mainRequest)).getRetryBackoffInitialTime(), (int)((AbstractBulkByScrollRequest)((Object)this.mainRequest)).getMaxRetries());
    }

    void addDestinationIndices(Collection<String> indices) {
        this.destinationIndices.addAll(indices);
    }

    private BackoffPolicy wrapBackoffPolicy(final BackoffPolicy backoffPolicy) {
        return new BackoffPolicy(){

            public Iterator<TimeValue> iterator() {
                return new Iterator<TimeValue>(){
                    private final Iterator<TimeValue> delegate;
                    {
                        this.delegate = backoffPolicy.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegate.hasNext();
                    }

                    @Override
                    public TimeValue next() {
                        if (!this.delegate.hasNext()) {
                            return null;
                        }
                        AbstractAsyncBulkByScrollAction.this.task.countRetry();
                        return this.delegate.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

