/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.BinaryCodec;
import com.spatial4j.core.io.LegacyShapeWriter;
import com.spatial4j.core.io.SupportedFormats;
import com.spatial4j.core.io.WKTReader;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.impl.BufferedLineString;
import com.spatial4j.core.shape.impl.CircleImpl;
import com.spatial4j.core.shape.impl.GeoCircle;
import com.spatial4j.core.shape.impl.PointImpl;
import com.spatial4j.core.shape.impl.RectangleImpl;
import java.text.ParseException;
import java.util.List;

public class SpatialContext {
    public static final SpatialContext GEO = new SpatialContext(new SpatialContextFactory());
    private final boolean geo;
    private final DistanceCalculator calculator;
    private final Rectangle worldBounds;
    private final BinaryCodec binaryCodec;
    private final SupportedFormats formats;
    private final boolean normWrapLongitude;

    @Deprecated
    public SpatialContext(boolean geo, DistanceCalculator calculator, Rectangle worldBounds) {
        this(SpatialContext.initFromLegacyConstructor(geo, calculator, worldBounds));
    }

    private static SpatialContextFactory initFromLegacyConstructor(boolean geo, DistanceCalculator calculator, Rectangle worldBounds) {
        SpatialContextFactory factory = new SpatialContextFactory();
        factory.geo = geo;
        factory.distCalc = calculator;
        factory.worldBounds = worldBounds;
        return factory;
    }

    @Deprecated
    public SpatialContext(boolean geo) {
        this(SpatialContext.initFromLegacyConstructor(geo, null, null));
    }

    public SpatialContext(SpatialContextFactory factory) {
        this.geo = factory.geo;
        this.calculator = factory.distCalc == null ? (this.isGeo() ? new GeodesicSphereDistCalc.Haversine() : new CartesianDistCalc()) : factory.distCalc;
        Rectangle bounds = factory.worldBounds;
        if (bounds == null) {
            this.worldBounds = this.isGeo() ? new RectangleImpl(-180.0, 180.0, -90.0, 90.0, this) : new RectangleImpl(-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, this);
        } else {
            if (this.isGeo() && !bounds.equals(new RectangleImpl(-180.0, 180.0, -90.0, 90.0, this))) {
                throw new IllegalArgumentException("for geo (lat/lon), bounds must be " + GEO.getWorldBounds());
            }
            if (bounds.getMinX() > bounds.getMaxX()) {
                throw new IllegalArgumentException("worldBounds minX should be <= maxX: " + bounds);
            }
            if (bounds.getMinY() > bounds.getMaxY()) {
                throw new IllegalArgumentException("worldBounds minY should be <= maxY: " + bounds);
            }
            this.worldBounds = new RectangleImpl(bounds, this);
        }
        this.normWrapLongitude = factory.normWrapLongitude && this.isGeo();
        this.binaryCodec = factory.makeBinaryCodec(this);
        factory.checkDefaultFormats();
        this.formats = factory.makeFormats(this);
    }

    public SupportedFormats getFormats() {
        return this.formats;
    }

    public DistanceCalculator getDistCalc() {
        return this.calculator;
    }

    public double calcDistance(Point p, double x2, double y2) {
        return this.getDistCalc().distance(p, x2, y2);
    }

    public double calcDistance(Point p, Point p2) {
        return this.getDistCalc().distance(p, p2);
    }

    public Rectangle getWorldBounds() {
        return this.worldBounds;
    }

    public boolean isNormWrapLongitude() {
        return this.normWrapLongitude;
    }

    public boolean isGeo() {
        return this.geo;
    }

    public double normX(double x) {
        if (this.normWrapLongitude) {
            x = DistanceUtils.normLonDEG(x);
        }
        return x;
    }

    public double normY(double y) {
        return y;
    }

    public void verifyX(double x) {
        Rectangle bounds = this.getWorldBounds();
        if (x < bounds.getMinX() || x > bounds.getMaxX()) {
            throw new InvalidShapeException("Bad X value " + x + " is not in boundary " + bounds);
        }
    }

    public void verifyY(double y) {
        Rectangle bounds = this.getWorldBounds();
        if (y < bounds.getMinY() || y > bounds.getMaxY()) {
            throw new InvalidShapeException("Bad Y value " + y + " is not in boundary " + bounds);
        }
    }

    public Point makePoint(double x, double y) {
        this.verifyX(x);
        this.verifyY(y);
        return new PointImpl(x, y, this);
    }

    public Rectangle makeRectangle(Point lowerLeft, Point upperRight) {
        return this.makeRectangle(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY());
    }

    public Rectangle makeRectangle(double minX, double maxX, double minY, double maxY) {
        Rectangle bounds = this.getWorldBounds();
        if (minY < bounds.getMinY() || maxY > bounds.getMaxY()) {
            throw new InvalidShapeException("Y values [" + minY + " to " + maxY + "] not in boundary " + bounds);
        }
        if (minY > maxY) {
            throw new InvalidShapeException("maxY must be >= minY: " + minY + " to " + maxY);
        }
        if (this.isGeo()) {
            this.verifyX(minX);
            this.verifyX(maxX);
            if (minX == 180.0 && minX != maxX) {
                minX = -180.0;
            } else if (maxX == -180.0 && minX != maxX) {
                maxX = 180.0;
            }
        } else {
            if (minX < bounds.getMinX() || maxX > bounds.getMaxX()) {
                throw new InvalidShapeException("X values [" + minX + " to " + maxX + "] not in boundary " + bounds);
            }
            if (minX > maxX) {
                throw new InvalidShapeException("maxX must be >= minX: " + minX + " to " + maxX);
            }
        }
        return new RectangleImpl(minX, maxX, minY, maxY, this);
    }

    public Circle makeCircle(double x, double y, double distance) {
        return this.makeCircle(this.makePoint(x, y), distance);
    }

    public Circle makeCircle(Point point, double distance) {
        if (distance < 0.0) {
            throw new InvalidShapeException("distance must be >= 0; got " + distance);
        }
        if (this.isGeo()) {
            if (distance > 180.0) {
                distance = 180.0;
            }
            return new GeoCircle(point, distance, this);
        }
        return new CircleImpl(point, distance, this);
    }

    public Shape makeLineString(List<Point> points) {
        return new BufferedLineString(points, 0.0, false, this);
    }

    public Shape makeBufferedLineString(List<Point> points, double buf) {
        return new BufferedLineString(points, buf, this.isGeo(), this);
    }

    public <S extends Shape> ShapeCollection<S> makeCollection(List<S> coll) {
        return new ShapeCollection<S>(coll, this);
    }

    @Deprecated
    public WKTReader getWktShapeParser() {
        return (WKTReader)this.formats.getWktReader();
    }

    @Deprecated
    public Shape readShapeFromWkt(String wkt) throws ParseException, InvalidShapeException {
        return this.getWktShapeParser().parse(wkt);
    }

    public BinaryCodec getBinaryCodec() {
        return this.binaryCodec;
    }

    @Deprecated
    public Shape readShape(String value) throws InvalidShapeException {
        return this.formats.read(value);
    }

    @Deprecated
    public String toString(Shape shape) {
        return LegacyShapeWriter.writeShape(shape);
    }

    public String toString() {
        if (this.equals(GEO)) {
            return GEO.getClass().getSimpleName() + ".GEO";
        }
        return this.getClass().getSimpleName() + "{" + "geo=" + this.geo + ", calculator=" + this.calculator + ", worldBounds=" + this.worldBounds + '}';
    }
}

