/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class QueryExplanation
implements Streamable {
    private String index;
    private boolean valid;
    private String explanation;
    private String error;

    QueryExplanation() {
    }

    public QueryExplanation(String index, boolean valid, String explanation, String error) {
        this.index = index;
        this.valid = valid;
        this.explanation = explanation;
        this.error = error;
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getError() {
        return this.error;
    }

    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.valid = in.readBoolean();
        this.explanation = in.readOptionalString();
        this.error = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeBoolean(this.valid);
        out.writeOptionalString(this.explanation);
        out.writeOptionalString(this.error);
    }

    public static QueryExplanation readQueryExplanation(StreamInput in) throws IOException {
        QueryExplanation exp = new QueryExplanation();
        exp.readFrom(in);
        return exp;
    }
}

