/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractAsyncAction;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.ScrollIdForNode;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;

class SearchScrollQueryThenFetchAsyncAction
extends AbstractAsyncAction {
    private final ESLogger logger;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;
    private final SearchScrollRequest request;
    private final ActionListener<SearchResponse> listener;
    private final ParsedScrollId scrollId;
    private final DiscoveryNodes nodes;
    private volatile AtomicArray<ShardSearchFailure> shardFailures;
    final AtomicArray<QuerySearchResult> queryResults;
    final AtomicArray<FetchSearchResult> fetchResults;
    private volatile ScoreDoc[] sortedShardList;
    private final AtomicInteger successfulOps;

    SearchScrollQueryThenFetchAsyncAction(ESLogger logger, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController, SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        this.logger = logger;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
        this.request = request;
        this.listener = listener;
        this.scrollId = scrollId;
        this.nodes = clusterService.state().nodes();
        this.successfulOps = new AtomicInteger(scrollId.getContext().length);
        this.queryResults = new AtomicArray(scrollId.getContext().length);
        this.fetchResults = new AtomicArray(scrollId.getContext().length);
    }

    protected final ShardSearchFailure[] buildShardFailures() {
        if (this.shardFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        List<AtomicArray.Entry<ShardSearchFailure>> entries = this.shardFailures.asList();
        ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
        for (int i = 0; i < failures.length; ++i) {
            failures[i] = (ShardSearchFailure)entries.get((int)i).value;
        }
        return failures;
    }

    protected final void addShardFailure(int shardIndex, ShardSearchFailure failure) {
        if (this.shardFailures == null) {
            this.shardFailures = new AtomicArray(this.scrollId.getContext().length);
        }
        this.shardFailures.set(shardIndex, failure);
    }

    @Override
    public void start() {
        if (this.scrollId.getContext().length == 0) {
            this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", ShardSearchFailure.EMPTY_ARRAY));
            return;
        }
        AtomicInteger counter = new AtomicInteger(this.scrollId.getContext().length);
        ScrollIdForNode[] context = this.scrollId.getContext();
        for (int i = 0; i < context.length; ++i) {
            ScrollIdForNode target = context[i];
            DiscoveryNode node = this.nodes.get(target.getNode());
            if (node != null) {
                this.executeQueryPhase(i, counter, node, target.getScrollId());
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Node [" + target.getNode() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
            }
            this.successfulOps.decrementAndGet();
            if (counter.decrementAndGet() != 0) continue;
            try {
                this.executeFetchPhase();
                continue;
            }
            catch (Throwable e) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "Fetch failed", e, ShardSearchFailure.EMPTY_ARRAY));
                return;
            }
        }
    }

    private void executeQueryPhase(final int shardIndex, final AtomicInteger counter, DiscoveryNode node, final long searchId) {
        InternalScrollSearchRequest internalRequest = TransportSearchHelper.internalScrollSearchRequest(searchId, this.request);
        this.searchService.sendExecuteQuery(node, internalRequest, new ActionListener<ScrollQuerySearchResult>(){

            @Override
            public void onResponse(ScrollQuerySearchResult result) {
                SearchScrollQueryThenFetchAsyncAction.this.queryResults.set(shardIndex, result.queryResult());
                if (counter.decrementAndGet() == 0) {
                    try {
                        SearchScrollQueryThenFetchAsyncAction.this.executeFetchPhase();
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }
            }

            @Override
            public void onFailure(Throwable t) {
                SearchScrollQueryThenFetchAsyncAction.this.onQueryPhaseFailure(shardIndex, counter, searchId, t);
            }
        });
    }

    void onQueryPhaseFailure(int shardIndex, AtomicInteger counter, long searchId, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Failed to execute query phase", t, searchId);
        }
        this.addShardFailure(shardIndex, new ShardSearchFailure(t));
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            if (this.successfulOps.get() == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "all shards failed", t, this.buildShardFailures()));
            } else {
                try {
                    this.executeFetchPhase();
                }
                catch (Throwable e) {
                    this.listener.onFailure(new SearchPhaseExecutionException("query", "Fetch failed", e, ShardSearchFailure.EMPTY_ARRAY));
                }
            }
        }
    }

    private void executeFetchPhase() throws Exception {
        this.sortedShardList = this.searchPhaseController.sortDocs(true, this.queryResults);
        AtomicArray<IntArrayList> docIdsToLoad = new AtomicArray<IntArrayList>(this.queryResults.length());
        this.searchPhaseController.fillDocIdsToLoad(docIdsToLoad, this.sortedShardList);
        if (docIdsToLoad.asList().isEmpty()) {
            this.finishHim();
            return;
        }
        ScoreDoc[] lastEmittedDocPerShard = this.searchPhaseController.getLastEmittedDocPerShard(this.sortedShardList, this.queryResults.length());
        final AtomicInteger counter = new AtomicInteger(docIdsToLoad.asList().size());
        for (final AtomicArray.Entry<IntArrayList> entry : docIdsToLoad.asList()) {
            IntArrayList docIds = (IntArrayList)entry.value;
            final QuerySearchResult querySearchResult = this.queryResults.get(entry.index);
            ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[entry.index];
            ShardFetchRequest shardFetchRequest = new ShardFetchRequest(this.request, querySearchResult.id(), docIds, lastEmittedDoc);
            DiscoveryNode node = this.nodes.get(querySearchResult.shardTarget().nodeId());
            this.searchService.sendExecuteFetchScroll(node, shardFetchRequest, new ActionListener<FetchSearchResult>(){

                @Override
                public void onResponse(FetchSearchResult result) {
                    result.shardTarget(querySearchResult.shardTarget());
                    SearchScrollQueryThenFetchAsyncAction.this.fetchResults.set(entry.index, result);
                    if (counter.decrementAndGet() == 0) {
                        SearchScrollQueryThenFetchAsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (SearchScrollQueryThenFetchAsyncAction.this.logger.isDebugEnabled()) {
                        SearchScrollQueryThenFetchAsyncAction.this.logger.debug("Failed to execute fetch phase", t, new Object[0]);
                    }
                    SearchScrollQueryThenFetchAsyncAction.this.successfulOps.decrementAndGet();
                    if (counter.decrementAndGet() == 0) {
                        SearchScrollQueryThenFetchAsyncAction.this.finishHim();
                    }
                }
            });
        }
    }

    private void finishHim() {
        try {
            this.innerFinishHim();
        }
        catch (Throwable e) {
            this.listener.onFailure(new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures()));
        }
    }

    private void innerFinishHim() {
        InternalSearchResponse internalResponse = this.searchPhaseController.merge(this.sortedShardList, this.queryResults, this.fetchResults, this.request);
        String scrollId = null;
        if (this.request.scroll() != null) {
            scrollId = this.request.scrollId();
        }
        this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
    }
}

