/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchCountAsyncAction;
import org.elasticsearch.action.search.SearchDfsQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchDfsQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScanAsyncAction;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;
    private final ClusterService clusterService;
    private final boolean optimizeSingleShard;

    @Inject
    public TransportSearchAction(Settings settings, ThreadPool threadPool, SearchPhaseController searchPhaseController, TransportService transportService, SearchServiceTransportAction searchService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/search", threadPool, transportService, actionFilters, indexNameExpressionResolver, SearchRequest.class);
        this.searchPhaseController = searchPhaseController;
        this.searchService = searchService;
        this.clusterService = clusterService;
        this.optimizeSingleShard = this.settings.getAsBoolean("action.search.optimize_single_shard", (Boolean)true);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        AbstractSearchAsyncAction searchAsyncAction;
        if (this.optimizeSingleShard && searchRequest.searchType() != SearchType.SCAN && searchRequest.searchType() != SearchType.COUNT) {
            try {
                ClusterState clusterState = this.clusterService.state();
                String[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest);
                Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, searchRequest.routing(), searchRequest.indices());
                int shardCount = this.clusterService.operationRouting().searchShardsCount(clusterState, concreteIndices, routingMap);
                if (shardCount == 1) {
                    searchRequest.searchType(SearchType.QUERY_AND_FETCH);
                }
            }
            catch (IndexNotFoundException | IndexClosedException clusterState) {
            }
            catch (Exception e) {
                this.logger.debug("failed to optimize search type, continue as normal", e, new Object[0]);
            }
        }
        switch (searchRequest.searchType()) {
            case DFS_QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchDfsQueryThenFetchAsyncAction(this.logger, this.searchService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchQueryThenFetchAsyncAction(this.logger, this.searchService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case DFS_QUERY_AND_FETCH: {
                searchAsyncAction = new SearchDfsQueryAndFetchAsyncAction(this.logger, this.searchService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case QUERY_AND_FETCH: {
                searchAsyncAction = new SearchQueryAndFetchAsyncAction(this.logger, this.searchService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case SCAN: {
                searchAsyncAction = new SearchScanAsyncAction(this.logger, this.searchService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            case COUNT: {
                searchAsyncAction = new SearchCountAsyncAction(this.logger, this.searchService, this.clusterService, this.indexNameExpressionResolver, this.searchPhaseController, this.threadPool, searchRequest, listener);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown search type: [" + (Object)((Object)searchRequest.searchType()) + "]");
            }
        }
        searchAsyncAction.start();
    }
}

