/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionWriteResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChildTaskActionRequest;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastReplicationAction<Request extends BroadcastRequest, Response extends BroadcastResponse, ShardRequest extends ReplicationRequest, ShardResponse extends ActionWriteResponse>
extends HandledTransportAction<Request, Response> {
    private final TransportReplicationAction replicatedBroadcastShardAction;
    private final ClusterService clusterService;

    public TransportBroadcastReplicationAction(String name, Class<Request> request, Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportReplicationAction replicatedBroadcastShardAction) {
        super(settings, name, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.replicatedBroadcastShardAction = replicatedBroadcastShardAction;
        this.clusterService = clusterService;
    }

    @Override
    protected final void doExecute(Request request, ActionListener<Response> listener) {
        throw new UnsupportedOperationException("the task parameter is required for this operation");
    }

    @Override
    protected void doExecute(Task task, Request request, final ActionListener<Response> listener) {
        final ClusterState clusterState = this.clusterService.state();
        List<ShardId> shards = this.shards(request, clusterState);
        final CopyOnWriteArrayList shardsResponses = new CopyOnWriteArrayList();
        if (shards.size() == 0) {
            this.finishAndNotifyListener(listener, shardsResponses);
        }
        final CountDown responsesCountDown = new CountDown(shards.size());
        for (final ShardId shardId : shards) {
            ActionListener shardActionListener = new ActionListener<ShardResponse>(){

                @Override
                public void onResponse(ShardResponse shardResponse) {
                    shardsResponses.add(shardResponse);
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got response from {}", TransportBroadcastReplicationAction.this.actionName, shardId);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    Object[] failures;
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got failure from {}", TransportBroadcastReplicationAction.this.actionName, shardId);
                    int totalNumCopies = clusterState.getMetaData().index(shardId.index().getName()).getNumberOfReplicas() + 1;
                    Object shardResponse = TransportBroadcastReplicationAction.this.newShardResponse();
                    if (TransportActions.isShardNotAvailableException(e)) {
                        failures = new ActionWriteResponse.ShardInfo.Failure[]{};
                    } else {
                        ActionWriteResponse.ShardInfo.Failure failure = new ActionWriteResponse.ShardInfo.Failure(shardId.index().name(), shardId.id(), null, e, ExceptionsHelper.status(e), true);
                        failures = new ActionWriteResponse.ShardInfo.Failure[totalNumCopies];
                        Arrays.fill(failures, failure);
                    }
                    ((ActionWriteResponse)shardResponse).setShardInfo(new ActionWriteResponse.ShardInfo(totalNumCopies, 0, (ActionWriteResponse.ShardInfo.Failure[])failures));
                    shardsResponses.add(shardResponse);
                    if (responsesCountDown.countDown()) {
                        TransportBroadcastReplicationAction.this.finishAndNotifyListener(listener, shardsResponses);
                    }
                }
            };
            this.shardExecute(task, request, shardId, shardActionListener);
        }
    }

    protected void shardExecute(Task task, Request request, ShardId shardId, ActionListener<ShardResponse> shardActionListener) {
        ShardRequest shardRequest = this.newShardRequest(request, shardId);
        ((ChildTaskActionRequest)shardRequest).setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.taskManager.registerChildTask(task, this.clusterService.localNode().getId());
        this.replicatedBroadcastShardAction.execute(shardRequest, shardActionListener);
    }

    protected List<ShardId> shards(Request request, ClusterState clusterState) {
        String[] concreteIndices;
        ArrayList<ShardId> shardIds = new ArrayList<ShardId>();
        for (String index : concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, (IndicesRequest)request)) {
            IndexMetaData indexMetaData = clusterState.metaData().getIndices().get(index);
            if (indexMetaData == null) continue;
            for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : clusterState.getRoutingTable().indicesRouting().get(index).getShards()) {
                shardIds.add(((IndexShardRoutingTable)intObjectCursor.value).shardId());
            }
        }
        return shardIds;
    }

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardRequest newShardRequest(Request var1, ShardId var2);

    private void finishAndNotifyListener(ActionListener listener, CopyOnWriteArrayList<ShardResponse> shardsResponses) {
        this.logger.trace("{}: got all shard responses", this.actionName);
        int successfulShards = 0;
        int failedShards = 0;
        int totalNumCopies = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.size(); ++i) {
            ActionWriteResponse shardResponse = (ActionWriteResponse)shardsResponses.get(i);
            if (shardResponse == null) continue;
            failedShards += shardResponse.getShardInfo().getFailed();
            successfulShards += shardResponse.getShardInfo().getSuccessful();
            totalNumCopies += shardResponse.getShardInfo().getTotal();
            if (shardFailures == null) {
                shardFailures = new ArrayList<DefaultShardOperationFailedException>();
            }
            for (ActionWriteResponse.ShardInfo.Failure failure : shardResponse.getShardInfo().getFailures()) {
                shardFailures.add(new DefaultShardOperationFailedException(new BroadcastShardOperationFailedException(new ShardId(failure.index(), failure.shardId()), failure.getCause())));
            }
        }
        listener.onResponse(this.newResponse(successfulShards, failedShards, totalNumCopies, shardFailures));
    }

    protected abstract BroadcastResponse newResponse(int var1, int var2, int var3, List<ShardOperationFailedException> var4);
}

