/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Map;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class FilterAllocationDecider
extends AllocationDecider {
    public static final String NAME = "filter";
    public static final String INDEX_ROUTING_REQUIRE_GROUP = "index.routing.allocation.require.";
    public static final String INDEX_ROUTING_INCLUDE_GROUP = "index.routing.allocation.include.";
    public static final String INDEX_ROUTING_EXCLUDE_GROUP = "index.routing.allocation.exclude.";
    public static final String CLUSTER_ROUTING_REQUIRE_GROUP = "cluster.routing.allocation.require.";
    public static final String CLUSTER_ROUTING_INCLUDE_GROUP = "cluster.routing.allocation.include.";
    public static final String CLUSTER_ROUTING_EXCLUDE_GROUP = "cluster.routing.allocation.exclude.";
    private volatile DiscoveryNodeFilters clusterRequireFilters;
    private volatile DiscoveryNodeFilters clusterIncludeFilters;
    private volatile DiscoveryNodeFilters clusterExcludeFilters;

    @Inject
    public FilterAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        Map<String, String> requireMap = settings.getByPrefix(CLUSTER_ROUTING_REQUIRE_GROUP).getAsMap();
        this.clusterRequireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
        Map<String, String> includeMap = settings.getByPrefix(CLUSTER_ROUTING_INCLUDE_GROUP).getAsMap();
        this.clusterIncludeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
        Map<String, String> excludeMap = settings.getByPrefix(CLUSTER_ROUTING_EXCLUDE_GROUP).getAsMap();
        this.clusterExcludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node, allocation);
    }

    @Override
    public Decision canAllocate(IndexMetaData indexMetaData, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetaData, node, allocation);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node, allocation);
    }

    private Decision shouldFilter(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(allocation.routingNodes().metaData().index(shardRouting.index()), node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldFilter(IndexMetaData indexMd, RoutingNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMd, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldIndexFilter(IndexMetaData indexMd, RoutingNode node, RoutingAllocation allocation) {
        if (indexMd.requireFilters() != null && !indexMd.requireFilters().match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not match index required filters [%s]", indexMd.requireFilters());
        }
        if (indexMd.includeFilters() != null && !indexMd.includeFilters().match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not match index include filters [%s]", indexMd.includeFilters());
        }
        if (indexMd.excludeFilters() != null && indexMd.excludeFilters().match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node matches index exclude filters [%s]", indexMd.excludeFilters());
        }
        return null;
    }

    private Decision shouldClusterFilter(RoutingNode node, RoutingAllocation allocation) {
        if (this.clusterRequireFilters != null && !this.clusterRequireFilters.match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not match global required filters [%s]", this.clusterRequireFilters);
        }
        if (this.clusterIncludeFilters != null && !this.clusterIncludeFilters.match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node does not match global include filters [%s]", this.clusterIncludeFilters);
        }
        if (this.clusterExcludeFilters != null && this.clusterExcludeFilters.match(node.node())) {
            return allocation.decision(Decision.NO, NAME, "node matches global exclude filters [%s]", this.clusterExcludeFilters);
        }
        return null;
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            Map<String, String> excludeMap;
            Map<String, String> includeMap;
            Map<String, String> requireMap = settings.getByPrefix(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP).getAsMap();
            if (!requireMap.isEmpty()) {
                FilterAllocationDecider.this.clusterRequireFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
            }
            if (!(includeMap = settings.getByPrefix(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP).getAsMap()).isEmpty()) {
                FilterAllocationDecider.this.clusterIncludeFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
            }
            if (!(excludeMap = settings.getByPrefix(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP).getAsMap()).isEmpty()) {
                FilterAllocationDecider.this.clusterExcludeFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
            }
        }
    }
}

