/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.lucene.index.ElasticsearchLeafReader;
import org.elasticsearch.index.shard.ShardId;

public final class ElasticsearchDirectoryReader
extends FilterDirectoryReader {
    private final ShardId shardId;
    private final FilterDirectoryReader.SubReaderWrapper wrapper;

    private ElasticsearchDirectoryReader(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper wrapper, ShardId shardId) throws IOException {
        super(in, wrapper);
        this.wrapper = wrapper;
        this.shardId = shardId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new ElasticsearchDirectoryReader(in, this.wrapper, this.shardId);
    }

    public static ElasticsearchDirectoryReader wrap(DirectoryReader reader, ShardId shardId) throws IOException {
        return new ElasticsearchDirectoryReader(reader, new SubReaderWrapper(shardId), shardId);
    }

    @SuppressForbidden(reason="This is the only sane way to add a ReaderClosedListener")
    public static void addReaderCloseListener(DirectoryReader reader, IndexReader.ReaderClosedListener listener) {
        ElasticsearchDirectoryReader elasticsearchDirectoryReader = ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(reader);
        if (elasticsearchDirectoryReader != null) {
            assert (reader.getCoreCacheKey() == elasticsearchDirectoryReader.getCoreCacheKey());
            elasticsearchDirectoryReader.addReaderClosedListener(listener);
            return;
        }
        throw new IllegalArgumentException("Can't install close listener reader is not an ElasticsearchDirectoryReader/ElasticsearchLeafReader");
    }

    public static ElasticsearchDirectoryReader getElasticsearchDirectoryReader(DirectoryReader reader) {
        if (reader instanceof FilterDirectoryReader) {
            if (reader instanceof ElasticsearchDirectoryReader) {
                return (ElasticsearchDirectoryReader)reader;
            }
            return ElasticsearchDirectoryReader.getElasticsearchDirectoryReader(((FilterDirectoryReader)reader).getDelegate());
        }
        return null;
    }

    private static final class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final ShardId shardId;

        SubReaderWrapper(ShardId shardId) {
            this.shardId = shardId;
        }

        public LeafReader wrap(LeafReader reader) {
            return new ElasticsearchLeafReader(reader, this.shardId);
        }
    }
}

