/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public final class CJKBigramFilterFactory
extends AbstractTokenFilterFactory {
    private final int flags;
    private final boolean outputUnigrams;

    @Inject
    public CJKBigramFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.outputUnigrams = settings.getAsBoolean("output_unigrams", (Boolean)false);
        String[] asArray = settings.getAsArray("ignored_scripts");
        HashSet<String> scripts = new HashSet<String>(Arrays.asList("han", "hiragana", "katakana", "hangul"));
        if (asArray != null) {
            scripts.removeAll(Arrays.asList(asArray));
        }
        int flags = 0;
        for (String script : scripts) {
            if ("han".equals(script)) {
                flags |= 1;
                continue;
            }
            if ("hiragana".equals(script)) {
                flags |= 2;
                continue;
            }
            if ("katakana".equals(script)) {
                flags |= 4;
                continue;
            }
            if (!"hangul".equals(script)) continue;
            flags |= 8;
        }
        this.flags = flags;
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new CJKBigramFilter(tokenStream, this.flags, this.outputUnigrams);
    }
}

