/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactoryFactory;
import org.elasticsearch.indices.analysis.PreBuiltTokenFilters;

public class PreBuiltTokenFilterFactoryFactory
implements TokenFilterFactoryFactory {
    private final TokenFilterFactory tokenFilterFactory;

    public PreBuiltTokenFilterFactoryFactory(TokenFilterFactory tokenFilterFactory) {
        this.tokenFilterFactory = tokenFilterFactory;
    }

    @Override
    public TokenFilterFactory create(String name, Settings settings) {
        PreBuiltTokenFilters preBuiltTokenFilters;
        Version indexVersion = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(indexVersion) && (preBuiltTokenFilters = PreBuiltTokenFilters.getOrDefault(name, null)) != null) {
            return preBuiltTokenFilters.getTokenFilterFactory(indexVersion);
        }
        return this.tokenFilterFactory;
    }
}

