/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.StandardHtmlStripAnalyzer;
import org.elasticsearch.index.settings.IndexSettingsService;

public class StandardHtmlStripAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StandardHtmlStripAnalyzer> {
    private final StandardHtmlStripAnalyzer analyzer;
    private final Version esVersion;

    @Inject
    public StandardHtmlStripAnalyzerProvider(Index index, IndexSettingsService indexSettingsService, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.esVersion = Version.indexCreated(indexSettingsService.getSettings());
        CharArraySet defaultStopwords = this.esVersion.onOrAfter(Version.V_1_0_0_RC1) ? CharArraySet.EMPTY_SET : StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords);
        this.analyzer = new StandardHtmlStripAnalyzer(stopWords);
        this.analyzer.setVersion(this.version);
    }

    @Override
    public StandardHtmlStripAnalyzer get() {
        return this.analyzer;
    }
}

