/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.support.QueryInnerHitBuilder;

public class HasParentQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<HasParentQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private final String parentType;
    private String scoreMode;
    private float boost = 1.0f;
    private String queryName;
    private QueryInnerHitBuilder innerHit = null;

    public HasParentQueryBuilder(String parentType, QueryBuilder parentQuery) {
        this.parentType = parentType;
        this.queryBuilder = parentQuery;
    }

    @Override
    public HasParentQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public HasParentQueryBuilder scoreMode(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    @Deprecated
    public HasParentQueryBuilder scoreType(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    public HasParentQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public HasParentQueryBuilder innerHit(QueryInnerHitBuilder innerHit) {
        this.innerHit = innerHit;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("has_parent");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("parent_type", this.parentType);
        if (this.scoreMode != null) {
            builder.field("score_mode", this.scoreMode);
        }
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.innerHit != null) {
            builder.startObject("inner_hits");
            builder.value(this.innerHit);
            builder.endObject();
        }
        builder.endObject();
    }
}

