/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BlendedTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQuery
extends MatchQuery {
    private Float groupTieBreaker = null;
    private QueryBuilder queryBuilder;

    public void setTieBreaker(float tieBreaker) {
        this.groupTieBreaker = Float.valueOf(tieBreaker);
    }

    public MultiMatchQuery(QueryParseContext parseContext) {
        super(parseContext);
    }

    private Query parseAndApply(MatchQuery.Type type, String fieldName, Object value, String minimumShouldMatch, Float boostValue) throws IOException {
        Query query = this.parse(type, fieldName, value);
        if (query instanceof BooleanQuery && !((BooleanQuery)query).isCoordDisabled()) {
            query = Queries.applyMinimumShouldMatch((BooleanQuery)query, minimumShouldMatch);
        }
        if (boostValue != null && query != null) {
            query.setBoost(boostValue.floatValue());
        }
        return query;
    }

    public Query parse(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        if (fieldNames.size() == 1) {
            Map.Entry<String, Float> fieldBoost = fieldNames.entrySet().iterator().next();
            Float boostValue = fieldBoost.getValue();
            return this.parseAndApply(type.matchQueryType(), fieldBoost.getKey(), value, minimumShouldMatch, boostValue);
        }
        float tieBreaker = this.groupTieBreaker == null ? type.tieBreaker() : this.groupTieBreaker.floatValue();
        switch (type) {
            case PHRASE: 
            case PHRASE_PREFIX: 
            case BEST_FIELDS: 
            case MOST_FIELDS: {
                this.queryBuilder = new QueryBuilder(tieBreaker);
                break;
            }
            case CROSS_FIELDS: {
                this.queryBuilder = new CrossFieldsQueryBuilder(tieBreaker);
                break;
            }
            default: {
                throw new IllegalStateException("No such type: " + (Object)((Object)type));
            }
        }
        List<Query> queries = this.queryBuilder.buildGroupedQueries(type, fieldNames, value, minimumShouldMatch);
        return this.queryBuilder.combineGrouped(queries);
    }

    @Override
    protected Query blendTermQuery(Term term, MappedFieldType fieldType) {
        if (this.queryBuilder == null) {
            return super.blendTermQuery(term, fieldType);
        }
        return this.queryBuilder.blendTerm(term, fieldType);
    }

    @Override
    protected Query termQuery(MappedFieldType fieldType, Object value) {
        if (this.queryBuilder == null) {
            return super.termQuery(fieldType, value);
        }
        return this.queryBuilder.termQuery(fieldType, value);
    }

    private static final class FieldAndFieldType {
        final String field;
        final MappedFieldType fieldType;
        final float boost;

        private FieldAndFieldType(String field, MappedFieldType fieldType, float boost) {
            this.field = field;
            this.fieldType = fieldType;
            this.boost = boost;
        }

        public Term newTerm(String value) {
            try {
                return new Term(this.fieldType.names().indexName(), this.fieldType.indexedValueForSearch(value));
            }
            catch (RuntimeException runtimeException) {
                return new Term(this.field, value);
            }
        }
    }

    public class CrossFieldsQueryBuilder
    extends QueryBuilder {
        private FieldAndFieldType[] blendedFields;

        public CrossFieldsQueryBuilder(float tieBreaker) {
            super(false, tieBreaker);
        }

        @Override
        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            HashMap groups = new HashMap();
            ArrayList<Tuple<String, Float>> missing = new ArrayList<Tuple<String, Float>>();
            for (Map.Entry<String, Float> entry : fieldNames.entrySet()) {
                String string = entry.getKey();
                MappedFieldType fieldType = MultiMatchQuery.this.parseContext.fieldMapper(string);
                if (fieldType != null) {
                    Float boost;
                    Analyzer actualAnalyzer = MultiMatchQuery.this.getAnalyzer(fieldType);
                    String string2 = fieldType.names().indexName();
                    if (!groups.containsKey(actualAnalyzer)) {
                        groups.put(actualAnalyzer, new ArrayList());
                    }
                    boost = (boost = entry.getValue()) == null ? Float.valueOf(1.0f) : boost;
                    ((List)groups.get(actualAnalyzer)).add(new FieldAndFieldType(string2, fieldType, boost.floatValue()));
                    continue;
                }
                missing.add(new Tuple<String, Float>(string, entry.getValue()));
            }
            ArrayList<Query> queries = new ArrayList<Query>();
            for (Tuple tuple : missing) {
                Query q = this.parseGroup(type.matchQueryType(), (String)tuple.v1(), (Float)tuple.v2(), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            for (List list : groups.values()) {
                if (list.size() > 1) {
                    this.blendedFields = new FieldAndFieldType[list.size()];
                    int i = 0;
                    for (FieldAndFieldType fieldAndFieldType : list) {
                        this.blendedFields[i++] = fieldAndFieldType;
                    }
                } else {
                    this.blendedFields = null;
                }
                String representativeField = ((FieldAndFieldType)list.get((int)0)).field;
                Query q = this.parseGroup(type.matchQueryType(), representativeField, Float.valueOf(1.0f), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            return queries.isEmpty() ? null : queries;
        }

        @Override
        public Query blendTerm(Term term, MappedFieldType fieldType) {
            if (this.blendedFields == null) {
                return super.blendTerm(term, fieldType);
            }
            Term[] terms = new Term[this.blendedFields.length];
            float[] blendedBoost = new float[this.blendedFields.length];
            for (int i = 0; i < this.blendedFields.length; ++i) {
                terms[i] = this.blendedFields[i].newTerm(term.text());
                blendedBoost[i] = this.blendedFields[i].boost;
            }
            if (MultiMatchQuery.this.commonTermsCutoff != null) {
                return BlendedTermQuery.commonTermsBlendedQuery(terms, blendedBoost, false, MultiMatchQuery.this.commonTermsCutoff.floatValue());
            }
            if (this.tieBreaker == 1.0f) {
                return BlendedTermQuery.booleanBlendedQuery(terms, blendedBoost, false);
            }
            return BlendedTermQuery.dismaxBlendedQuery(terms, blendedBoost, this.tieBreaker);
        }

        @Override
        public Query termQuery(MappedFieldType fieldType, Object value) {
            return this.blendTerm(new Term(fieldType.names().indexName(), value.toString()), fieldType);
        }
    }

    public class QueryBuilder {
        protected final boolean groupDismax;
        protected final float tieBreaker;

        public QueryBuilder(float tieBreaker) {
            this(tieBreaker != 1.0f, tieBreaker);
        }

        public QueryBuilder(boolean groupDismax, float tieBreaker) {
            this.groupDismax = groupDismax;
            this.tieBreaker = tieBreaker;
        }

        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (String fieldName : fieldNames.keySet()) {
                Float boostValue = fieldNames.get(fieldName);
                Query query = this.parseGroup(type.matchQueryType(), fieldName, boostValue, value, minimumShouldMatch);
                if (query == null) continue;
                queries.add(query);
            }
            return queries;
        }

        public Query parseGroup(MatchQuery.Type type, String field, Float boostValue, Object value, String minimumShouldMatch) throws IOException {
            return MultiMatchQuery.this.parseAndApply(type, field, value, minimumShouldMatch, boostValue);
        }

        public Query combineGrouped(List<? extends Query> groupQuery) {
            if (groupQuery == null || groupQuery.isEmpty()) {
                return null;
            }
            if (groupQuery.size() == 1) {
                return groupQuery.get(0);
            }
            if (this.groupDismax) {
                DisjunctionMaxQuery disMaxQuery = new DisjunctionMaxQuery(this.tieBreaker);
                for (Query query : groupQuery) {
                    disMaxQuery.add(query);
                }
                return disMaxQuery;
            }
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            for (Query query : groupQuery) {
                booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            return booleanQuery.build();
        }

        public Query blendTerm(Term term, MappedFieldType fieldType) {
            return MultiMatchQuery.super.blendTermQuery(term, fieldType);
        }

        public Query termQuery(MappedFieldType fieldType, Object value) {
            return MultiMatchQuery.this.termQuery(fieldType, value, MultiMatchQuery.this.lenient);
        }
    }
}

