/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.index.translog.Translog;

final class MultiSnapshot
implements Translog.Snapshot {
    private final Translog.Snapshot[] translogs;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final int estimatedTotalOperations;
    private int index;

    MultiSnapshot(Translog.Snapshot[] translogs) {
        this.translogs = translogs;
        int ops = 0;
        for (Translog.Snapshot translog : translogs) {
            int tops = translog.estimatedTotalOperations();
            if (tops == -1) {
                ops = -1;
                break;
            }
            assert (tops >= 0) : "tops must be positive but was: " + tops;
            ops += tops;
        }
        this.estimatedTotalOperations = ops;
        this.index = 0;
    }

    @Override
    public int estimatedTotalOperations() {
        return this.estimatedTotalOperations;
    }

    @Override
    public Translog.Operation next() throws IOException {
        this.ensureOpen();
        while (this.index < this.translogs.length) {
            Translog.Snapshot current = this.translogs[this.index];
            Translog.Operation op = current.next();
            if (op != null) {
                return op;
            }
            ++this.index;
        }
        return null;
    }

    protected void ensureOpen() {
        if (this.closed.get()) {
            throw new AlreadyClosedException("snapshot already closed");
        }
    }

    @Override
    public void close() throws ElasticsearchException {
        if (this.closed.compareAndSet(false, true)) {
            Releasables.close(this.translogs);
        }
    }
}

