/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.transport.TransportRequest;

public final class RecoveryFileChunkRequest
extends TransportRequest {
    private boolean lastChunk;
    private long recoveryId;
    private ShardId shardId;
    private long position;
    private BytesReference content;
    private StoreFileMetaData metaData;
    private long sourceThrottleTimeInNanos;
    private int totalTranslogOps;

    public RecoveryFileChunkRequest() {
    }

    public RecoveryFileChunkRequest(long recoveryId, ShardId shardId, StoreFileMetaData metaData, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, long sourceThrottleTimeInNanos) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.metaData = metaData;
        this.position = position;
        this.content = content;
        this.lastChunk = lastChunk;
        this.totalTranslogOps = totalTranslogOps;
        this.sourceThrottleTimeInNanos = sourceThrottleTimeInNanos;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String name() {
        return this.metaData.name();
    }

    public long position() {
        return this.position;
    }

    @Nullable
    public String checksum() {
        return this.metaData.checksum();
    }

    public long length() {
        return this.metaData.length();
    }

    public BytesReference content() {
        return this.content;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long sourceThrottleTimeInNanos() {
        return this.sourceThrottleTimeInNanos;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        String name = in.readString();
        this.position = in.readVLong();
        long length = in.readVLong();
        String checksum = in.readOptionalString();
        this.content = in.readBytesReference();
        Version writtenBy = null;
        String versionString = in.readOptionalString();
        writtenBy = Lucene.parseVersionLenient(versionString, null);
        this.metaData = new StoreFileMetaData(name, length, checksum, writtenBy);
        this.lastChunk = in.readBoolean();
        this.totalTranslogOps = in.readVInt();
        this.sourceThrottleTimeInNanos = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.metaData.name());
        out.writeVLong(this.position);
        out.writeVLong(this.metaData.length());
        out.writeOptionalString(this.metaData.checksum());
        out.writeBytesReference(this.content);
        out.writeOptionalString(this.metaData.writtenBy() == null ? null : this.metaData.writtenBy().toString());
        out.writeBoolean(this.lastChunk);
        out.writeVInt(this.totalTranslogOps);
        out.writeLong(this.sourceThrottleTimeInNanos);
    }

    public String toString() {
        return this.shardId + ": name='" + this.name() + '\'' + ", position=" + this.position + ", length=" + this.length();
    }

    public StoreFileMetaData metadata() {
        return this.metaData;
    }

    public boolean lastChunk() {
        return this.lastChunk;
    }
}

