/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.shard.ShardId;

public class RecoveryState
implements ToXContent,
Streamable {
    private Stage stage;
    private final Index index = new Index();
    private final Translog translog = new Translog();
    private final VerifyIndex verifyIndex = new VerifyIndex();
    private final Timer timer = new Timer();
    private Type type;
    private ShardId shardId;
    private RestoreSource restoreSource;
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;
    private boolean primary = false;

    private RecoveryState() {
    }

    public RecoveryState(ShardId shardId, boolean primary, Type type, DiscoveryNode sourceNode, DiscoveryNode targetNode) {
        this(shardId, primary, type, sourceNode, null, targetNode);
    }

    public RecoveryState(ShardId shardId, boolean primary, Type type, RestoreSource restoreSource, DiscoveryNode targetNode) {
        this(shardId, primary, type, null, restoreSource, targetNode);
    }

    private RecoveryState(ShardId shardId, boolean primary, Type type, @Nullable DiscoveryNode sourceNode, @Nullable RestoreSource restoreSource, DiscoveryNode targetNode) {
        this.shardId = shardId;
        this.primary = primary;
        this.type = type;
        this.sourceNode = sourceNode;
        this.restoreSource = restoreSource;
        this.targetNode = targetNode;
        this.stage = Stage.INIT;
        this.timer.start();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public synchronized Stage getStage() {
        return this.stage;
    }

    private void validateAndSetStage(Stage expected, Stage next) {
        if (this.stage != expected) {
            throw new IllegalStateException("can't move recovery to stage [" + (Object)((Object)next) + "]. current stage: [" + (Object)((Object)this.stage) + "] (expected [" + (Object)((Object)expected) + "])");
        }
        this.stage = next;
    }

    public synchronized RecoveryState setStage(Stage stage) {
        switch (stage) {
            case INIT: {
                this.stage = Stage.INIT;
                this.getIndex().reset();
                this.getVerifyIndex().reset();
                this.getTranslog().reset();
                break;
            }
            case INDEX: {
                this.validateAndSetStage(Stage.INIT, stage);
                this.getIndex().start();
                break;
            }
            case VERIFY_INDEX: {
                this.validateAndSetStage(Stage.INDEX, stage);
                this.getIndex().stop();
                this.getVerifyIndex().start();
                break;
            }
            case TRANSLOG: {
                this.validateAndSetStage(Stage.VERIFY_INDEX, stage);
                this.getVerifyIndex().stop();
                this.getTranslog().start();
                break;
            }
            case FINALIZE: {
                this.validateAndSetStage(Stage.TRANSLOG, stage);
                this.getTranslog().stop();
                break;
            }
            case DONE: {
                this.validateAndSetStage(Stage.FINALIZE, stage);
                this.getTimer().stop();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown RecoveryState.Stage [" + (Object)((Object)stage) + "]");
            }
        }
        return this;
    }

    public Index getIndex() {
        return this.index;
    }

    public VerifyIndex getVerifyIndex() {
        return this.verifyIndex;
    }

    public Translog getTranslog() {
        return this.translog;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Type getType() {
        return this.type;
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public RestoreSource getRestoreSource() {
        return this.restoreSource;
    }

    public boolean getPrimary() {
        return this.primary;
    }

    public static RecoveryState readRecoveryState(StreamInput in) throws IOException {
        RecoveryState recoveryState = new RecoveryState();
        recoveryState.readFrom(in);
        return recoveryState;
    }

    @Override
    public synchronized void readFrom(StreamInput in) throws IOException {
        this.timer.readFrom(in);
        this.type = Type.fromId(in.readByte());
        this.stage = Stage.fromId(in.readByte());
        this.shardId = ShardId.readShardId(in);
        this.restoreSource = RestoreSource.readOptionalRestoreSource(in);
        this.targetNode = DiscoveryNode.readNode(in);
        if (in.readBoolean()) {
            this.sourceNode = DiscoveryNode.readNode(in);
        }
        this.index.readFrom(in);
        this.translog.readFrom(in);
        this.verifyIndex.readFrom(in);
        this.primary = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.timer.writeTo(out);
        out.writeByte(this.type.id());
        out.writeByte(this.stage.id());
        this.shardId.writeTo(out);
        out.writeOptionalStreamable(this.restoreSource);
        this.targetNode.writeTo(out);
        out.writeBoolean(this.sourceNode != null);
        if (this.sourceNode != null) {
            this.sourceNode.writeTo(out);
        }
        this.index.writeTo(out);
        this.translog.writeTo(out);
        this.verifyIndex.writeTo(out);
        out.writeBoolean(this.primary);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.ID, this.shardId.id());
        builder.field(Fields.TYPE, this.type.toString());
        builder.field(Fields.STAGE, this.stage.toString());
        builder.field(Fields.PRIMARY, this.primary);
        builder.dateValueField(Fields.START_TIME_IN_MILLIS, Fields.START_TIME, this.timer.startTime);
        if (this.timer.stopTime > 0L) {
            builder.dateValueField(Fields.STOP_TIME_IN_MILLIS, Fields.STOP_TIME, this.timer.stopTime);
        }
        builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.timer.time());
        if (this.restoreSource != null) {
            builder.field(Fields.SOURCE);
            this.restoreSource.toXContent(builder, params);
        } else {
            builder.startObject(Fields.SOURCE);
            builder.field(Fields.ID, this.sourceNode.id());
            builder.field(Fields.HOST, this.sourceNode.getHostName());
            builder.field(Fields.TRANSPORT_ADDRESS, this.sourceNode.address().toString());
            builder.field(Fields.IP, this.sourceNode.getHostAddress());
            builder.field(Fields.NAME, this.sourceNode.name());
            builder.endObject();
        }
        builder.startObject(Fields.TARGET);
        builder.field(Fields.ID, this.targetNode.id());
        builder.field(Fields.HOST, this.targetNode.getHostName());
        builder.field(Fields.TRANSPORT_ADDRESS, this.targetNode.address().toString());
        builder.field(Fields.IP, this.targetNode.getHostAddress());
        builder.field(Fields.NAME, this.targetNode.name());
        builder.endObject();
        builder.startObject(Fields.INDEX);
        this.index.toXContent(builder, params);
        builder.endObject();
        builder.startObject(Fields.TRANSLOG);
        this.translog.toXContent(builder, params);
        builder.endObject();
        builder.startObject(Fields.VERIFY_INDEX);
        this.verifyIndex.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static class Index
    extends Timer
    implements ToXContent,
    Streamable {
        private Map<String, File> fileDetails = new HashMap<String, File>();
        public static final long UNKNOWN = -1L;
        private long version = -1L;
        private long sourceThrottlingInNanos = -1L;
        private long targetThrottleTimeInNanos = -1L;

        public synchronized List<File> fileDetails() {
            return Collections.unmodifiableList(new ArrayList<File>(this.fileDetails.values()));
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.version = -1L;
            this.fileDetails.clear();
            this.sourceThrottlingInNanos = -1L;
            this.targetThrottleTimeInNanos = -1L;
        }

        public synchronized void addFileDetail(String name, long length, boolean reused) {
            File file = new File(name, length, reused);
            File existing = this.fileDetails.put(name, file);
            assert (existing == null) : "file [" + name + "] is already reported";
        }

        public synchronized void addRecoveredBytesToFile(String name, long bytes) {
            File file = this.fileDetails.get(name);
            file.addRecoveredBytes(bytes);
        }

        public synchronized long version() {
            return this.version;
        }

        public synchronized void addSourceThrottling(long timeInNanos) {
            this.sourceThrottlingInNanos = this.sourceThrottlingInNanos == -1L ? timeInNanos : (this.sourceThrottlingInNanos += timeInNanos);
        }

        public synchronized void addTargetThrottling(long timeInNanos) {
            this.targetThrottleTimeInNanos = this.targetThrottleTimeInNanos == -1L ? timeInNanos : (this.targetThrottleTimeInNanos += timeInNanos);
        }

        public synchronized TimeValue sourceThrottling() {
            return TimeValue.timeValueNanos(this.sourceThrottlingInNanos);
        }

        public synchronized TimeValue targetThrottling() {
            return TimeValue.timeValueNanos(this.targetThrottleTimeInNanos);
        }

        public synchronized int totalFileCount() {
            return this.fileDetails.size();
        }

        public synchronized int totalRecoverFiles() {
            int total = 0;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                ++total;
            }
            return total;
        }

        public synchronized int recoveredFileCount() {
            int count = 0;
            for (File file : this.fileDetails.values()) {
                if (!file.fullyRecovered()) continue;
                ++count;
            }
            return count;
        }

        public synchronized float recoveredFilesPercent() {
            int total = 0;
            int recovered = 0;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                ++total;
                if (!file.fullyRecovered()) continue;
                ++recovered;
            }
            if (total == 0 && this.fileDetails.size() == 0) {
                return 0.0f;
            }
            if (total == recovered) {
                return 100.0f;
            }
            float result = 100.0f * ((float)recovered / (float)total);
            return result;
        }

        public synchronized long totalBytes() {
            long total = 0L;
            for (File file : this.fileDetails.values()) {
                total += file.length();
            }
            return total;
        }

        public synchronized long recoveredBytes() {
            long recovered = 0L;
            for (File file : this.fileDetails.values()) {
                recovered += file.recovered();
            }
            return recovered;
        }

        public synchronized long totalRecoverBytes() {
            long total = 0L;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                total += file.length();
            }
            return total;
        }

        public synchronized long totalReuseBytes() {
            long total = 0L;
            for (File file : this.fileDetails.values()) {
                if (!file.reused()) continue;
                total += file.length();
            }
            return total;
        }

        public synchronized float recoveredBytesPercent() {
            long total = 0L;
            long recovered = 0L;
            for (File file : this.fileDetails.values()) {
                if (file.reused()) continue;
                total += file.length();
                recovered += file.recovered();
            }
            if (total == 0L && this.fileDetails.size() == 0) {
                return 0.0f;
            }
            if (total == recovered) {
                return 100.0f;
            }
            return 100.0f * (float)recovered / (float)total;
        }

        public synchronized int reusedFileCount() {
            int reused = 0;
            for (File file : this.fileDetails.values()) {
                if (!file.reused()) continue;
                ++reused;
            }
            return reused;
        }

        public synchronized long reusedBytes() {
            long reused = 0L;
            for (File file : this.fileDetails.values()) {
                if (!file.reused()) continue;
                reused += file.length();
            }
            return reused;
        }

        public synchronized void updateVersion(long version) {
            this.version = version;
        }

        @Override
        public synchronized void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                File file = File.readFile(in);
                this.fileDetails.put(file.name, file);
            }
            this.sourceThrottlingInNanos = in.readLong();
            this.targetThrottleTimeInNanos = in.readLong();
        }

        @Override
        public synchronized void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            File[] files = this.fileDetails.values().toArray(new File[0]);
            out.writeVInt(files.length);
            for (File file : files) {
                file.writeTo(out);
            }
            out.writeLong(this.sourceThrottlingInNanos);
            out.writeLong(this.targetThrottleTimeInNanos);
        }

        @Override
        public synchronized XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(Fields.SIZE);
            builder.byteSizeField(Fields.TOTAL_IN_BYTES, Fields.TOTAL, this.totalBytes());
            builder.byteSizeField(Fields.REUSED_IN_BYTES, Fields.REUSED, this.reusedBytes());
            builder.byteSizeField(Fields.RECOVERED_IN_BYTES, Fields.RECOVERED, this.recoveredBytes());
            builder.field(Fields.PERCENT, String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.recoveredBytesPercent())));
            builder.endObject();
            builder.startObject(Fields.FILES);
            builder.field(Fields.TOTAL, this.totalFileCount());
            builder.field(Fields.REUSED, this.reusedFileCount());
            builder.field(Fields.RECOVERED, this.recoveredFileCount());
            builder.field(Fields.PERCENT, String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.recoveredFilesPercent())));
            if (params.paramAsBoolean("details", false)) {
                builder.startArray(Fields.DETAILS);
                for (File file : this.fileDetails.values()) {
                    file.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.time());
            builder.timeValueField(Fields.SOURCE_THROTTLE_TIME_IN_MILLIS, Fields.SOURCE_THROTTLE_TIME, this.sourceThrottling());
            builder.timeValueField(Fields.TARGET_THROTTLE_TIME_IN_MILLIS, Fields.TARGET_THROTTLE_TIME, this.targetThrottling());
            return builder;
        }

        public synchronized String toString() {
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
                builder.startObject();
                this.toXContent(builder, EMPTY_PARAMS);
                builder.endObject();
                return builder.string();
            }
            catch (IOException e) {
                return "{ \"error\" : \"" + e.getMessage() + "\"}";
            }
        }
    }

    public static class File
    implements ToXContent,
    Streamable {
        private String name;
        private long length;
        private long recovered;
        private boolean reused;

        public File() {
        }

        public File(String name, long length, boolean reused) {
            assert (name != null);
            this.name = name;
            this.length = length;
            this.reused = reused;
        }

        void addRecoveredBytes(long bytes) {
            assert (!this.reused) : "file is marked as reused, can't update recovered bytes";
            assert (bytes >= 0L) : "can't recovered negative bytes. got [" + bytes + "]";
            this.recovered += bytes;
        }

        public String name() {
            return this.name;
        }

        public long length() {
            return this.length;
        }

        public long recovered() {
            return this.recovered;
        }

        public boolean reused() {
            return this.reused;
        }

        boolean fullyRecovered() {
            return !this.reused && this.length == this.recovered;
        }

        public static File readFile(StreamInput in) throws IOException {
            File file = new File();
            file.readFrom(in);
            return file;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.length = in.readVLong();
            this.recovered = in.readVLong();
            this.reused = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.length);
            out.writeVLong(this.recovered);
            out.writeBoolean(this.reused);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.NAME, this.name);
            builder.byteSizeField(Fields.LENGTH_IN_BYTES, Fields.LENGTH, this.length);
            builder.field(Fields.REUSED, this.reused);
            builder.byteSizeField(Fields.RECOVERED_IN_BYTES, Fields.RECOVERED, this.recovered);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object obj) {
            if (obj instanceof File) {
                File other = (File)obj;
                return this.name.equals(other.name) && this.length == other.length() && this.reused == other.reused() && this.recovered == other.recovered();
            }
            return false;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + (int)(this.recovered ^ this.recovered >>> 32);
            result = 31 * result + (this.reused ? 1 : 0);
            return result;
        }

        public String toString() {
            return "file (name [" + this.name + "], reused [" + this.reused + "], length [" + this.length + "], recovered [" + this.recovered + "])";
        }
    }

    public static class Translog
    extends Timer
    implements ToXContent,
    Streamable {
        public static final int UNKNOWN = -1;
        private int recovered;
        private int total = -1;
        private int totalOnStart = -1;

        @Override
        public synchronized void reset() {
            super.reset();
            this.recovered = 0;
            this.total = -1;
            this.totalOnStart = -1;
        }

        public synchronized void incrementRecoveredOperations() {
            ++this.recovered;
            assert (this.total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + this.total + "], recovered [" + this.recovered + "]";
        }

        public synchronized void decrementRecoveredOperations(int ops) {
            this.recovered -= ops;
            assert (this.recovered >= 0) : "recovered operations must be non-negative. Because [" + this.recovered + "] after decrementing [" + ops + "]";
            assert (this.total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + this.total + "], recovered [" + this.recovered + "]";
        }

        public synchronized int recoveredOperations() {
            return this.recovered;
        }

        public synchronized int totalOperations() {
            return this.total;
        }

        public synchronized void totalOperations(int total) {
            this.total = total;
            assert (total == -1 || total >= this.recovered) : "total, if known, should be > recovered. total [" + total + "], recovered [" + this.recovered + "]";
        }

        public synchronized int totalOperationsOnStart() {
            return this.totalOnStart;
        }

        public synchronized void totalOperationsOnStart(int total) {
            this.totalOnStart = total;
        }

        public synchronized float recoveredPercent() {
            if (this.total == -1) {
                return -1.0f;
            }
            if (this.total == 0) {
                return 100.0f;
            }
            return (float)this.recovered * 100.0f / (float)this.total;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.recovered = in.readVInt();
            this.total = in.readVInt();
            this.totalOnStart = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.recovered);
            out.writeVInt(this.total);
            out.writeVInt(this.totalOnStart);
        }

        @Override
        public synchronized XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(Fields.RECOVERED, this.recovered);
            builder.field(Fields.TOTAL, this.total);
            builder.field(Fields.PERCENT, String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.recoveredPercent())));
            builder.field(Fields.TOTAL_ON_START, this.totalOnStart);
            builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.time());
            return builder;
        }
    }

    public static class VerifyIndex
    extends Timer
    implements ToXContent,
    Streamable {
        private volatile long checkIndexTime;

        @Override
        public void reset() {
            super.reset();
            this.checkIndexTime = 0L;
        }

        public long checkIndexTime() {
            return this.checkIndexTime;
        }

        public void checkIndexTime(long checkIndexTime) {
            this.checkIndexTime = checkIndexTime;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.checkIndexTime = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.checkIndexTime);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.timeValueField(Fields.CHECK_INDEX_TIME_IN_MILLIS, Fields.CHECK_INDEX_TIME, this.checkIndexTime);
            builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.time());
            return builder;
        }
    }

    public static class Timer
    implements Streamable {
        protected long startTime = 0L;
        protected long startNanoTime = 0L;
        protected long time = -1L;
        protected long stopTime = 0L;

        public synchronized void start() {
            assert (this.startTime == 0L) : "already started";
            this.startTime = System.currentTimeMillis();
            this.startNanoTime = System.nanoTime();
        }

        public synchronized long startTime() {
            return this.startTime;
        }

        public synchronized long time() {
            if (this.startNanoTime == 0L) {
                return 0L;
            }
            if (this.time >= 0L) {
                return this.time;
            }
            return Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - this.startNanoTime));
        }

        public synchronized long stopTime() {
            return this.stopTime;
        }

        public synchronized void stop() {
            assert (this.stopTime == 0L) : "already stopped";
            this.stopTime = Math.max(System.currentTimeMillis(), this.startTime);
            this.time = TimeValue.nsecToMSec(System.nanoTime() - this.startNanoTime);
            assert (this.time >= 0L);
        }

        public synchronized void reset() {
            this.startTime = 0L;
            this.startNanoTime = 0L;
            this.time = -1L;
            this.stopTime = 0L;
        }

        @Override
        public synchronized void readFrom(StreamInput in) throws IOException {
            this.startTime = in.readVLong();
            this.startNanoTime = in.readVLong();
            this.stopTime = in.readVLong();
            this.time = in.readVLong();
        }

        @Override
        public synchronized void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.startTime);
            out.writeVLong(this.startNanoTime);
            out.writeVLong(this.stopTime);
            out.writeVLong(this.time());
        }
    }

    static final class Fields {
        static final XContentBuilderString ID = new XContentBuilderString("id");
        static final XContentBuilderString TYPE = new XContentBuilderString("type");
        static final XContentBuilderString STAGE = new XContentBuilderString("stage");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString START_TIME_IN_MILLIS = new XContentBuilderString("start_time_in_millis");
        static final XContentBuilderString STOP_TIME = new XContentBuilderString("stop_time");
        static final XContentBuilderString STOP_TIME_IN_MILLIS = new XContentBuilderString("stop_time_in_millis");
        static final XContentBuilderString TOTAL_TIME = new XContentBuilderString("total_time");
        static final XContentBuilderString TOTAL_TIME_IN_MILLIS = new XContentBuilderString("total_time_in_millis");
        static final XContentBuilderString SOURCE = new XContentBuilderString("source");
        static final XContentBuilderString HOST = new XContentBuilderString("host");
        static final XContentBuilderString TRANSPORT_ADDRESS = new XContentBuilderString("transport_address");
        static final XContentBuilderString IP = new XContentBuilderString("ip");
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString TARGET = new XContentBuilderString("target");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString TRANSLOG = new XContentBuilderString("translog");
        static final XContentBuilderString TOTAL_ON_START = new XContentBuilderString("total_on_start");
        static final XContentBuilderString VERIFY_INDEX = new XContentBuilderString("verify_index");
        static final XContentBuilderString RECOVERED = new XContentBuilderString("recovered");
        static final XContentBuilderString RECOVERED_IN_BYTES = new XContentBuilderString("recovered_in_bytes");
        static final XContentBuilderString CHECK_INDEX_TIME = new XContentBuilderString("check_index_time");
        static final XContentBuilderString CHECK_INDEX_TIME_IN_MILLIS = new XContentBuilderString("check_index_time_in_millis");
        static final XContentBuilderString LENGTH = new XContentBuilderString("length");
        static final XContentBuilderString LENGTH_IN_BYTES = new XContentBuilderString("length_in_bytes");
        static final XContentBuilderString FILES = new XContentBuilderString("files");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_IN_BYTES = new XContentBuilderString("total_in_bytes");
        static final XContentBuilderString REUSED = new XContentBuilderString("reused");
        static final XContentBuilderString REUSED_IN_BYTES = new XContentBuilderString("reused_in_bytes");
        static final XContentBuilderString PERCENT = new XContentBuilderString("percent");
        static final XContentBuilderString DETAILS = new XContentBuilderString("details");
        static final XContentBuilderString SIZE = new XContentBuilderString("size");
        static final XContentBuilderString SOURCE_THROTTLE_TIME = new XContentBuilderString("source_throttle_time");
        static final XContentBuilderString SOURCE_THROTTLE_TIME_IN_MILLIS = new XContentBuilderString("source_throttle_time_in_millis");
        static final XContentBuilderString TARGET_THROTTLE_TIME = new XContentBuilderString("target_throttle_time");
        static final XContentBuilderString TARGET_THROTTLE_TIME_IN_MILLIS = new XContentBuilderString("target_throttle_time_in_millis");

        Fields() {
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type STORE = new Type(0);
        public static final /* enum */ Type SNAPSHOT = new Type(1);
        public static final /* enum */ Type REPLICA = new Type(2);
        public static final /* enum */ Type RELOCATION = new Type(3);
        private static final Type[] TYPES;
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Type fromId(byte id) {
            if (id < 0 || id >= TYPES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return TYPES[id];
        }

        static {
            $VALUES = new Type[]{STORE, SNAPSHOT, REPLICA, RELOCATION};
            TYPES = new Type[Type.values().length];
            for (Type type : Type.values()) {
                assert (type.id() < TYPES.length && type.id() >= 0);
                Type.TYPES[type.id] = type;
            }
        }
    }

    public static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage INIT = new Stage(0);
        public static final /* enum */ Stage INDEX = new Stage(1);
        public static final /* enum */ Stage VERIFY_INDEX = new Stage(2);
        public static final /* enum */ Stage TRANSLOG = new Stage(3);
        public static final /* enum */ Stage FINALIZE = new Stage(4);
        public static final /* enum */ Stage DONE = new Stage(5);
        private static final Stage[] STAGES;
        private final byte id;
        private static final /* synthetic */ Stage[] $VALUES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String name) {
            return Enum.valueOf(Stage.class, name);
        }

        private Stage(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Stage fromId(byte id) {
            if (id < 0 || id >= STAGES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return STAGES[id];
        }

        static {
            $VALUES = new Stage[]{INIT, INDEX, VERIFY_INDEX, TRANSLOG, FINALIZE, DONE};
            STAGES = new Stage[Stage.values().length];
            for (Stage stage : Stage.values()) {
                assert (stage.id() < STAGES.length && stage.id() >= 0);
                Stage.STAGES[stage.id] = stage;
            }
        }
    }
}

