/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.apache.lucene.util.Constants;
import org.elasticsearch.monitor.Probes;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsStats;

public class OsProbe {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getFreePhysicalMemorySize = OsProbe.getMethod("getFreePhysicalMemorySize");
    private static final Method getTotalPhysicalMemorySize = OsProbe.getMethod("getTotalPhysicalMemorySize");
    private static final Method getFreeSwapSpaceSize = OsProbe.getMethod("getFreeSwapSpaceSize");
    private static final Method getTotalSwapSpaceSize = OsProbe.getMethod("getTotalSwapSpaceSize");
    private static final Method getSystemLoadAverage = OsProbe.getMethod("getSystemLoadAverage");
    private static final Method getSystemCpuLoad = OsProbe.getMethod("getSystemCpuLoad");

    public long getFreePhysicalMemorySize() {
        if (getFreePhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getFreePhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public long getTotalPhysicalMemorySize() {
        if (getTotalPhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalPhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public long getFreeSwapSpaceSize() {
        if (getFreeSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getFreeSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public long getTotalSwapSpaceSize() {
        if (getTotalSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public double getSystemLoadAverage() {
        if (getSystemLoadAverage == null) {
            return -1.0;
        }
        try {
            return (Double)getSystemLoadAverage.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Throwable t) {
            return -1.0;
        }
    }

    public short getSystemCpuPercent() {
        return Probes.getLoadAndScaleToPercent(getSystemCpuLoad, osMxBean);
    }

    public static OsProbe getInstance() {
        return OsProbeHolder.INSTANCE;
    }

    private OsProbe() {
    }

    public OsInfo osInfo() {
        OsInfo info = new OsInfo();
        info.availableProcessors = Runtime.getRuntime().availableProcessors();
        info.name = Constants.OS_NAME;
        info.arch = Constants.OS_ARCH;
        info.version = Constants.OS_VERSION;
        return info;
    }

    public OsStats osStats() {
        OsStats stats = new OsStats();
        stats.timestamp = System.currentTimeMillis();
        stats.cpuPercent = this.getSystemCpuPercent();
        stats.loadAverage = this.getSystemLoadAverage();
        OsStats.Mem mem = new OsStats.Mem();
        mem.total = this.getTotalPhysicalMemorySize();
        mem.free = this.getFreePhysicalMemorySize();
        stats.mem = mem;
        OsStats.Swap swap = new OsStats.Swap();
        swap.total = this.getTotalSwapSpaceSize();
        swap.free = this.getFreeSwapSpaceSize();
        stats.swap = swap;
        return stats;
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class OsProbeHolder {
        private static final OsProbe INSTANCE = new OsProbe();

        private OsProbeHolder() {
        }
    }
}

