/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.settings;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;

public class NodeSettingsService
extends AbstractComponent
implements ClusterStateListener {
    private static volatile Settings globalSettings = Settings.Builder.EMPTY_SETTINGS;
    private volatile Settings lastSettingsApplied;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    public static Settings getGlobalSettings() {
        return globalSettings;
    }

    @Inject
    public NodeSettingsService(Settings settings) {
        super(settings);
        globalSettings = settings;
    }

    public void setClusterService(ClusterService clusterService) {
        clusterService.add(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        if (!event.metaDataChanged()) {
            return;
        }
        if (this.lastSettingsApplied != null && event.state().metaData().settings().equals(this.lastSettingsApplied)) {
            return;
        }
        for (Listener listener : this.listeners) {
            try {
                listener.onRefreshSettings(event.state().metaData().settings());
            }
            catch (Exception e) {
                this.logger.warn("failed to refresh settings for [{}]", e, listener);
            }
        }
        try {
            for (Map.Entry entry : event.state().metaData().settings().getAsMap().entrySet()) {
                if (!((String)entry.getKey()).startsWith("logger.")) continue;
                String component = ((String)entry.getKey()).substring("logger.".length());
                if ("_root".equals(component)) {
                    ESLoggerFactory.getRootLogger().setLevel((String)entry.getValue());
                    continue;
                }
                ESLoggerFactory.getLogger(component).setLevel((String)entry.getValue());
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to refresh settings for [{}]", e, "logger");
        }
        globalSettings = this.lastSettingsApplied = event.state().metaData().settings();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static interface Listener {
        public void onRefreshSettings(Settings var1);
    }
}

