/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptContextRegistry;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptMode;
import org.elasticsearch.script.ScriptService;

public class ScriptModes {
    static final String SCRIPT_SETTINGS_PREFIX = "script.";
    static final String ENGINE_SETTINGS_PREFIX = "script.engine";
    final ImmutableMap<String, ScriptMode> scriptModes;

    ScriptModes(Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, Settings settings) {
        HashMap filteredEngines = Maps.newHashMap(scriptEngines);
        filteredEngines.remove("native");
        this.scriptModes = ScriptModes.buildScriptModeSettingsMap(settings, filteredEngines, scriptContextRegistry);
    }

    private static ImmutableMap<String, ScriptMode> buildScriptModeSettingsMap(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry) {
        HashMap scriptModesMap = Maps.newHashMap();
        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.FILE, ScriptMode.ON, scriptModesMap);
        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INDEXED, ScriptMode.SANDBOX, scriptModesMap);
        ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, ScriptService.ScriptType.INLINE, ScriptMode.SANDBOX, scriptModesMap);
        ScriptModes.processSourceBasedGlobalSettings(settings, scriptEngines, scriptContextRegistry, scriptModesMap);
        ScriptModes.processOperationBasedGlobalSettings(settings, scriptEngines, scriptContextRegistry, scriptModesMap);
        ScriptModes.processEngineSpecificSettings(settings, scriptEngines, scriptContextRegistry, scriptModesMap);
        return ImmutableMap.copyOf((Map)scriptModesMap);
    }

    private static void processSourceBasedGlobalSettings(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, Map<String, ScriptMode> scriptModes) {
        for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
            String scriptTypeSetting = settings.get(SCRIPT_SETTINGS_PREFIX + (Object)((Object)scriptType));
            if (!Strings.hasLength(scriptTypeSetting)) continue;
            ScriptMode scriptTypeMode = ScriptMode.parse(scriptTypeSetting);
            ScriptModes.addGlobalScriptTypeModes(scriptEngines.keySet(), scriptContextRegistry, scriptType, scriptTypeMode, scriptModes);
        }
    }

    private static void processOperationBasedGlobalSettings(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, Map<String, ScriptMode> scriptModes) {
        for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
            ScriptMode scriptMode = ScriptModes.getScriptContextMode(settings, SCRIPT_SETTINGS_PREFIX, scriptContext);
            if (scriptMode == null) continue;
            ScriptModes.addGlobalScriptContextModes(scriptEngines.keySet(), scriptContext, scriptMode, scriptModes);
        }
    }

    private static void processEngineSpecificSettings(Settings settings, Map<String, ScriptEngineService> scriptEngines, ScriptContextRegistry scriptContextRegistry, Map<String, ScriptMode> scriptModes) {
        Map<String, Settings> langGroupedSettings = settings.getGroups(ENGINE_SETTINGS_PREFIX, true);
        for (Map.Entry<String, Settings> langSettings : langGroupedSettings.entrySet()) {
            ScriptEngineService scriptEngineService = scriptEngines.get(langSettings.getKey());
            if (scriptEngineService == null) continue;
            for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
                String scriptTypePrefix = (Object)((Object)scriptType) + ".";
                for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
                    ScriptMode scriptMode = ScriptModes.getScriptContextMode(langSettings.getValue(), scriptTypePrefix, scriptContext);
                    if (scriptMode == null) continue;
                    ScriptModes.addScriptMode(scriptEngineService, scriptType, scriptContext, scriptMode, scriptModes);
                }
            }
        }
    }

    private static ScriptMode getScriptContextMode(Settings settings, String prefix, ScriptContext scriptContext) {
        String settingValue = settings.get(prefix + scriptContext.getKey());
        if (Strings.hasLength(settingValue)) {
            return ScriptMode.parse(settingValue);
        }
        return null;
    }

    private static void addGlobalScriptTypeModes(Set<String> langs, ScriptContextRegistry scriptContextRegistry, ScriptService.ScriptType scriptType, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        for (String lang : langs) {
            for (ScriptContext scriptContext : scriptContextRegistry.scriptContexts()) {
                ScriptModes.addScriptMode(lang, scriptType, scriptContext, scriptMode, scriptModes);
            }
        }
    }

    private static void addGlobalScriptContextModes(Set<String> langs, ScriptContext scriptContext, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        for (String lang : langs) {
            for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
                ScriptModes.addScriptMode(lang, scriptType, scriptContext, scriptMode, scriptModes);
            }
        }
    }

    private static void addScriptMode(ScriptEngineService scriptEngineService, ScriptService.ScriptType scriptType, ScriptContext scriptContext, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        for (String scriptEngineName : scriptEngineService.types()) {
            ScriptModes.addScriptMode(scriptEngineName, scriptType, scriptContext, scriptMode, scriptModes);
        }
    }

    private static void addScriptMode(String lang, ScriptService.ScriptType scriptType, ScriptContext scriptContext, ScriptMode scriptMode, Map<String, ScriptMode> scriptModes) {
        scriptModes.put("script.engine." + lang + "." + (Object)((Object)scriptType) + "." + scriptContext.getKey(), scriptMode);
    }

    public ScriptMode getScriptMode(String lang, ScriptService.ScriptType scriptType, ScriptContext scriptContext) {
        if ("native".equals(lang)) {
            return ScriptMode.ON;
        }
        ScriptMode scriptMode = (ScriptMode)((Object)this.scriptModes.get((Object)("script.engine." + lang + "." + (Object)((Object)scriptType) + "." + scriptContext.getKey())));
        if (scriptMode == null) {
            throw new IllegalArgumentException("script mode not found for lang [" + lang + "], script_type [" + (Object)((Object)scriptType) + "], operation [" + scriptContext.getKey() + "]");
        }
        return scriptMode;
    }

    public String toString() {
        TreeMap<String, ScriptMode> scriptModesTreeMap = new TreeMap<String, ScriptMode>();
        scriptModesTreeMap.putAll((Map<String, ScriptMode>)this.scriptModes);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry stringScriptModeEntry : scriptModesTreeMap.entrySet()) {
            stringBuilder.append((String)stringScriptModeEntry.getKey()).append(": ").append(stringScriptModeEntry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }
}

