/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import com.carrotsearch.hppc.LongIntHashMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.elasticsearch.search.aggregations.bucket.nested.NestedAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class ReverseNestedAggregator
extends SingleBucketAggregator {
    private final Query parentFilter;
    private final BitSetProducer parentBitsetProducer;

    public ReverseNestedAggregator(String name, AggregatorFactories factories, ObjectMapper objectMapper, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.parentFilter = objectMapper == null ? Queries.newNonNestedFilter() : objectMapper.nestedTypeFilter();
        this.parentBitsetProducer = this.context.searchContext().bitsetFilterCache().getBitSetProducer(this.parentFilter);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final BitSet parentDocs = this.parentBitsetProducer.getBitSet(ctx);
        if (parentDocs == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final LongIntHashMap bucketOrdToLastCollectedParentDoc = new LongIntHashMap(32);
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int childDoc, long bucket) throws IOException {
                int parentDoc = parentDocs.nextSetBit(childDoc);
                assert (childDoc <= parentDoc && parentDoc != Integer.MAX_VALUE);
                int keySlot = bucketOrdToLastCollectedParentDoc.indexOf(bucket);
                if (bucketOrdToLastCollectedParentDoc.indexExists(keySlot)) {
                    int lastCollectedParentDoc = bucketOrdToLastCollectedParentDoc.indexGet(keySlot);
                    if (parentDoc > lastCollectedParentDoc) {
                        ReverseNestedAggregator.this.collectBucket(sub, parentDoc, bucket);
                        bucketOrdToLastCollectedParentDoc.indexReplace(keySlot, parentDoc);
                    }
                } else {
                    ReverseNestedAggregator.this.collectBucket(sub, parentDoc, bucket);
                    bucketOrdToLastCollectedParentDoc.indexInsert(keySlot, bucket, parentDoc);
                }
            }
        };
    }

    private static NestedAggregator findClosestNestedAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof NestedAggregator) {
                return (NestedAggregator)parent;
            }
            parent = parent.parent();
        }
        return null;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalReverseNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    Query getParentFilter() {
        return this.parentFilter;
    }

    public static class Factory
    extends AggregatorFactory {
        private final String path;

        public Factory(String name, String path) {
            super(name, InternalReverseNested.TYPE.name());
            this.path = path;
        }

        @Override
        public Aggregator createInternal(AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            ObjectMapper objectMapper;
            NestedAggregator closestNestedAggregator = ReverseNestedAggregator.findClosestNestedAggregator(parent);
            if (closestNestedAggregator == null) {
                throw new SearchParseException(context.searchContext(), "Reverse nested aggregation [" + this.name + "] can only be used inside a [nested] aggregation", null);
            }
            if (this.path != null) {
                objectMapper = context.searchContext().getObjectMapper(this.path);
                if (objectMapper == null) {
                    return new Unmapped(this.name, context, parent, pipelineAggregators, metaData);
                }
                if (!objectMapper.nested().isNested()) {
                    throw new AggregationExecutionException("[reverse_nested] nested path [" + this.path + "] is not nested");
                }
            } else {
                objectMapper = null;
            }
            return new ReverseNestedAggregator(this.name, this.factories, objectMapper, context, parent, pipelineAggregators, metaData);
        }

        private static final class Unmapped
        extends NonCollectingAggregator {
            public Unmapped(String name, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                super(name, context, parent, pipelineAggregators, metaData);
            }

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return new InternalReverseNested(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
            }
        }
    }
}

