/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range.ipv4;

import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.ipv4.InternalIPv4Range;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class IPv4RangeBuilder
extends AbstractRangeBuilder<IPv4RangeBuilder> {
    public IPv4RangeBuilder(String name) {
        super(name, InternalIPv4Range.TYPE.name());
    }

    public IPv4RangeBuilder addRange(String key, String from, String to) {
        this.ranges.add(new AbstractRangeBuilder.Range(key, from, to));
        return this;
    }

    public IPv4RangeBuilder addMaskRange(String mask) {
        return this.addMaskRange(mask, mask);
    }

    public IPv4RangeBuilder addMaskRange(String key, String mask) {
        long[] fromTo = IpFieldMapper.cidrMaskToMinMax(mask);
        if (fromTo == null) {
            throw new SearchSourceBuilderException("invalid CIDR mask [" + mask + "] in ip_range aggregation [" + this.getName() + "]");
        }
        this.ranges.add(new AbstractRangeBuilder.Range(key, fromTo[0] < 0L ? null : Long.valueOf(fromTo[0]), fromTo[1] < 0L ? null : Long.valueOf(fromTo[1])));
        return this;
    }

    public IPv4RangeBuilder addRange(String from, String to) {
        return this.addRange(null, from, to);
    }

    public IPv4RangeBuilder addUnboundedTo(String key, String to) {
        this.ranges.add(new AbstractRangeBuilder.Range(key, null, to));
        return this;
    }

    public IPv4RangeBuilder addUnboundedTo(String to) {
        return this.addUnboundedTo(null, to);
    }

    public IPv4RangeBuilder addUnboundedFrom(String key, String from) {
        this.ranges.add(new AbstractRangeBuilder.Range(key, from, null));
        return this;
    }

    public IPv4RangeBuilder addUnboundedFrom(String from) {
        return this.addUnboundedFrom(null, from);
    }
}

