/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class PipelineAggregatorBuilder<B extends PipelineAggregatorBuilder<B>>
extends AbstractAggregationBuilder {
    private String[] bucketsPaths;
    private Map<String, Object> metaData;

    protected PipelineAggregatorBuilder(String name, String type) {
        super(name, type);
    }

    public B setBucketsPaths(String ... bucketsPaths) {
        this.bucketsPaths = bucketsPaths;
        return (B)this;
    }

    public B setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
        return (B)this;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.metaData != null) {
            builder.field("meta", this.metaData);
        }
        builder.startObject(this.type);
        if (this.bucketsPaths != null) {
            builder.startArray(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName());
            for (String path : this.bucketsPaths) {
                builder.value(path);
            }
            builder.endArray();
        }
        this.internalXContent(builder, params);
        builder.endObject();
        return builder.endObject();
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

