/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.having;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorBuilder;
import org.elasticsearch.search.aggregations.pipeline.having.BucketSelectorParser;
import org.elasticsearch.search.aggregations.pipeline.having.BucketSelectorPipelineAggregator;

public class BucketSelectorBuilder
extends PipelineAggregatorBuilder<BucketSelectorBuilder> {
    private BucketHelpers.GapPolicy gapPolicy;
    private Script script;
    private Map<String, String> bucketsPathsMap;

    public BucketSelectorBuilder(String name) {
        super(name, BucketSelectorPipelineAggregator.TYPE.name());
    }

    public BucketSelectorBuilder script(Script script) {
        this.script = script;
        return this;
    }

    public BucketSelectorBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketSelectorBuilder setBucketsPathsMap(Map<String, String> bucketsPathsMap) {
        this.bucketsPathsMap = bucketsPathsMap;
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        if (this.script != null) {
            builder.field(Script.ScriptField.SCRIPT.getPreferredName(), this.script);
        }
        if (this.gapPolicy != null) {
            builder.field(BucketSelectorParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        if (this.bucketsPathsMap != null) {
            builder.field(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName(), (Object)this.bucketsPathsMap);
        }
        return builder;
    }
}

